/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events.user;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.user.SlackMemberLeftChannelEventIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackMemberLeftChannelEventIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackMemberLeftChannelEvent
implements SlackMemberLeftChannelEventIF {
    private final SlackEventType type;
    private final String userId;
    private final String channelId;
    private final ChannelType channelType;
    private final String team;

    private SlackMemberLeftChannelEvent(SlackEventType type, String userId, String channelId, ChannelType channelType, String team) {
        this.type = type;
        this.userId = userId;
        this.channelId = channelId;
        this.channelType = channelType;
        this.team = team;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="user")
    public String getUserId() {
        return this.userId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public ChannelType getChannelType() {
        return this.channelType;
    }

    @Override
    @JsonProperty
    public String getTeam() {
        return this.team;
    }

    public final SlackMemberLeftChannelEvent withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackMemberLeftChannelEvent(newValue, this.userId, this.channelId, this.channelType, this.team);
    }

    public final SlackMemberLeftChannelEvent withUserId(String value) {
        String newValue = Objects.requireNonNull(value, "userId");
        if (this.userId.equals(newValue)) {
            return this;
        }
        return new SlackMemberLeftChannelEvent(this.type, newValue, this.channelId, this.channelType, this.team);
    }

    public final SlackMemberLeftChannelEvent withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackMemberLeftChannelEvent(this.type, this.userId, newValue, this.channelType, this.team);
    }

    public final SlackMemberLeftChannelEvent withChannelType(ChannelType value) {
        ChannelType newValue = Objects.requireNonNull(value, "channelType");
        if (this.channelType == newValue) {
            return this;
        }
        return new SlackMemberLeftChannelEvent(this.type, this.userId, this.channelId, newValue, this.team);
    }

    public final SlackMemberLeftChannelEvent withTeam(String value) {
        String newValue = Objects.requireNonNull(value, "team");
        if (this.team.equals(newValue)) {
            return this;
        }
        return new SlackMemberLeftChannelEvent(this.type, this.userId, this.channelId, this.channelType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackMemberLeftChannelEvent && this.equalTo(0, (SlackMemberLeftChannelEvent)another);
    }

    private boolean equalTo(int synthetic, SlackMemberLeftChannelEvent another) {
        return this.type.equals((Object)another.type) && this.userId.equals(another.userId) && this.channelId.equals(another.channelId) && this.channelType.equals((Object)another.channelType) && this.team.equals(another.team);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.userId.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.channelType.hashCode();
        h += (h << 5) + this.team.hashCode();
        return h;
    }

    public String toString() {
        return "SlackMemberLeftChannelEvent{type=" + this.type + ", userId=" + this.userId + ", channelId=" + this.channelId + ", channelType=" + this.channelType + ", team=" + this.team + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackMemberLeftChannelEvent fromJson(Json json) {
        Builder builder = SlackMemberLeftChannelEvent.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.channelType != null) {
            builder.setChannelType(json.channelType);
        }
        if (json.team != null) {
            builder.setTeam(json.team);
        }
        return builder.build();
    }

    public static SlackMemberLeftChannelEvent copyOf(SlackMemberLeftChannelEventIF instance) {
        if (instance instanceof SlackMemberLeftChannelEvent) {
            return (SlackMemberLeftChannelEvent)instance;
        }
        return SlackMemberLeftChannelEvent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackMemberLeftChannelEventIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_USER_ID = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_CHANNEL_TYPE = 8L;
        private static final long INIT_BIT_TEAM = 16L;
        private long initBits = 31L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String userId;
        @Nullable
        private String channelId;
        @Nullable
        private ChannelType channelType;
        @Nullable
        private String team;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackMemberLeftChannelEventIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
            }
            if (object instanceof SlackMemberLeftChannelEventIF) {
                instance = (SlackMemberLeftChannelEventIF)object;
                this.setChannelType(instance.getChannelType());
                this.setTeam(instance.getTeam());
                if ((bits & 1L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 1L;
                }
                this.setUserId(instance.getUserId());
                if ((bits & 2L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 2L;
                }
            }
        }

        @JsonProperty
        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="user")
        public final Builder setUserId(String userId) {
            this.userId = Objects.requireNonNull(userId, "userId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="channel")
        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty
        public final Builder setChannelType(ChannelType channelType) {
            this.channelType = Objects.requireNonNull(channelType, "channelType");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @JsonProperty
        public final Builder setTeam(String team) {
            this.team = Objects.requireNonNull(team, "team");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        public SlackMemberLeftChannelEvent build() {
            this.checkRequiredAttributes();
            return new SlackMemberLeftChannelEvent(this.type, this.userId, this.channelId, this.channelType, this.team);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean userIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean channelTypeIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private boolean teamIsSet() {
            return (this.initBits & 0x10L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.userIdIsSet()) {
                attributes.add("userId");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.channelTypeIsSet()) {
                attributes.add("channelType");
            }
            if (!this.teamIsSet()) {
                attributes.add("team");
            }
            return "Cannot build SlackMemberLeftChannelEvent, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackMemberLeftChannelEventIF", generator="Immutables")
    static final class Json
    implements SlackMemberLeftChannelEventIF {
        @Nullable
        SlackEventType type;
        @Nullable
        String userId;
        @Nullable
        String channelId;
        @Nullable
        ChannelType channelType;
        @Nullable
        String team;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty(value="user")
        public void setUserId(String userId) {
            this.userId = userId;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setChannelType(ChannelType channelType) {
            this.channelType = channelType;
        }

        @JsonProperty
        public void setTeam(String team) {
            this.team = team;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeam() {
            throw new UnsupportedOperationException();
        }
    }
}

