/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.events;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.events.AbstractSlackEventMessageReplied;
import com.hubspot.slack.client.models.events.SlackEvent;
import com.hubspot.slack.client.models.events.SlackEventMessageBase;
import com.hubspot.slack.client.models.events.SlackEventType;
import com.hubspot.slack.client.models.events.SlackMessageSubtype;
import com.hubspot.slack.client.models.events.util.SlackReplyMessage;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractSlackEventMessageReplied", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackEventMessageReplied
extends AbstractSlackEventMessageReplied {
    private final SlackEventType type;
    private final String ts;
    @Nullable
    private final SlackMessageSubtype subtype;
    private final List<Attachment> attachments;
    private final String channelId;
    private final SlackReplyMessage message;

    private SlackEventMessageReplied(SlackEventType type, String ts, @Nullable SlackMessageSubtype subtype, List<Attachment> attachments, String channelId, SlackReplyMessage message) {
        this.type = type;
        this.ts = ts;
        this.subtype = subtype;
        this.attachments = attachments;
        this.channelId = channelId;
        this.message = message;
    }

    @Override
    @JsonProperty
    public SlackEventType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getTs() {
        return this.ts;
    }

    @Override
    @JsonProperty
    public Optional<SlackMessageSubtype> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public SlackReplyMessage getMessage() {
        return this.message;
    }

    public final SlackEventMessageReplied withType(SlackEventType value) {
        SlackEventType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new SlackEventMessageReplied(newValue, this.ts, this.subtype, this.attachments, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withTs(String value) {
        String newValue = Objects.requireNonNull(value, "ts");
        if (this.ts.equals(newValue)) {
            return this;
        }
        return new SlackEventMessageReplied(this.type, newValue, this.subtype, this.attachments, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withSubtype(@Nullable SlackMessageSubtype value) {
        SlackMessageSubtype newValue = value;
        if (this.subtype == newValue) {
            return this;
        }
        return new SlackEventMessageReplied(this.type, this.ts, newValue, this.attachments, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withSubtype(Optional<? extends SlackMessageSubtype> optional) {
        SlackMessageSubtype value = optional.orElse(null);
        if (this.subtype == value) {
            return this;
        }
        return new SlackEventMessageReplied(this.type, this.ts, value, this.attachments, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withAttachments(Attachment ... elements) {
        List<Attachment> newValue = SlackEventMessageReplied.createUnmodifiableList(false, SlackEventMessageReplied.createSafeList(Arrays.asList(elements), true, false));
        return new SlackEventMessageReplied(this.type, this.ts, this.subtype, newValue, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = SlackEventMessageReplied.createUnmodifiableList(false, SlackEventMessageReplied.createSafeList(elements, true, false));
        return new SlackEventMessageReplied(this.type, this.ts, this.subtype, newValue, this.channelId, this.message);
    }

    public final SlackEventMessageReplied withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new SlackEventMessageReplied(this.type, this.ts, this.subtype, this.attachments, newValue, this.message);
    }

    public final SlackEventMessageReplied withMessage(SlackReplyMessage value) {
        if (this.message == value) {
            return this;
        }
        SlackReplyMessage newValue = Objects.requireNonNull(value, "message");
        return new SlackEventMessageReplied(this.type, this.ts, this.subtype, this.attachments, this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackEventMessageReplied && this.equalTo(0, (SlackEventMessageReplied)another);
    }

    private boolean equalTo(int synthetic, SlackEventMessageReplied another) {
        return this.type.equals((Object)another.type) && this.ts.equals(another.ts) && Objects.equals((Object)this.subtype, (Object)another.subtype) && this.attachments.equals(another.attachments) && this.channelId.equals(another.channelId) && this.message.equals(another.message);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.ts.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.subtype);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.message.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackEventMessageReplied{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("ts=").append(this.ts);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append((Object)this.subtype);
        }
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("message=").append(this.message);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackEventMessageReplied fromJson(Json json) {
        Builder builder = SlackEventMessageReplied.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.ts != null) {
            builder.setTs(json.ts);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.message != null) {
            builder.setMessage(json.message);
        }
        return builder.build();
    }

    public static SlackEventMessageReplied copyOf(AbstractSlackEventMessageReplied instance) {
        if (instance instanceof SlackEventMessageReplied) {
            return (SlackEventMessageReplied)instance;
        }
        return SlackEventMessageReplied.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="AbstractSlackEventMessageReplied", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TS = 2L;
        private static final long INIT_BIT_CHANNEL_ID = 4L;
        private static final long INIT_BIT_MESSAGE = 8L;
        private long initBits = 15L;
        @Nullable
        private SlackEventType type;
        @Nullable
        private String ts;
        @Nullable
        private SlackMessageSubtype subtype;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        @Nullable
        private String channelId;
        @Nullable
        private SlackReplyMessage message;

        private Builder() {
        }

        public final Builder from(AbstractSlackEventMessageReplied instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEvent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(SlackEventMessageBase instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<SlackMessageSubtype> subtypeOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof AbstractSlackEventMessageReplied) {
                instance = (AbstractSlackEventMessageReplied)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                this.setMessage(((AbstractSlackEventMessageReplied)instance).getMessage());
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(((AbstractSlackEventMessageReplied)instance).getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof SlackEvent) {
                instance = (SlackEvent)object;
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
            if (object instanceof SlackEventMessageBase) {
                instance = (SlackEventMessageBase)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(((SlackEventMessageBase)instance).getAttachments());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.setType(instance.getType());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    subtypeOptional = ((SlackEventMessageBase)instance).getSubtype();
                    if (subtypeOptional.isPresent()) {
                        this.setSubtype(subtypeOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.setTs(instance.getTs());
                    bits |= 0x10L;
                }
            }
        }

        public final Builder setType(SlackEventType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTs(String ts) {
            this.ts = Objects.requireNonNull(ts, "ts");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setSubtype(@Nullable SlackMessageSubtype subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<? extends SlackMessageSubtype> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setMessage(SlackReplyMessage message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public SlackEventMessageReplied build() {
            this.checkRequiredAttributes();
            return new SlackEventMessageReplied(this.type, this.ts, this.subtype, SlackEventMessageReplied.createUnmodifiableList(true, this.attachments), this.channelId, this.message);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean tsIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean messageIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.tsIsSet()) {
                attributes.add("ts");
            }
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.messageIsSet()) {
                attributes.add("message");
            }
            return "Cannot build SlackEventMessageReplied, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractSlackEventMessageReplied", generator="Immutables")
    static final class Json
    extends AbstractSlackEventMessageReplied {
        @Nullable
        SlackEventType type;
        @Nullable
        String ts;
        @Nullable
        Optional<SlackMessageSubtype> subtype = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        String channelId;
        @Nullable
        SlackReplyMessage message;

        Json() {
        }

        @JsonProperty
        public void setType(SlackEventType type) {
            this.type = type;
        }

        @JsonProperty
        public void setTs(String ts) {
            this.ts = ts;
        }

        @JsonProperty
        public void setSubtype(Optional<SlackMessageSubtype> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setMessage(SlackReplyMessage message) {
            this.message = message;
        }

        @Override
        public SlackEventType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackMessageSubtype> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public SlackReplyMessage getMessage() {
            throw new UnsupportedOperationException();
        }
    }
}

