/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.calls;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.models.calls.SlackInternalOrExternalUser;
import com.hubspot.slack.client.models.json.SlackOrExternalUserDeserializer;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@HubSpotStyle
@Value.Immutable
public interface SlackCallIF {
    public String getExternalUniqueId();

    public String getId();

    @JsonProperty(value="start_date")
    public Optional<Integer> getStartDateEpochSeconds();

    @JsonIgnore
    @Value.Derived
    default public Optional<Instant> getStartDate() {
        return this.getStartDateEpochSeconds().map(Instant::ofEpochSecond);
    }

    public Optional<String> getDesktopAppJoinUrl();

    public Optional<String> getExternalDisplayId();

    public Optional<String> getTitle();

    @JsonDeserialize(contentUsing=SlackOrExternalUserDeserializer.class)
    public List<SlackInternalOrExternalUser> getUsers();
}

