/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.calls.SlackCallIF;
import com.hubspot.slack.client.models.calls.SlackInternalOrExternalUser;
import com.hubspot.slack.client.models.json.SlackOrExternalUserDeserializer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackCallIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackCall
implements SlackCallIF {
    private final String externalUniqueId;
    private final String id;
    @Nullable
    private final Integer startDateEpochSeconds;
    private final transient Optional<Instant> startDate;
    @Nullable
    private final String desktopAppJoinUrl;
    @Nullable
    private final String externalDisplayId;
    @Nullable
    private final String title;
    private final List<SlackInternalOrExternalUser> users;

    private SlackCall(String externalUniqueId, String id, @Nullable Integer startDateEpochSeconds, @Nullable String desktopAppJoinUrl, @Nullable String externalDisplayId, @Nullable String title, List<SlackInternalOrExternalUser> users) {
        this.externalUniqueId = externalUniqueId;
        this.id = id;
        this.startDateEpochSeconds = startDateEpochSeconds;
        this.desktopAppJoinUrl = desktopAppJoinUrl;
        this.externalDisplayId = externalDisplayId;
        this.title = title;
        this.users = users;
        this.startDate = Objects.requireNonNull(SlackCallIF.super.getStartDate(), "startDate");
    }

    @Override
    @JsonProperty
    public String getExternalUniqueId() {
        return this.externalUniqueId;
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="start_date")
    public Optional<Integer> getStartDateEpochSeconds() {
        return Optional.ofNullable(this.startDateEpochSeconds);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Optional<Instant> getStartDate() {
        return this.startDate;
    }

    @Override
    @JsonProperty
    public Optional<String> getDesktopAppJoinUrl() {
        return Optional.ofNullable(this.desktopAppJoinUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalDisplayId() {
        return Optional.ofNullable(this.externalDisplayId);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=SlackOrExternalUserDeserializer.class)
    public List<SlackInternalOrExternalUser> getUsers() {
        return this.users;
    }

    public final SlackCall withExternalUniqueId(String value) {
        String newValue = Objects.requireNonNull(value, "externalUniqueId");
        if (this.externalUniqueId.equals(newValue)) {
            return this;
        }
        return new SlackCall(newValue, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, newValue, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withStartDateEpochSeconds(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.startDateEpochSeconds, newValue)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, newValue, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withStartDateEpochSeconds(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.startDateEpochSeconds, value)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, value, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withDesktopAppJoinUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.desktopAppJoinUrl, newValue)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, newValue, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withDesktopAppJoinUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.desktopAppJoinUrl, value)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, value, this.externalDisplayId, this.title, this.users);
    }

    public final SlackCall withExternalDisplayId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalDisplayId, newValue)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, newValue, this.title, this.users);
    }

    public final SlackCall withExternalDisplayId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalDisplayId, value)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, value, this.title, this.users);
    }

    public final SlackCall withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, newValue, this.users);
    }

    public final SlackCall withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, value, this.users);
    }

    public final SlackCall withUsers(SlackInternalOrExternalUser ... elements) {
        List<SlackInternalOrExternalUser> newValue = SlackCall.createUnmodifiableList(false, SlackCall.createSafeList(Arrays.asList(elements), true, false));
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, this.title, newValue);
    }

    public final SlackCall withUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<SlackInternalOrExternalUser> newValue = SlackCall.createUnmodifiableList(false, SlackCall.createSafeList(elements, true, false));
        return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackCall && this.equalTo(0, (SlackCall)another);
    }

    private boolean equalTo(int synthetic, SlackCall another) {
        return this.externalUniqueId.equals(another.externalUniqueId) && this.id.equals(another.id) && Objects.equals(this.startDateEpochSeconds, another.startDateEpochSeconds) && this.startDate.equals(another.startDate) && Objects.equals(this.desktopAppJoinUrl, another.desktopAppJoinUrl) && Objects.equals(this.externalDisplayId, another.externalDisplayId) && Objects.equals(this.title, another.title) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.externalUniqueId.hashCode();
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + Objects.hashCode(this.startDateEpochSeconds);
        h += (h << 5) + this.startDate.hashCode();
        h += (h << 5) + Objects.hashCode(this.desktopAppJoinUrl);
        h += (h << 5) + Objects.hashCode(this.externalDisplayId);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackCall{");
        builder.append("externalUniqueId=").append(this.externalUniqueId);
        builder.append(", ");
        builder.append("id=").append(this.id);
        if (this.startDateEpochSeconds != null) {
            builder.append(", ");
            builder.append("startDateEpochSeconds=").append(this.startDateEpochSeconds);
        }
        builder.append(", ");
        builder.append("startDate=").append(this.startDate);
        if (this.desktopAppJoinUrl != null) {
            builder.append(", ");
            builder.append("desktopAppJoinUrl=").append(this.desktopAppJoinUrl);
        }
        if (this.externalDisplayId != null) {
            builder.append(", ");
            builder.append("externalDisplayId=").append(this.externalDisplayId);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        builder.append(", ");
        builder.append("users=").append(this.users);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackCall fromJson(Json json) {
        Builder builder = SlackCall.builder();
        if (json.externalUniqueId != null) {
            builder.setExternalUniqueId(json.externalUniqueId);
        }
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.startDateEpochSeconds != null) {
            builder.setStartDateEpochSeconds(json.startDateEpochSeconds);
        }
        if (json.desktopAppJoinUrl != null) {
            builder.setDesktopAppJoinUrl(json.desktopAppJoinUrl);
        }
        if (json.externalDisplayId != null) {
            builder.setExternalDisplayId(json.externalDisplayId);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        return builder.build();
    }

    public static SlackCall copyOf(SlackCallIF instance) {
        if (instance instanceof SlackCall) {
            return (SlackCall)instance;
        }
        return SlackCall.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="SlackCallIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_UNIQUE_ID = 1L;
        private static final long INIT_BIT_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String externalUniqueId;
        @Nullable
        private String id;
        @Nullable
        private Integer startDateEpochSeconds;
        @Nullable
        private String desktopAppJoinUrl;
        @Nullable
        private String externalDisplayId;
        @Nullable
        private String title;
        private List<SlackInternalOrExternalUser> users = new ArrayList<SlackInternalOrExternalUser>();

        private Builder() {
        }

        public final Builder from(SlackCallIF instance) {
            Optional<String> titleOptional;
            Optional<String> externalDisplayIdOptional;
            Optional<String> desktopAppJoinUrlOptional;
            Objects.requireNonNull(instance, "instance");
            this.setExternalUniqueId(instance.getExternalUniqueId());
            this.setId(instance.getId());
            Optional<Integer> startDateEpochSecondsOptional = instance.getStartDateEpochSeconds();
            if (startDateEpochSecondsOptional.isPresent()) {
                this.setStartDateEpochSeconds(startDateEpochSecondsOptional);
            }
            if ((desktopAppJoinUrlOptional = instance.getDesktopAppJoinUrl()).isPresent()) {
                this.setDesktopAppJoinUrl(desktopAppJoinUrlOptional);
            }
            if ((externalDisplayIdOptional = instance.getExternalDisplayId()).isPresent()) {
                this.setExternalDisplayId(externalDisplayIdOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            this.addAllUsers(instance.getUsers());
            return this;
        }

        public final Builder setExternalUniqueId(String externalUniqueId) {
            this.externalUniqueId = Objects.requireNonNull(externalUniqueId, "externalUniqueId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setStartDateEpochSeconds(@Nullable Integer startDateEpochSeconds) {
            this.startDateEpochSeconds = startDateEpochSeconds;
            return this;
        }

        public final Builder setStartDateEpochSeconds(Optional<Integer> startDateEpochSeconds) {
            this.startDateEpochSeconds = startDateEpochSeconds.orElse(null);
            return this;
        }

        public final Builder setDesktopAppJoinUrl(@Nullable String desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
            return this;
        }

        public final Builder setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl.orElse(null);
            return this;
        }

        public final Builder setExternalDisplayId(@Nullable String externalDisplayId) {
            this.externalDisplayId = externalDisplayId;
            return this;
        }

        public final Builder setExternalDisplayId(Optional<String> externalDisplayId) {
            this.externalDisplayId = externalDisplayId.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder addUsers(SlackInternalOrExternalUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(SlackInternalOrExternalUser ... elements) {
            for (SlackInternalOrExternalUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder setUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
            for (SlackInternalOrExternalUser slackInternalOrExternalUser : elements) {
                this.users.add(Objects.requireNonNull(slackInternalOrExternalUser, "users element"));
            }
            return this;
        }

        public SlackCall build() {
            this.checkRequiredAttributes();
            return new SlackCall(this.externalUniqueId, this.id, this.startDateEpochSeconds, this.desktopAppJoinUrl, this.externalDisplayId, this.title, SlackCall.createUnmodifiableList(true, this.users));
        }

        private boolean externalUniqueIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean idIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.externalUniqueIdIsSet()) {
                attributes.add("externalUniqueId");
            }
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            return "Cannot build SlackCall, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackCallIF", generator="Immutables")
    static final class Json
    implements SlackCallIF {
        @Nullable
        String externalUniqueId;
        @Nullable
        String id;
        @Nullable
        Optional<Integer> startDateEpochSeconds = Optional.empty();
        @Nullable
        Optional<String> desktopAppJoinUrl = Optional.empty();
        @Nullable
        Optional<String> externalDisplayId = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        List<SlackInternalOrExternalUser> users = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setExternalUniqueId(String externalUniqueId) {
            this.externalUniqueId = externalUniqueId;
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty(value="start_date")
        public void setStartDateEpochSeconds(Optional<Integer> startDateEpochSeconds) {
            this.startDateEpochSeconds = startDateEpochSeconds;
        }

        @JsonProperty
        public void setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
        }

        @JsonProperty
        public void setExternalDisplayId(Optional<String> externalDisplayId) {
            this.externalDisplayId = externalDisplayId;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=SlackOrExternalUserDeserializer.class)
        public void setUsers(List<SlackInternalOrExternalUser> users) {
            this.users = users;
        }

        @Override
        public String getExternalUniqueId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getStartDateEpochSeconds() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Optional<Instant> getStartDate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDesktopAppJoinUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalDisplayId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackInternalOrExternalUser> getUsers() {
            throw new UnsupportedOperationException();
        }
    }
}

