/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.objects.TextIF;
import com.hubspot.slack.client.models.blocks.objects.TextType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="TextIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Text
implements TextIF {
    private final TextType type;
    private final String text;
    @Nullable
    private final Boolean emoji;
    @Nullable
    private final Boolean verbatim;

    private Text(TextType type, String text) {
        this.type = Objects.requireNonNull(type, "type");
        this.text = Objects.requireNonNull(text, "text");
        this.emoji = null;
        this.verbatim = null;
    }

    private Text(TextType type, String text, @Nullable Boolean emoji, @Nullable Boolean verbatim) {
        this.type = type;
        this.text = text;
        this.emoji = emoji;
        this.verbatim = verbatim;
    }

    @Override
    @JsonProperty
    public TextType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="emoji")
    public Optional<Boolean> isEmoji() {
        return Optional.ofNullable(this.emoji);
    }

    @Override
    @JsonProperty(value="verbatim")
    public Optional<Boolean> isVerbatim() {
        return Optional.ofNullable(this.verbatim);
    }

    public final Text withType(TextType value) {
        TextType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new Text(newValue, this.text, this.emoji, this.verbatim);
    }

    public final Text withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new Text(this.type, newValue, this.emoji, this.verbatim);
    }

    public final Text withEmoji(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.emoji, newValue)) {
            return this;
        }
        return new Text(this.type, this.text, newValue, this.verbatim);
    }

    public final Text withEmoji(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.emoji, value)) {
            return this;
        }
        return new Text(this.type, this.text, value, this.verbatim);
    }

    public final Text withVerbatim(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.verbatim, newValue)) {
            return this;
        }
        return new Text(this.type, this.text, this.emoji, newValue);
    }

    public final Text withVerbatim(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.verbatim, value)) {
            return this;
        }
        return new Text(this.type, this.text, this.emoji, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Text && this.equalTo(0, (Text)another);
    }

    private boolean equalTo(int synthetic, Text another) {
        return this.type.equals((Object)another.type) && this.text.equals(another.text) && Objects.equals(this.emoji, another.emoji) && Objects.equals(this.verbatim, another.verbatim);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + Objects.hashCode(this.emoji);
        h += (h << 5) + Objects.hashCode(this.verbatim);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Text{");
        builder.append("type=").append((Object)this.type);
        builder.append(", ");
        builder.append("text=").append(this.text);
        if (this.emoji != null) {
            builder.append(", ");
            builder.append("emoji=").append(this.emoji);
        }
        if (this.verbatim != null) {
            builder.append(", ");
            builder.append("verbatim=").append(this.verbatim);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Text fromJson(Json json) {
        Builder builder = Text.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.emoji != null) {
            builder.setEmoji(json.emoji);
        }
        if (json.verbatim != null) {
            builder.setVerbatim(json.verbatim);
        }
        return builder.build();
    }

    public static Text of(TextType type, String text) {
        return new Text(type, text);
    }

    public static Text copyOf(TextIF instance) {
        if (instance instanceof Text) {
            return (Text)instance;
        }
        return Text.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TextIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private long initBits = 3L;
        @Nullable
        private TextType type;
        @Nullable
        private String text;
        @Nullable
        private Boolean emoji;
        @Nullable
        private Boolean verbatim;

        private Builder() {
        }

        public final Builder from(TextIF instance) {
            Optional<Boolean> verbatimOptional;
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            this.setText(instance.getText());
            Optional<Boolean> emojiOptional = instance.isEmoji();
            if (emojiOptional.isPresent()) {
                this.setEmoji(emojiOptional);
            }
            if ((verbatimOptional = instance.isVerbatim()).isPresent()) {
                this.setVerbatim(verbatimOptional);
            }
            return this;
        }

        public final Builder setType(TextType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setEmoji(@Nullable Boolean emoji) {
            this.emoji = emoji;
            return this;
        }

        public final Builder setEmoji(Optional<Boolean> emoji) {
            this.emoji = emoji.orElse(null);
            return this;
        }

        public final Builder setVerbatim(@Nullable Boolean verbatim) {
            this.verbatim = verbatim;
            return this;
        }

        public final Builder setVerbatim(Optional<Boolean> verbatim) {
            this.verbatim = verbatim.orElse(null);
            return this;
        }

        public Text build() {
            this.checkRequiredAttributes();
            return new Text(this.type, this.text, this.emoji, this.verbatim);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build Text, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TextIF", generator="Immutables")
    static final class Json
    implements TextIF {
        @Nullable
        TextType type;
        @Nullable
        String text;
        @Nullable
        Optional<Boolean> emoji = Optional.empty();
        @Nullable
        Optional<Boolean> verbatim = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(TextType type) {
            this.type = type;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty(value="emoji")
        public void setEmoji(Optional<Boolean> emoji) {
            this.emoji = emoji;
        }

        @JsonProperty(value="verbatim")
        public void setVerbatim(Optional<Boolean> verbatim) {
            this.verbatim = verbatim;
        }

        @Override
        public TextType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isEmoji() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isVerbatim() {
            throw new UnsupportedOperationException();
        }
    }
}

