/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.objects;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Style;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialogIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ConfirmationDialogIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConfirmationDialog
implements ConfirmationDialogIF {
    private final Text title;
    private final Text text;
    private final Text confirmButtonText;
    private final Text denyButtonText;
    @Nullable
    private final Style style;

    private ConfirmationDialog(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
        this.title = Objects.requireNonNull(title, "title");
        this.text = Objects.requireNonNull(text, "text");
        this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
        this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
        this.style = null;
    }

    private ConfirmationDialog(Text title, Text text, Text confirmButtonText, Text denyButtonText, @Nullable Style style) {
        this.title = title;
        this.text = text;
        this.confirmButtonText = confirmButtonText;
        this.denyButtonText = denyButtonText;
        this.style = style;
    }

    @Override
    @JsonProperty
    public Text getTitle() {
        return this.title;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    @Override
    @JsonProperty(value="confirm")
    public Text getConfirmButtonText() {
        return this.confirmButtonText;
    }

    @Override
    @JsonProperty(value="deny")
    public Text getDenyButtonText() {
        return this.denyButtonText;
    }

    @Override
    @JsonProperty
    public Optional<Style> getStyle() {
        return Optional.ofNullable(this.style);
    }

    public final ConfirmationDialog withTitle(Text value) {
        if (this.title == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "title");
        return new ConfirmationDialog(newValue, this.text, this.confirmButtonText, this.denyButtonText, this.style);
    }

    public final ConfirmationDialog withText(Text value) {
        if (this.text == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "text");
        return new ConfirmationDialog(this.title, newValue, this.confirmButtonText, this.denyButtonText, this.style);
    }

    public final ConfirmationDialog withConfirmButtonText(Text value) {
        if (this.confirmButtonText == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "confirmButtonText");
        return new ConfirmationDialog(this.title, this.text, newValue, this.denyButtonText, this.style);
    }

    public final ConfirmationDialog withDenyButtonText(Text value) {
        if (this.denyButtonText == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "denyButtonText");
        return new ConfirmationDialog(this.title, this.text, this.confirmButtonText, newValue, this.style);
    }

    public final ConfirmationDialog withStyle(@Nullable Style value) {
        Style newValue = value;
        if (this.style == newValue) {
            return this;
        }
        return new ConfirmationDialog(this.title, this.text, this.confirmButtonText, this.denyButtonText, newValue);
    }

    public final ConfirmationDialog withStyle(Optional<? extends Style> optional) {
        Style value = optional.orElse(null);
        if (this.style == value) {
            return this;
        }
        return new ConfirmationDialog(this.title, this.text, this.confirmButtonText, this.denyButtonText, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConfirmationDialog && this.equalTo(0, (ConfirmationDialog)another);
    }

    private boolean equalTo(int synthetic, ConfirmationDialog another) {
        return this.title.equals(another.title) && this.text.equals(another.text) && this.confirmButtonText.equals(another.confirmButtonText) && this.denyButtonText.equals(another.denyButtonText) && Objects.equals((Object)this.style, (Object)another.style);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title.hashCode();
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.confirmButtonText.hashCode();
        h += (h << 5) + this.denyButtonText.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.style);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConfirmationDialog{");
        builder.append("title=").append(this.title);
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("confirmButtonText=").append(this.confirmButtonText);
        builder.append(", ");
        builder.append("denyButtonText=").append(this.denyButtonText);
        if (this.style != null) {
            builder.append(", ");
            builder.append("style=").append((Object)this.style);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConfirmationDialog fromJson(Json json) {
        Builder builder = ConfirmationDialog.builder();
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.confirmButtonText != null) {
            builder.setConfirmButtonText(json.confirmButtonText);
        }
        if (json.denyButtonText != null) {
            builder.setDenyButtonText(json.denyButtonText);
        }
        if (json.style != null) {
            builder.setStyle(json.style);
        }
        return builder.build();
    }

    public static ConfirmationDialog of(Text title, Text text, Text confirmButtonText, Text denyButtonText) {
        return new ConfirmationDialog(title, text, confirmButtonText, denyButtonText);
    }

    public static ConfirmationDialog copyOf(ConfirmationDialogIF instance) {
        if (instance instanceof ConfirmationDialog) {
            return (ConfirmationDialog)instance;
        }
        return ConfirmationDialog.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfirmationDialogIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TITLE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_CONFIRM_BUTTON_TEXT = 4L;
        private static final long INIT_BIT_DENY_BUTTON_TEXT = 8L;
        private long initBits = 15L;
        @Nullable
        private Text title;
        @Nullable
        private Text text;
        @Nullable
        private Text confirmButtonText;
        @Nullable
        private Text denyButtonText;
        @Nullable
        private Style style;

        private Builder() {
        }

        public final Builder from(ConfirmationDialogIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setTitle(instance.getTitle());
            this.setText(instance.getText());
            this.setConfirmButtonText(instance.getConfirmButtonText());
            this.setDenyButtonText(instance.getDenyButtonText());
            Optional<Style> styleOptional = instance.getStyle();
            if (styleOptional.isPresent()) {
                this.setStyle(styleOptional);
            }
            return this;
        }

        public final Builder setTitle(Text title) {
            this.title = Objects.requireNonNull(title, "title");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setConfirmButtonText(Text confirmButtonText) {
            this.confirmButtonText = Objects.requireNonNull(confirmButtonText, "confirmButtonText");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setDenyButtonText(Text denyButtonText) {
            this.denyButtonText = Objects.requireNonNull(denyButtonText, "denyButtonText");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public final Builder setStyle(@Nullable Style style) {
            this.style = style;
            return this;
        }

        public final Builder setStyle(Optional<? extends Style> style) {
            this.style = style.orElse(null);
            return this;
        }

        public ConfirmationDialog build() {
            this.checkRequiredAttributes();
            return new ConfirmationDialog(this.title, this.text, this.confirmButtonText, this.denyButtonText, this.style);
        }

        private boolean titleIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean confirmButtonTextIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private boolean denyButtonTextIsSet() {
            return (this.initBits & 8L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.titleIsSet()) {
                attributes.add("title");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.confirmButtonTextIsSet()) {
                attributes.add("confirmButtonText");
            }
            if (!this.denyButtonTextIsSet()) {
                attributes.add("denyButtonText");
            }
            return "Cannot build ConfirmationDialog, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ConfirmationDialogIF", generator="Immutables")
    static final class Json
    implements ConfirmationDialogIF {
        @Nullable
        Text title;
        @Nullable
        Text text;
        @Nullable
        Text confirmButtonText;
        @Nullable
        Text denyButtonText;
        @Nullable
        Optional<Style> style = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setTitle(Text title) {
            this.title = title;
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @JsonProperty(value="confirm")
        public void setConfirmButtonText(Text confirmButtonText) {
            this.confirmButtonText = confirmButtonText;
        }

        @JsonProperty(value="deny")
        public void setDenyButtonText(Text denyButtonText) {
            this.denyButtonText = denyButtonText;
        }

        @JsonProperty
        public void setStyle(Optional<Style> style) {
            this.style = style;
        }

        @Override
        public Text getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getConfirmButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getDenyButtonText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Style> getStyle() {
            throw new UnsupportedOperationException();
        }
    }
}

