/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.UsersMultiSelectMenuIF;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="UsersMultiSelectMenuIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class UsersMultiSelectMenu
implements UsersMultiSelectMenuIF {
    private final transient String type;
    private final Text placeholder;
    private final String actionId;
    private final List<String> initialUserIds;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private UsersMultiSelectMenu(Text placeholder, String actionId) {
        this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.initialUserIds = Collections.emptyList();
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(UsersMultiSelectMenuIF.super.getType(), "type");
    }

    private UsersMultiSelectMenu(Text placeholder, String actionId, List<String> initialUserIds, @Nullable ConfirmationDialog confirmationDialog) {
        this.placeholder = placeholder;
        this.actionId = actionId;
        this.initialUserIds = initialUserIds;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(UsersMultiSelectMenuIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getPlaceholder() {
        return this.placeholder;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="initial_users")
    public List<String> getInitialUserIds() {
        return this.initialUserIds;
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final UsersMultiSelectMenu withPlaceholder(Text value) {
        if (this.placeholder == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "placeholder");
        return new UsersMultiSelectMenu(newValue, this.actionId, this.initialUserIds, this.confirmationDialog);
    }

    public final UsersMultiSelectMenu withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return new UsersMultiSelectMenu(this.placeholder, newValue, this.initialUserIds, this.confirmationDialog);
    }

    public final UsersMultiSelectMenu withInitialUserIds(String ... elements) {
        List<String> newValue = UsersMultiSelectMenu.createUnmodifiableList(false, UsersMultiSelectMenu.createSafeList(Arrays.asList(elements), true, false));
        return new UsersMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final UsersMultiSelectMenu withInitialUserIds(Iterable<String> elements) {
        if (this.initialUserIds == elements) {
            return this;
        }
        List<String> newValue = UsersMultiSelectMenu.createUnmodifiableList(false, UsersMultiSelectMenu.createSafeList(elements, true, false));
        return new UsersMultiSelectMenu(this.placeholder, this.actionId, newValue, this.confirmationDialog);
    }

    public final UsersMultiSelectMenu withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return new UsersMultiSelectMenu(this.placeholder, this.actionId, this.initialUserIds, newValue);
    }

    public final UsersMultiSelectMenu withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return new UsersMultiSelectMenu(this.placeholder, this.actionId, this.initialUserIds, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof UsersMultiSelectMenu && this.equalTo(0, (UsersMultiSelectMenu)another);
    }

    private boolean equalTo(int synthetic, UsersMultiSelectMenu another) {
        return this.type.equals(another.type) && this.placeholder.equals(another.placeholder) && this.actionId.equals(another.actionId) && this.initialUserIds.equals(another.initialUserIds) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.placeholder.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + this.initialUserIds.hashCode();
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("UsersMultiSelectMenu{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("placeholder=").append(this.placeholder);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("initialUserIds=").append(this.initialUserIds);
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static UsersMultiSelectMenu fromJson(Json json) {
        Builder builder = UsersMultiSelectMenu.builder();
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.initialUserIds != null) {
            builder.addAllInitialUserIds(json.initialUserIds);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static UsersMultiSelectMenu of(Text placeholder, String actionId) {
        return new UsersMultiSelectMenu(placeholder, actionId);
    }

    public static UsersMultiSelectMenu copyOf(UsersMultiSelectMenuIF instance) {
        if (instance instanceof UsersMultiSelectMenu) {
            return (UsersMultiSelectMenu)instance;
        }
        return UsersMultiSelectMenu.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="UsersMultiSelectMenuIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_PLACEHOLDER = 1L;
        private static final long INIT_BIT_ACTION_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private Text placeholder;
        @Nullable
        private String actionId;
        private List<String> initialUserIds = new ArrayList<String>();
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(UsersMultiSelectMenuIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof UsersMultiSelectMenuIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (UsersMultiSelectMenuIF)object;
                this.addAllInitialUserIds(instance.getInitialUserIds());
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.setPlaceholder(instance.getPlaceholder());
            }
        }

        public final Builder setPlaceholder(Text placeholder) {
            this.placeholder = Objects.requireNonNull(placeholder, "placeholder");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addInitialUserIds(String element) {
            this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
            return this;
        }

        public final Builder addInitialUserIds(String ... elements) {
            for (String element : elements) {
                this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
            }
            return this;
        }

        public final Builder setInitialUserIds(Iterable<String> elements) {
            this.initialUserIds.clear();
            return this.addAllInitialUserIds(elements);
        }

        public final Builder addAllInitialUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.initialUserIds.add(Objects.requireNonNull(element, "initialUserIds element"));
            }
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public UsersMultiSelectMenu build() {
            this.checkRequiredAttributes();
            return new UsersMultiSelectMenu(this.placeholder, this.actionId, UsersMultiSelectMenu.createUnmodifiableList(true, this.initialUserIds), this.confirmationDialog);
        }

        private boolean placeholderIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.placeholderIsSet()) {
                attributes.add("placeholder");
            }
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build UsersMultiSelectMenu, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="UsersMultiSelectMenuIF", generator="Immutables")
    static final class Json
    implements UsersMultiSelectMenuIF {
        @Nullable
        Text placeholder;
        @Nullable
        String actionId;
        @Nullable
        List<String> initialUserIds = Collections.emptyList();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setPlaceholder(Text placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="initial_users")
        public void setInitialUserIds(List<String> initialUserIds) {
            this.initialUserIds = initialUserIds;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getInitialUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

