/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.elements.NumberInputIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="NumberInputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class NumberInput
implements NumberInputIF {
    private final transient String type;
    private final String actionId;
    private final boolean decimalAllowed;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final String initialValue;
    @Nullable
    private final String minValue;
    @Nullable
    private final String maxValue;
    @Nullable
    private final Boolean focusOnLoad;

    private NumberInput(String actionId, boolean decimalAllowed) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.decimalAllowed = decimalAllowed;
        this.placeholder = null;
        this.initialValue = null;
        this.minValue = null;
        this.maxValue = null;
        this.focusOnLoad = null;
        this.type = Objects.requireNonNull(NumberInputIF.super.getType(), "type");
    }

    private NumberInput(String actionId, boolean decimalAllowed, @Nullable Text placeholder, @Nullable String initialValue, @Nullable String minValue, @Nullable String maxValue, @Nullable Boolean focusOnLoad) {
        this.actionId = actionId;
        this.decimalAllowed = decimalAllowed;
        this.placeholder = placeholder;
        this.initialValue = initialValue;
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.focusOnLoad = focusOnLoad;
        this.type = Objects.requireNonNull(NumberInputIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty(value="is_decimal_allowed")
    public boolean isDecimalAllowed() {
        return this.decimalAllowed;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    public Optional<String> getInitialValue() {
        return Optional.ofNullable(this.initialValue);
    }

    @Override
    @JsonProperty
    public Optional<String> getMinValue() {
        return Optional.ofNullable(this.minValue);
    }

    @Override
    @JsonProperty
    public Optional<String> getMaxValue() {
        return Optional.ofNullable(this.maxValue);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isFocusOnLoad() {
        return Optional.ofNullable(this.focusOnLoad);
    }

    public final NumberInput withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(newValue, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withDecimalAllowed(boolean value) {
        if (this.decimalAllowed == value) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, value, this.placeholder, this.initialValue, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, newValue, this.initialValue, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, value, this.initialValue, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withInitialValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialValue, newValue)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, newValue, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withInitialValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialValue, value)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, value, this.minValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withMinValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.minValue, newValue)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, newValue, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withMinValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.minValue, value)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, value, this.maxValue, this.focusOnLoad));
    }

    public final NumberInput withMaxValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.maxValue, newValue)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, newValue, this.focusOnLoad));
    }

    public final NumberInput withMaxValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.maxValue, value)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, value, this.focusOnLoad));
    }

    public final NumberInput withFocusOnLoad(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.focusOnLoad, newValue)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, this.maxValue, newValue));
    }

    public final NumberInput withFocusOnLoad(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.focusOnLoad, value)) {
            return this;
        }
        return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, this.maxValue, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof NumberInput && this.equalTo(0, (NumberInput)another);
    }

    private boolean equalTo(int synthetic, NumberInput another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && this.decimalAllowed == another.decimalAllowed && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.initialValue, another.initialValue) && Objects.equals(this.minValue, another.minValue) && Objects.equals(this.maxValue, another.maxValue) && Objects.equals(this.focusOnLoad, another.focusOnLoad);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Boolean.hashCode(this.decimalAllowed);
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.initialValue);
        h += (h << 5) + Objects.hashCode(this.minValue);
        h += (h << 5) + Objects.hashCode(this.maxValue);
        h += (h << 5) + Objects.hashCode(this.focusOnLoad);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("NumberInput{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("decimalAllowed=").append(this.decimalAllowed);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.initialValue != null) {
            builder.append(", ");
            builder.append("initialValue=").append(this.initialValue);
        }
        if (this.minValue != null) {
            builder.append(", ");
            builder.append("minValue=").append(this.minValue);
        }
        if (this.maxValue != null) {
            builder.append(", ");
            builder.append("maxValue=").append(this.maxValue);
        }
        if (this.focusOnLoad != null) {
            builder.append(", ");
            builder.append("focusOnLoad=").append(this.focusOnLoad);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static NumberInput fromJson(Json json) {
        Builder builder = NumberInput.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.decimalAllowedIsSet) {
            builder.setDecimalAllowed(json.decimalAllowed);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.initialValue != null) {
            builder.setInitialValue(json.initialValue);
        }
        if (json.minValue != null) {
            builder.setMinValue(json.minValue);
        }
        if (json.maxValue != null) {
            builder.setMaxValue(json.maxValue);
        }
        if (json.focusOnLoad != null) {
            builder.setFocusOnLoad(json.focusOnLoad);
        }
        return builder.build();
    }

    public static NumberInput of(String actionId, boolean decimalAllowed) {
        return NumberInput.validate(new NumberInput(actionId, decimalAllowed));
    }

    private static NumberInput validate(NumberInput instance) {
        instance = (NumberInput)instance.validate();
        return instance;
    }

    public static NumberInput copyOf(NumberInputIF instance) {
        if (instance instanceof NumberInput) {
            return (NumberInput)instance;
        }
        return NumberInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="NumberInputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private static final long INIT_BIT_DECIMAL_ALLOWED = 2L;
        private long initBits = 3L;
        @Nullable
        private String actionId;
        private boolean decimalAllowed;
        @Nullable
        private Text placeholder;
        @Nullable
        private String initialValue;
        @Nullable
        private String minValue;
        @Nullable
        private String maxValue;
        @Nullable
        private Boolean focusOnLoad;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(NumberInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof NumberInputIF) {
                Optional<String> initialValueOptional;
                Optional<Boolean> focusOnLoadOptional;
                Optional<String> maxValueOptional;
                instance = (NumberInputIF)object;
                Optional<String> minValueOptional = instance.getMinValue();
                if (minValueOptional.isPresent()) {
                    this.setMinValue(minValueOptional);
                }
                if ((maxValueOptional = instance.getMaxValue()).isPresent()) {
                    this.setMaxValue(maxValueOptional);
                }
                if ((focusOnLoadOptional = instance.isFocusOnLoad()).isPresent()) {
                    this.setFocusOnLoad(focusOnLoadOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                this.setDecimalAllowed(instance.isDecimalAllowed());
                Optional<Text> placeholderOptional = instance.getPlaceholder();
                if (placeholderOptional.isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((initialValueOptional = instance.getInitialValue()).isPresent()) {
                    this.setInitialValue(initialValueOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setDecimalAllowed(boolean decimalAllowed) {
            this.decimalAllowed = decimalAllowed;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setInitialValue(@Nullable String initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public final Builder setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue.orElse(null);
            return this;
        }

        public final Builder setMinValue(@Nullable String minValue) {
            this.minValue = minValue;
            return this;
        }

        public final Builder setMinValue(Optional<String> minValue) {
            this.minValue = minValue.orElse(null);
            return this;
        }

        public final Builder setMaxValue(@Nullable String maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public final Builder setMaxValue(Optional<String> maxValue) {
            this.maxValue = maxValue.orElse(null);
            return this;
        }

        public final Builder setFocusOnLoad(@Nullable Boolean focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
            return this;
        }

        public final Builder setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad.orElse(null);
            return this;
        }

        public NumberInput build() {
            this.checkRequiredAttributes();
            return NumberInput.validate(new NumberInput(this.actionId, this.decimalAllowed, this.placeholder, this.initialValue, this.minValue, this.maxValue, this.focusOnLoad));
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean decimalAllowedIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            if (!this.decimalAllowedIsSet()) {
                attributes.add("decimalAllowed");
            }
            return "Cannot build NumberInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NumberInputIF", generator="Immutables")
    static final class Json
    implements NumberInputIF {
        @Nullable
        String actionId;
        boolean decimalAllowed;
        boolean decimalAllowedIsSet;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<String> initialValue = Optional.empty();
        @Nullable
        Optional<String> minValue = Optional.empty();
        @Nullable
        Optional<String> maxValue = Optional.empty();
        @Nullable
        Optional<Boolean> focusOnLoad = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty(value="is_decimal_allowed")
        public void setDecimalAllowed(boolean decimalAllowed) {
            this.decimalAllowed = decimalAllowed;
            this.decimalAllowedIsSet = true;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue;
        }

        @JsonProperty
        public void setMinValue(Optional<String> minValue) {
            this.minValue = minValue;
        }

        @JsonProperty
        public void setMaxValue(Optional<String> maxValue) {
            this.maxValue = maxValue;
        }

        @JsonProperty
        public void setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isDecimalAllowed() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMinValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getMaxValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isFocusOnLoad() {
            throw new UnsupportedOperationException();
        }
    }
}

