/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.EmailInputIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="EmailInputIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class EmailInput
implements EmailInputIF {
    private final transient String type;
    private final String actionId;
    @Nullable
    private final Text placeholder;
    @Nullable
    private final String initialValue;
    @Nullable
    private final Boolean focusOnLoad;

    private EmailInput(String actionId) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.placeholder = null;
        this.initialValue = null;
        this.focusOnLoad = null;
        this.type = Objects.requireNonNull(EmailInputIF.super.getType(), "type");
    }

    private EmailInput(String actionId, @Nullable Text placeholder, @Nullable String initialValue, @Nullable Boolean focusOnLoad) {
        this.actionId = actionId;
        this.placeholder = placeholder;
        this.initialValue = initialValue;
        this.focusOnLoad = focusOnLoad;
        this.type = Objects.requireNonNull(EmailInputIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public Optional<Text> getPlaceholder() {
        return Optional.ofNullable(this.placeholder);
    }

    @Override
    @JsonProperty
    public Optional<String> getInitialValue() {
        return Optional.ofNullable(this.initialValue);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> isFocusOnLoad() {
        return Optional.ofNullable(this.focusOnLoad);
    }

    public final EmailInput withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return EmailInput.validate(new EmailInput(newValue, this.placeholder, this.initialValue, this.focusOnLoad));
    }

    public final EmailInput withPlaceholder(@Nullable Text value) {
        Text newValue = value;
        if (this.placeholder == newValue) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, newValue, this.initialValue, this.focusOnLoad));
    }

    public final EmailInput withPlaceholder(Optional<? extends Text> optional) {
        Text value = optional.orElse(null);
        if (this.placeholder == value) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, value, this.initialValue, this.focusOnLoad));
    }

    public final EmailInput withInitialValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialValue, newValue)) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, this.placeholder, newValue, this.focusOnLoad));
    }

    public final EmailInput withInitialValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialValue, value)) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, this.placeholder, value, this.focusOnLoad));
    }

    public final EmailInput withFocusOnLoad(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.focusOnLoad, newValue)) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, this.placeholder, this.initialValue, newValue));
    }

    public final EmailInput withFocusOnLoad(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.focusOnLoad, value)) {
            return this;
        }
        return EmailInput.validate(new EmailInput(this.actionId, this.placeholder, this.initialValue, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmailInput && this.equalTo(0, (EmailInput)another);
    }

    private boolean equalTo(int synthetic, EmailInput another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && Objects.equals(this.placeholder, another.placeholder) && Objects.equals(this.initialValue, another.initialValue) && Objects.equals(this.focusOnLoad, another.focusOnLoad);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + Objects.hashCode(this.placeholder);
        h += (h << 5) + Objects.hashCode(this.initialValue);
        h += (h << 5) + Objects.hashCode(this.focusOnLoad);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("EmailInput{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        if (this.placeholder != null) {
            builder.append(", ");
            builder.append("placeholder=").append(this.placeholder);
        }
        if (this.initialValue != null) {
            builder.append(", ");
            builder.append("initialValue=").append(this.initialValue);
        }
        if (this.focusOnLoad != null) {
            builder.append(", ");
            builder.append("focusOnLoad=").append(this.focusOnLoad);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static EmailInput fromJson(Json json) {
        Builder builder = EmailInput.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.placeholder != null) {
            builder.setPlaceholder(json.placeholder);
        }
        if (json.initialValue != null) {
            builder.setInitialValue(json.initialValue);
        }
        if (json.focusOnLoad != null) {
            builder.setFocusOnLoad(json.focusOnLoad);
        }
        return builder.build();
    }

    public static EmailInput of(String actionId) {
        return EmailInput.validate(new EmailInput(actionId));
    }

    private static EmailInput validate(EmailInput instance) {
        instance = (EmailInput)instance.validate();
        return instance;
    }

    public static EmailInput copyOf(EmailInputIF instance) {
        if (instance instanceof EmailInput) {
            return (EmailInput)instance;
        }
        return EmailInput.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="EmailInputIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        @Nullable
        private Text placeholder;
        @Nullable
        private String initialValue;
        @Nullable
        private Boolean focusOnLoad;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(EmailInputIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof EmailInputIF) {
                Optional<String> initialValueOptional;
                Optional<Text> placeholderOptional;
                instance = (EmailInputIF)object;
                Optional<Boolean> focusOnLoadOptional = instance.isFocusOnLoad();
                if (focusOnLoadOptional.isPresent()) {
                    this.setFocusOnLoad(focusOnLoadOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((placeholderOptional = instance.getPlaceholder()).isPresent()) {
                    this.setPlaceholder(placeholderOptional);
                }
                if ((initialValueOptional = instance.getInitialValue()).isPresent()) {
                    this.setInitialValue(initialValueOptional);
                }
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPlaceholder(@Nullable Text placeholder) {
            this.placeholder = placeholder;
            return this;
        }

        public final Builder setPlaceholder(Optional<? extends Text> placeholder) {
            this.placeholder = placeholder.orElse(null);
            return this;
        }

        public final Builder setInitialValue(@Nullable String initialValue) {
            this.initialValue = initialValue;
            return this;
        }

        public final Builder setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue.orElse(null);
            return this;
        }

        public final Builder setFocusOnLoad(@Nullable Boolean focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
            return this;
        }

        public final Builder setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad.orElse(null);
            return this;
        }

        public EmailInput build() {
            this.checkRequiredAttributes();
            return EmailInput.validate(new EmailInput(this.actionId, this.placeholder, this.initialValue, this.focusOnLoad));
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build EmailInput, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="EmailInputIF", generator="Immutables")
    static final class Json
    implements EmailInputIF {
        @Nullable
        String actionId;
        @Nullable
        Optional<Text> placeholder = Optional.empty();
        @Nullable
        Optional<String> initialValue = Optional.empty();
        @Nullable
        Optional<Boolean> focusOnLoad = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setPlaceholder(Optional<Text> placeholder) {
            this.placeholder = placeholder;
        }

        @JsonProperty
        public void setInitialValue(Optional<String> initialValue) {
            this.initialValue = initialValue;
        }

        @JsonProperty
        public void setFocusOnLoad(Optional<Boolean> focusOnLoad) {
            this.focusOnLoad = focusOnLoad;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Text> getPlaceholder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> isFocusOnLoad() {
            throw new UnsupportedOperationException();
        }
    }
}

