/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks.elements;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.elements.CheckboxesIF;
import com.hubspot.slack.client.models.blocks.elements.HasActionId;
import com.hubspot.slack.client.models.blocks.json.OptionOrOptionGroupDeserializer;
import com.hubspot.slack.client.models.blocks.objects.ConfirmationDialog;
import com.hubspot.slack.client.models.blocks.objects.Option;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CheckboxesIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Checkboxes
implements CheckboxesIF {
    private final transient String type;
    private final String actionId;
    private final List<Option> options;
    private final List<Option> initialOptions;
    @Nullable
    private final ConfirmationDialog confirmationDialog;

    private Checkboxes(String actionId, Iterable<? extends Option> options) {
        this.actionId = Objects.requireNonNull(actionId, "actionId");
        this.options = Checkboxes.createUnmodifiableList(false, Checkboxes.createSafeList(options, true, false));
        this.initialOptions = Collections.emptyList();
        this.confirmationDialog = null;
        this.type = Objects.requireNonNull(CheckboxesIF.super.getType(), "type");
    }

    private Checkboxes(String actionId, List<Option> options, List<Option> initialOptions, @Nullable ConfirmationDialog confirmationDialog) {
        this.actionId = actionId;
        this.options = options;
        this.initialOptions = initialOptions;
        this.confirmationDialog = confirmationDialog;
        this.type = Objects.requireNonNull(CheckboxesIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public String getActionId() {
        return this.actionId;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
    public List<Option> getInitialOptions() {
        return this.initialOptions;
    }

    @Override
    @JsonProperty(value="confirm")
    public Optional<ConfirmationDialog> getConfirmationDialog() {
        return Optional.ofNullable(this.confirmationDialog);
    }

    public final Checkboxes withActionId(String value) {
        String newValue = Objects.requireNonNull(value, "actionId");
        if (this.actionId.equals(newValue)) {
            return this;
        }
        return Checkboxes.validate(new Checkboxes(newValue, this.options, this.initialOptions, this.confirmationDialog));
    }

    public final Checkboxes withOptions(Option ... elements) {
        List<Option> newValue = Checkboxes.createUnmodifiableList(false, Checkboxes.createSafeList(Arrays.asList(elements), true, false));
        return Checkboxes.validate(new Checkboxes(this.actionId, newValue, this.initialOptions, this.confirmationDialog));
    }

    public final Checkboxes withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = Checkboxes.createUnmodifiableList(false, Checkboxes.createSafeList(elements, true, false));
        return Checkboxes.validate(new Checkboxes(this.actionId, newValue, this.initialOptions, this.confirmationDialog));
    }

    public final Checkboxes withInitialOptions(Option ... elements) {
        List<Option> newValue = Checkboxes.createUnmodifiableList(false, Checkboxes.createSafeList(Arrays.asList(elements), true, false));
        return Checkboxes.validate(new Checkboxes(this.actionId, this.options, newValue, this.confirmationDialog));
    }

    public final Checkboxes withInitialOptions(Iterable<? extends Option> elements) {
        if (this.initialOptions == elements) {
            return this;
        }
        List<Option> newValue = Checkboxes.createUnmodifiableList(false, Checkboxes.createSafeList(elements, true, false));
        return Checkboxes.validate(new Checkboxes(this.actionId, this.options, newValue, this.confirmationDialog));
    }

    public final Checkboxes withConfirmationDialog(@Nullable ConfirmationDialog value) {
        ConfirmationDialog newValue = value;
        if (this.confirmationDialog == newValue) {
            return this;
        }
        return Checkboxes.validate(new Checkboxes(this.actionId, this.options, this.initialOptions, newValue));
    }

    public final Checkboxes withConfirmationDialog(Optional<? extends ConfirmationDialog> optional) {
        ConfirmationDialog value = optional.orElse(null);
        if (this.confirmationDialog == value) {
            return this;
        }
        return Checkboxes.validate(new Checkboxes(this.actionId, this.options, this.initialOptions, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Checkboxes && this.equalTo(0, (Checkboxes)another);
    }

    private boolean equalTo(int synthetic, Checkboxes another) {
        return this.type.equals(another.type) && this.actionId.equals(another.actionId) && this.options.equals(another.options) && this.initialOptions.equals(another.initialOptions) && Objects.equals(this.confirmationDialog, another.confirmationDialog);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.actionId.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.initialOptions.hashCode();
        h += (h << 5) + Objects.hashCode(this.confirmationDialog);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Checkboxes{");
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("actionId=").append(this.actionId);
        builder.append(", ");
        builder.append("options=").append(this.options);
        builder.append(", ");
        builder.append("initialOptions=").append(this.initialOptions);
        if (this.confirmationDialog != null) {
            builder.append(", ");
            builder.append("confirmationDialog=").append(this.confirmationDialog);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Checkboxes fromJson(Json json) {
        Builder builder = Checkboxes.builder();
        if (json.actionId != null) {
            builder.setActionId(json.actionId);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.initialOptions != null) {
            builder.addAllInitialOptions(json.initialOptions);
        }
        if (json.confirmationDialog != null) {
            builder.setConfirmationDialog(json.confirmationDialog);
        }
        return builder.build();
    }

    public static Checkboxes of(String actionId, List<Option> options) {
        return Checkboxes.of(actionId, options);
    }

    public static Checkboxes of(String actionId, Iterable<? extends Option> options) {
        return Checkboxes.validate(new Checkboxes(actionId, options));
    }

    private static Checkboxes validate(Checkboxes instance) {
        instance = (Checkboxes)instance.validate();
        return instance;
    }

    public static Checkboxes copyOf(CheckboxesIF instance) {
        if (instance instanceof Checkboxes) {
            return (Checkboxes)instance;
        }
        return Checkboxes.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CheckboxesIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACTION_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private String actionId;
        private List<Option> options = new ArrayList<Option>();
        private List<Option> initialOptions = new ArrayList<Option>();
        @Nullable
        private ConfirmationDialog confirmationDialog;

        private Builder() {
        }

        public final Builder from(HasActionId instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(CheckboxesIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasActionId instance;
            long bits = 0L;
            if (object instanceof HasActionId) {
                instance = (HasActionId)object;
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
            }
            if (object instanceof CheckboxesIF) {
                Optional<ConfirmationDialog> confirmationDialogOptional;
                instance = (CheckboxesIF)object;
                this.addAllOptions(instance.getOptions());
                if ((bits & 1L) == 0L) {
                    this.setActionId(instance.getActionId());
                    bits |= 1L;
                }
                if ((confirmationDialogOptional = instance.getConfirmationDialog()).isPresent()) {
                    this.setConfirmationDialog(confirmationDialogOptional);
                }
                this.addAllInitialOptions(instance.getInitialOptions());
            }
        }

        public final Builder setActionId(String actionId) {
            this.actionId = Objects.requireNonNull(actionId, "actionId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public final Builder addInitialOptions(Option element) {
            this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
            return this;
        }

        public final Builder addInitialOptions(Option ... elements) {
            for (Option element : elements) {
                this.initialOptions.add(Objects.requireNonNull(element, "initialOptions element"));
            }
            return this;
        }

        public final Builder setInitialOptions(Iterable<? extends Option> elements) {
            this.initialOptions.clear();
            return this.addAllInitialOptions(elements);
        }

        public final Builder addAllInitialOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.initialOptions.add(Objects.requireNonNull(option, "initialOptions element"));
            }
            return this;
        }

        public final Builder setConfirmationDialog(@Nullable ConfirmationDialog confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
            return this;
        }

        public final Builder setConfirmationDialog(Optional<? extends ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog.orElse(null);
            return this;
        }

        public Checkboxes build() {
            this.checkRequiredAttributes();
            return Checkboxes.validate(new Checkboxes(this.actionId, Checkboxes.createUnmodifiableList(true, this.options), Checkboxes.createUnmodifiableList(true, this.initialOptions), this.confirmationDialog));
        }

        private boolean actionIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.actionIdIsSet()) {
                attributes.add("actionId");
            }
            return "Cannot build Checkboxes, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CheckboxesIF", generator="Immutables")
    static final class Json
    implements CheckboxesIF {
        @Nullable
        String actionId;
        @Nullable
        List<Option> options = Collections.emptyList();
        @Nullable
        List<Option> initialOptions = Collections.emptyList();
        @Nullable
        Optional<ConfirmationDialog> confirmationDialog = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setActionId(String actionId) {
            this.actionId = actionId;
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @JsonProperty
        @JsonDeserialize(contentUsing=OptionOrOptionGroupDeserializer.class)
        public void setInitialOptions(List<Option> initialOptions) {
            this.initialOptions = initialOptions;
        }

        @JsonProperty(value="confirm")
        public void setConfirmationDialog(Optional<ConfirmationDialog> confirmationDialog) {
            this.confirmationDialog = confirmationDialog;
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getActionId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getInitialOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<ConfirmationDialog> getConfirmationDialog() {
            throw new UnsupportedOperationException();
        }
    }
}

