/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.HeaderIF;
import com.hubspot.slack.client.models.blocks.objects.Text;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="HeaderIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Header
implements HeaderIF {
    @Nullable
    private final String blockId;
    private final transient String type;
    private final Text text;

    private Header(Text text) {
        this.text = Objects.requireNonNull(text, "text");
        this.blockId = null;
        this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
    }

    private Header(@Nullable String blockId, Text text) {
        this.blockId = blockId;
        this.text = text;
        this.type = Objects.requireNonNull(HeaderIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Text getText() {
        return this.text;
    }

    public final Header withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return Header.validate(new Header(newValue, this.text));
    }

    public final Header withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return Header.validate(new Header(value, this.text));
    }

    public final Header withText(Text value) {
        if (this.text == value) {
            return this;
        }
        Text newValue = Objects.requireNonNull(value, "text");
        return Header.validate(new Header(this.blockId, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Header && this.equalTo(0, (Header)another);
    }

    private boolean equalTo(int synthetic, Header another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type) && this.text.equals(another.text);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + this.text.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Header{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        builder.append(", ");
        builder.append("text=").append(this.text);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Header fromJson(Json json) {
        Builder builder = Header.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        return builder.build();
    }

    public static Header of(Text text) {
        return Header.validate(new Header(text));
    }

    private static Header validate(Header instance) {
        instance.check();
        return instance;
    }

    public static Header copyOf(HeaderIF instance) {
        if (instance instanceof Header) {
            return (Header)instance;
        }
        return Header.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="HeaderIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TEXT = 1L;
        private long initBits = 1L;
        @Nullable
        private String blockId;
        @Nullable
        private Text text;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(HeaderIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof HeaderIF) {
                instance = (HeaderIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
                this.setText(instance.getText());
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public final Builder setText(Text text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public Header build() {
            this.checkRequiredAttributes();
            return Header.validate(new Header(this.blockId, this.text));
        }

        private boolean textIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            return "Cannot build Header, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="HeaderIF", generator="Immutables")
    static final class Json
    implements HeaderIF {
        @Nullable
        Optional<String> blockId = Optional.empty();
        @Nullable
        Text text;

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @JsonProperty
        public void setText(Text text) {
            this.text = text;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Text getText() {
            throw new UnsupportedOperationException();
        }
    }
}

