/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.blocks;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.blocks.DividerIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="DividerIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Divider
implements DividerIF {
    @Nullable
    private final String blockId;
    private final transient String type;

    private Divider(@Nullable String blockId) {
        this.blockId = blockId;
        this.type = Objects.requireNonNull(DividerIF.super.getType(), "type");
    }

    @Override
    @JsonProperty
    public Optional<String> getBlockId() {
        return Optional.ofNullable(this.blockId);
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    public final Divider withBlockId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.blockId, newValue)) {
            return this;
        }
        return new Divider(newValue);
    }

    public final Divider withBlockId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.blockId, value)) {
            return this;
        }
        return new Divider(value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Divider && this.equalTo(0, (Divider)another);
    }

    private boolean equalTo(int synthetic, Divider another) {
        return Objects.equals(this.blockId, another.blockId) && this.type.equals(another.type);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.blockId);
        h += (h << 5) + this.type.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Divider{");
        if (this.blockId != null) {
            builder.append("blockId=").append(this.blockId);
        }
        if (builder.length() > 8) {
            builder.append(", ");
        }
        builder.append("type=").append(this.type);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Divider fromJson(Json json) {
        Builder builder = Divider.builder();
        if (json.blockId != null) {
            builder.setBlockId(json.blockId);
        }
        return builder.build();
    }

    public static Divider copyOf(DividerIF instance) {
        if (instance instanceof Divider) {
            return (Divider)instance;
        }
        return Divider.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="DividerIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String blockId;

        private Builder() {
        }

        public final Builder from(Block instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(DividerIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> blockIdOptional;
            Block instance;
            long bits = 0L;
            if (object instanceof Block) {
                instance = (Block)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
            if (object instanceof DividerIF) {
                instance = (DividerIF)object;
                if ((bits & 1L) == 0L) {
                    blockIdOptional = instance.getBlockId();
                    if (blockIdOptional.isPresent()) {
                        this.setBlockId(blockIdOptional);
                    }
                    bits |= 1L;
                }
            }
        }

        public final Builder setBlockId(@Nullable String blockId) {
            this.blockId = blockId;
            return this;
        }

        public final Builder setBlockId(Optional<String> blockId) {
            this.blockId = blockId.orElse(null);
            return this;
        }

        public Divider build() {
            return new Divider(this.blockId);
        }
    }

    @Deprecated
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="DividerIF", generator="Immutables")
    static final class Json
    implements DividerIF {
        @Nullable
        Optional<String> blockId = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setBlockId(Optional<String> blockId) {
            this.blockId = blockId;
        }

        @Override
        public Optional<String> getBlockId() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public String getType() {
            throw new UnsupportedOperationException();
        }
    }
}

