/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.auth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.auth.BotCredentials;
import com.hubspot.slack.client.models.auth.IncomingWebhook;
import com.hubspot.slack.client.models.auth.OAuthCredentialsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="OAuthCredentialsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class OAuthCredentials
implements OAuthCredentialsIF {
    private final String accessToken;
    private final String teamName;
    private final String teamId;
    @Nullable
    private final String scope;
    @Nullable
    private final String userId;
    @Nullable
    private final BotCredentials bot;
    @Nullable
    private final IncomingWebhook incomingWebhook;

    private OAuthCredentials(String accessToken, String teamName, String teamId, @Nullable String scope, @Nullable String userId, @Nullable BotCredentials bot, @Nullable IncomingWebhook incomingWebhook) {
        this.accessToken = accessToken;
        this.teamName = teamName;
        this.teamId = teamId;
        this.scope = scope;
        this.userId = userId;
        this.bot = bot;
        this.incomingWebhook = incomingWebhook;
    }

    @Override
    @JsonProperty
    public String getAccessToken() {
        return this.accessToken;
    }

    @Override
    @JsonProperty
    public String getTeamName() {
        return this.teamName;
    }

    @Override
    @JsonProperty
    public String getTeamId() {
        return this.teamId;
    }

    @Override
    @JsonProperty
    public Optional<String> getScope() {
        return Optional.ofNullable(this.scope);
    }

    @Override
    @JsonProperty
    public Optional<String> getUserId() {
        return Optional.ofNullable(this.userId);
    }

    @Override
    @JsonProperty
    public Optional<BotCredentials> getBot() {
        return Optional.ofNullable(this.bot);
    }

    @Override
    @JsonProperty
    public Optional<IncomingWebhook> getIncomingWebhook() {
        return Optional.ofNullable(this.incomingWebhook);
    }

    public final OAuthCredentials withAccessToken(String value) {
        String newValue = Objects.requireNonNull(value, "accessToken");
        if (this.accessToken.equals(newValue)) {
            return this;
        }
        return new OAuthCredentials(newValue, this.teamName, this.teamId, this.scope, this.userId, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withTeamName(String value) {
        String newValue = Objects.requireNonNull(value, "teamName");
        if (this.teamName.equals(newValue)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, newValue, this.teamId, this.scope, this.userId, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withTeamId(String value) {
        String newValue = Objects.requireNonNull(value, "teamId");
        if (this.teamId.equals(newValue)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, newValue, this.scope, this.userId, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withScope(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.scope, newValue)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, newValue, this.userId, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withScope(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.scope, value)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, value, this.userId, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withUserId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.userId, newValue)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, newValue, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withUserId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.userId, value)) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, value, this.bot, this.incomingWebhook);
    }

    public final OAuthCredentials withBot(@Nullable BotCredentials value) {
        BotCredentials newValue = value;
        if (this.bot == newValue) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, this.userId, newValue, this.incomingWebhook);
    }

    public final OAuthCredentials withBot(Optional<? extends BotCredentials> optional) {
        BotCredentials value = optional.orElse(null);
        if (this.bot == value) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, this.userId, value, this.incomingWebhook);
    }

    public final OAuthCredentials withIncomingWebhook(@Nullable IncomingWebhook value) {
        IncomingWebhook newValue = value;
        if (this.incomingWebhook == newValue) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, this.userId, this.bot, newValue);
    }

    public final OAuthCredentials withIncomingWebhook(Optional<? extends IncomingWebhook> optional) {
        IncomingWebhook value = optional.orElse(null);
        if (this.incomingWebhook == value) {
            return this;
        }
        return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, this.userId, this.bot, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof OAuthCredentials && this.equalTo(0, (OAuthCredentials)another);
    }

    private boolean equalTo(int synthetic, OAuthCredentials another) {
        return this.accessToken.equals(another.accessToken) && this.teamName.equals(another.teamName) && this.teamId.equals(another.teamId) && Objects.equals(this.scope, another.scope) && Objects.equals(this.userId, another.userId) && Objects.equals(this.bot, another.bot) && Objects.equals(this.incomingWebhook, another.incomingWebhook);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.accessToken.hashCode();
        h += (h << 5) + this.teamName.hashCode();
        h += (h << 5) + this.teamId.hashCode();
        h += (h << 5) + Objects.hashCode(this.scope);
        h += (h << 5) + Objects.hashCode(this.userId);
        h += (h << 5) + Objects.hashCode(this.bot);
        h += (h << 5) + Objects.hashCode(this.incomingWebhook);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("OAuthCredentials{");
        builder.append("accessToken=").append(this.accessToken);
        builder.append(", ");
        builder.append("teamName=").append(this.teamName);
        builder.append(", ");
        builder.append("teamId=").append(this.teamId);
        if (this.scope != null) {
            builder.append(", ");
            builder.append("scope=").append(this.scope);
        }
        if (this.userId != null) {
            builder.append(", ");
            builder.append("userId=").append(this.userId);
        }
        if (this.bot != null) {
            builder.append(", ");
            builder.append("bot=").append(this.bot);
        }
        if (this.incomingWebhook != null) {
            builder.append(", ");
            builder.append("incomingWebhook=").append(this.incomingWebhook);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static OAuthCredentials fromJson(Json json) {
        Builder builder = OAuthCredentials.builder();
        if (json.accessToken != null) {
            builder.setAccessToken(json.accessToken);
        }
        if (json.teamName != null) {
            builder.setTeamName(json.teamName);
        }
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.scope != null) {
            builder.setScope(json.scope);
        }
        if (json.userId != null) {
            builder.setUserId(json.userId);
        }
        if (json.bot != null) {
            builder.setBot(json.bot);
        }
        if (json.incomingWebhook != null) {
            builder.setIncomingWebhook(json.incomingWebhook);
        }
        return builder.build();
    }

    public static OAuthCredentials copyOf(OAuthCredentialsIF instance) {
        if (instance instanceof OAuthCredentials) {
            return (OAuthCredentials)instance;
        }
        return OAuthCredentials.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="OAuthCredentialsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCESS_TOKEN = 1L;
        private static final long INIT_BIT_TEAM_NAME = 2L;
        private static final long INIT_BIT_TEAM_ID = 4L;
        private long initBits = 7L;
        @Nullable
        private String accessToken;
        @Nullable
        private String teamName;
        @Nullable
        private String teamId;
        @Nullable
        private String scope;
        @Nullable
        private String userId;
        @Nullable
        private BotCredentials bot;
        @Nullable
        private IncomingWebhook incomingWebhook;

        private Builder() {
        }

        public final Builder from(OAuthCredentialsIF instance) {
            Optional<IncomingWebhook> incomingWebhookOptional;
            Optional<BotCredentials> botOptional;
            Optional<String> userIdOptional;
            Objects.requireNonNull(instance, "instance");
            this.setAccessToken(instance.getAccessToken());
            this.setTeamName(instance.getTeamName());
            this.setTeamId(instance.getTeamId());
            Optional<String> scopeOptional = instance.getScope();
            if (scopeOptional.isPresent()) {
                this.setScope(scopeOptional);
            }
            if ((userIdOptional = instance.getUserId()).isPresent()) {
                this.setUserId(userIdOptional);
            }
            if ((botOptional = instance.getBot()).isPresent()) {
                this.setBot(botOptional);
            }
            if ((incomingWebhookOptional = instance.getIncomingWebhook()).isPresent()) {
                this.setIncomingWebhook(incomingWebhookOptional);
            }
            return this;
        }

        public final Builder setAccessToken(String accessToken) {
            this.accessToken = Objects.requireNonNull(accessToken, "accessToken");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setTeamName(String teamName) {
            this.teamName = Objects.requireNonNull(teamName, "teamName");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setTeamId(String teamId) {
            this.teamId = Objects.requireNonNull(teamId, "teamId");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setScope(@Nullable String scope) {
            this.scope = scope;
            return this;
        }

        public final Builder setScope(Optional<String> scope) {
            this.scope = scope.orElse(null);
            return this;
        }

        public final Builder setUserId(@Nullable String userId) {
            this.userId = userId;
            return this;
        }

        public final Builder setUserId(Optional<String> userId) {
            this.userId = userId.orElse(null);
            return this;
        }

        public final Builder setBot(@Nullable BotCredentials bot) {
            this.bot = bot;
            return this;
        }

        public final Builder setBot(Optional<? extends BotCredentials> bot) {
            this.bot = bot.orElse(null);
            return this;
        }

        public final Builder setIncomingWebhook(@Nullable IncomingWebhook incomingWebhook) {
            this.incomingWebhook = incomingWebhook;
            return this;
        }

        public final Builder setIncomingWebhook(Optional<? extends IncomingWebhook> incomingWebhook) {
            this.incomingWebhook = incomingWebhook.orElse(null);
            return this;
        }

        public OAuthCredentials build() {
            this.checkRequiredAttributes();
            return new OAuthCredentials(this.accessToken, this.teamName, this.teamId, this.scope, this.userId, this.bot, this.incomingWebhook);
        }

        private boolean accessTokenIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean teamNameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean teamIdIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.accessTokenIsSet()) {
                attributes.add("accessToken");
            }
            if (!this.teamNameIsSet()) {
                attributes.add("teamName");
            }
            if (!this.teamIdIsSet()) {
                attributes.add("teamId");
            }
            return "Cannot build OAuthCredentials, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="OAuthCredentialsIF", generator="Immutables")
    static final class Json
    implements OAuthCredentialsIF {
        @Nullable
        String accessToken;
        @Nullable
        String teamName;
        @Nullable
        String teamId;
        @Nullable
        Optional<String> scope = Optional.empty();
        @Nullable
        Optional<String> userId = Optional.empty();
        @Nullable
        Optional<BotCredentials> bot = Optional.empty();
        @Nullable
        Optional<IncomingWebhook> incomingWebhook = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setAccessToken(String accessToken) {
            this.accessToken = accessToken;
        }

        @JsonProperty
        public void setTeamName(String teamName) {
            this.teamName = teamName;
        }

        @JsonProperty
        public void setTeamId(String teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setScope(Optional<String> scope) {
            this.scope = scope;
        }

        @JsonProperty
        public void setUserId(Optional<String> userId) {
            this.userId = userId;
        }

        @JsonProperty
        public void setBot(Optional<BotCredentials> bot) {
            this.bot = bot;
        }

        @JsonProperty
        public void setIncomingWebhook(Optional<IncomingWebhook> incomingWebhook) {
            this.incomingWebhook = incomingWebhook;
        }

        @Override
        public String getAccessToken() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getScope() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUserId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<BotCredentials> getBot() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<IncomingWebhook> getIncomingWebhook() {
            throw new UnsupportedOperationException();
        }
    }
}

