/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models.actions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.actions.ActionIF;
import com.hubspot.slack.client.models.actions.ActionType;
import com.hubspot.slack.client.models.actions.ButtonStyle;
import com.hubspot.slack.client.models.actions.Confirm;
import com.hubspot.slack.client.models.actions.Option;
import com.hubspot.slack.client.models.actions.SlackDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ActionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Action
implements ActionIF {
    @Nullable
    private final String name;
    private final ActionType type;
    @Nullable
    private final String text;
    @Nullable
    private final String value;
    @Nullable
    private final Confirm confirm;
    @Nullable
    private final String url;
    @Nullable
    private final String rawStyle;
    private final transient Optional<ButtonStyle> buttonStyle;
    private final List<Option> options;
    private final List<Option> selectedOptions;
    @Nullable
    private final SlackDataSource dataSource;
    @Nullable
    private final Integer minQueryLength;

    private Action(@Nullable String name, ActionType type, @Nullable String text, @Nullable String value, @Nullable Confirm confirm, @Nullable String url, @Nullable String rawStyle, List<Option> options, List<Option> selectedOptions, @Nullable SlackDataSource dataSource, @Nullable Integer minQueryLength) {
        this.name = name;
        this.type = type;
        this.text = text;
        this.value = value;
        this.confirm = confirm;
        this.url = url;
        this.rawStyle = rawStyle;
        this.options = options;
        this.selectedOptions = selectedOptions;
        this.dataSource = dataSource;
        this.minQueryLength = minQueryLength;
        this.buttonStyle = Objects.requireNonNull(ActionIF.super.getButtonStyle(), "buttonStyle");
    }

    @Override
    @JsonProperty
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    @Override
    @JsonProperty
    public ActionType getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public Optional<String> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    @JsonProperty
    public Optional<Confirm> getConfirm() {
        return Optional.ofNullable(this.confirm);
    }

    @Override
    @JsonProperty
    public Optional<String> getUrl() {
        return Optional.ofNullable(this.url);
    }

    @Override
    @JsonProperty(value="style")
    public Optional<String> getRawStyle() {
        return Optional.ofNullable(this.rawStyle);
    }

    @Override
    @JsonProperty
    public Optional<ButtonStyle> getButtonStyle() {
        return this.buttonStyle;
    }

    @Override
    @JsonProperty
    public List<Option> getOptions() {
        return this.options;
    }

    @Override
    @JsonProperty
    public List<Option> getSelectedOptions() {
        return this.selectedOptions;
    }

    @Override
    @JsonProperty
    public Optional<SlackDataSource> getDataSource() {
        return Optional.ofNullable(this.dataSource);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getMinQueryLength() {
        return Optional.ofNullable(this.minQueryLength);
    }

    public final Action withName(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.name, newValue)) {
            return this;
        }
        return new Action(newValue, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withName(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.name, value)) {
            return this;
        }
        return new Action(value, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withType(ActionType value) {
        ActionType newValue = Objects.requireNonNull(value, "type");
        if (this.type == newValue) {
            return this;
        }
        return new Action(this.name, newValue, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return new Action(this.name, this.type, newValue, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return new Action(this.name, this.type, value, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withValue(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.value, newValue)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, newValue, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withValue(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.value, value)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withConfirm(@Nullable Confirm value) {
        Confirm newValue = value;
        if (this.confirm == newValue) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, newValue, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withConfirm(Optional<? extends Confirm> optional) {
        Confirm value = optional.orElse(null);
        if (this.confirm == value) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, value, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.url, newValue)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, newValue, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.url, value)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, value, this.rawStyle, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withRawStyle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.rawStyle, newValue)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, newValue, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withRawStyle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.rawStyle, value)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, value, this.options, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withOptions(Option ... elements) {
        List<Option> newValue = Action.createUnmodifiableList(false, Action.createSafeList(Arrays.asList(elements), true, false));
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, newValue, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withOptions(Iterable<? extends Option> elements) {
        if (this.options == elements) {
            return this;
        }
        List<Option> newValue = Action.createUnmodifiableList(false, Action.createSafeList(elements, true, false));
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, newValue, this.selectedOptions, this.dataSource, this.minQueryLength);
    }

    public final Action withSelectedOptions(Option ... elements) {
        List<Option> newValue = Action.createUnmodifiableList(false, Action.createSafeList(Arrays.asList(elements), true, false));
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, newValue, this.dataSource, this.minQueryLength);
    }

    public final Action withSelectedOptions(Iterable<? extends Option> elements) {
        if (this.selectedOptions == elements) {
            return this;
        }
        List<Option> newValue = Action.createUnmodifiableList(false, Action.createSafeList(elements, true, false));
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, newValue, this.dataSource, this.minQueryLength);
    }

    public final Action withDataSource(@Nullable SlackDataSource value) {
        SlackDataSource newValue = value;
        if (this.dataSource == newValue) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, newValue, this.minQueryLength);
    }

    public final Action withDataSource(Optional<? extends SlackDataSource> optional) {
        SlackDataSource value = optional.orElse(null);
        if (this.dataSource == value) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, value, this.minQueryLength);
    }

    public final Action withMinQueryLength(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.minQueryLength, newValue)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, newValue);
    }

    public final Action withMinQueryLength(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.minQueryLength, value)) {
            return this;
        }
        return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, this.options, this.selectedOptions, this.dataSource, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Action && this.equalTo(0, (Action)another);
    }

    private boolean equalTo(int synthetic, Action another) {
        return Objects.equals(this.name, another.name) && this.type.equals((Object)another.type) && Objects.equals(this.text, another.text) && Objects.equals(this.value, another.value) && Objects.equals(this.confirm, another.confirm) && Objects.equals(this.url, another.url) && Objects.equals(this.rawStyle, another.rawStyle) && this.buttonStyle.equals(another.buttonStyle) && this.options.equals(another.options) && this.selectedOptions.equals(another.selectedOptions) && Objects.equals((Object)this.dataSource, (Object)another.dataSource) && Objects.equals(this.minQueryLength, another.minQueryLength);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.name);
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + Objects.hashCode(this.value);
        h += (h << 5) + Objects.hashCode(this.confirm);
        h += (h << 5) + Objects.hashCode(this.url);
        h += (h << 5) + Objects.hashCode(this.rawStyle);
        h += (h << 5) + this.buttonStyle.hashCode();
        h += (h << 5) + this.options.hashCode();
        h += (h << 5) + this.selectedOptions.hashCode();
        h += (h << 5) + Objects.hashCode((Object)this.dataSource);
        h += (h << 5) + Objects.hashCode(this.minQueryLength);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Action{");
        if (this.name != null) {
            builder.append("name=").append(this.name);
        }
        if (builder.length() > 7) {
            builder.append(", ");
        }
        builder.append("type=").append((Object)this.type);
        if (this.text != null) {
            builder.append(", ");
            builder.append("text=").append(this.text);
        }
        if (this.value != null) {
            builder.append(", ");
            builder.append("value=").append(this.value);
        }
        if (this.confirm != null) {
            builder.append(", ");
            builder.append("confirm=").append(this.confirm);
        }
        if (this.url != null) {
            builder.append(", ");
            builder.append("url=").append(this.url);
        }
        if (this.rawStyle != null) {
            builder.append(", ");
            builder.append("rawStyle=").append(this.rawStyle);
        }
        builder.append(", ");
        builder.append("buttonStyle=").append(this.buttonStyle);
        builder.append(", ");
        builder.append("options=").append(this.options);
        builder.append(", ");
        builder.append("selectedOptions=").append(this.selectedOptions);
        if (this.dataSource != null) {
            builder.append(", ");
            builder.append("dataSource=").append((Object)this.dataSource);
        }
        if (this.minQueryLength != null) {
            builder.append(", ");
            builder.append("minQueryLength=").append(this.minQueryLength);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Action fromJson(Json json) {
        Builder builder = Action.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.confirm != null) {
            builder.setConfirm(json.confirm);
        }
        if (json.url != null) {
            builder.setUrl(json.url);
        }
        if (json.rawStyle != null) {
            builder.setRawStyle(json.rawStyle);
        }
        if (json.options != null) {
            builder.addAllOptions(json.options);
        }
        if (json.selectedOptions != null) {
            builder.addAllSelectedOptions(json.selectedOptions);
        }
        if (json.dataSource != null) {
            builder.setDataSource(json.dataSource);
        }
        if (json.minQueryLength != null) {
            builder.setMinQueryLength(json.minQueryLength);
        }
        return builder.build();
    }

    public static Action copyOf(ActionIF instance) {
        if (instance instanceof Action) {
            return (Action)instance;
        }
        return Action.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ActionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @Nullable
        private String name;
        @Nullable
        private ActionType type;
        @Nullable
        private String text;
        @Nullable
        private String value;
        @Nullable
        private Confirm confirm;
        @Nullable
        private String url;
        @Nullable
        private String rawStyle;
        private List<Option> options = new ArrayList<Option>();
        private List<Option> selectedOptions = new ArrayList<Option>();
        @Nullable
        private SlackDataSource dataSource;
        @Nullable
        private Integer minQueryLength;

        private Builder() {
        }

        public final Builder from(ActionIF instance) {
            Optional<Integer> minQueryLengthOptional;
            Optional<String> rawStyleOptional;
            Optional<String> urlOptional;
            Optional<Confirm> confirmOptional;
            Optional<String> valueOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> nameOptional = instance.getName();
            if (nameOptional.isPresent()) {
                this.setName(nameOptional);
            }
            this.setType(instance.getType());
            Optional<String> textOptional = instance.getText();
            if (textOptional.isPresent()) {
                this.setText(textOptional);
            }
            if ((valueOptional = instance.getValue()).isPresent()) {
                this.setValue(valueOptional);
            }
            if ((confirmOptional = instance.getConfirm()).isPresent()) {
                this.setConfirm(confirmOptional);
            }
            if ((urlOptional = instance.getUrl()).isPresent()) {
                this.setUrl(urlOptional);
            }
            if ((rawStyleOptional = instance.getRawStyle()).isPresent()) {
                this.setRawStyle(rawStyleOptional);
            }
            this.addAllOptions(instance.getOptions());
            this.addAllSelectedOptions(instance.getSelectedOptions());
            Optional<SlackDataSource> dataSourceOptional = instance.getDataSource();
            if (dataSourceOptional.isPresent()) {
                this.setDataSource(dataSourceOptional);
            }
            if ((minQueryLengthOptional = instance.getMinQueryLength()).isPresent()) {
                this.setMinQueryLength(minQueryLengthOptional);
            }
            return this;
        }

        public final Builder setName(@Nullable String name) {
            this.name = name;
            return this;
        }

        public final Builder setName(Optional<String> name) {
            this.name = name.orElse(null);
            return this;
        }

        public final Builder setType(ActionType type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder setValue(@Nullable String value) {
            this.value = value;
            return this;
        }

        public final Builder setValue(Optional<String> value) {
            this.value = value.orElse(null);
            return this;
        }

        public final Builder setConfirm(@Nullable Confirm confirm) {
            this.confirm = confirm;
            return this;
        }

        public final Builder setConfirm(Optional<? extends Confirm> confirm) {
            this.confirm = confirm.orElse(null);
            return this;
        }

        public final Builder setUrl(@Nullable String url) {
            this.url = url;
            return this;
        }

        public final Builder setUrl(Optional<String> url) {
            this.url = url.orElse(null);
            return this;
        }

        public final Builder setRawStyle(@Nullable String rawStyle) {
            this.rawStyle = rawStyle;
            return this;
        }

        public final Builder setRawStyle(Optional<String> rawStyle) {
            this.rawStyle = rawStyle.orElse(null);
            return this;
        }

        public final Builder addOptions(Option element) {
            this.options.add(Objects.requireNonNull(element, "options element"));
            return this;
        }

        public final Builder addOptions(Option ... elements) {
            for (Option element : elements) {
                this.options.add(Objects.requireNonNull(element, "options element"));
            }
            return this;
        }

        public final Builder setOptions(Iterable<? extends Option> elements) {
            this.options.clear();
            return this.addAllOptions(elements);
        }

        public final Builder addAllOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.options.add(Objects.requireNonNull(option, "options element"));
            }
            return this;
        }

        public final Builder addSelectedOptions(Option element) {
            this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            return this;
        }

        public final Builder addSelectedOptions(Option ... elements) {
            for (Option element : elements) {
                this.selectedOptions.add(Objects.requireNonNull(element, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setSelectedOptions(Iterable<? extends Option> elements) {
            this.selectedOptions.clear();
            return this.addAllSelectedOptions(elements);
        }

        public final Builder addAllSelectedOptions(Iterable<? extends Option> elements) {
            for (Option option : elements) {
                this.selectedOptions.add(Objects.requireNonNull(option, "selectedOptions element"));
            }
            return this;
        }

        public final Builder setDataSource(@Nullable SlackDataSource dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        public final Builder setDataSource(Optional<? extends SlackDataSource> dataSource) {
            this.dataSource = dataSource.orElse(null);
            return this;
        }

        public final Builder setMinQueryLength(@Nullable Integer minQueryLength) {
            this.minQueryLength = minQueryLength;
            return this;
        }

        public final Builder setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength.orElse(null);
            return this;
        }

        public Action build() {
            this.checkRequiredAttributes();
            return new Action(this.name, this.type, this.text, this.value, this.confirm, this.url, this.rawStyle, Action.createUnmodifiableList(true, this.options), Action.createUnmodifiableList(true, this.selectedOptions), this.dataSource, this.minQueryLength);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            return "Cannot build Action, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ActionIF", generator="Immutables")
    static final class Json
    implements ActionIF {
        @Nullable
        Optional<String> name = Optional.empty();
        @Nullable
        ActionType type;
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        Optional<String> value = Optional.empty();
        @Nullable
        Optional<Confirm> confirm = Optional.empty();
        @Nullable
        Optional<String> url = Optional.empty();
        @Nullable
        Optional<String> rawStyle = Optional.empty();
        @Nullable
        List<Option> options = Collections.emptyList();
        @Nullable
        List<Option> selectedOptions = Collections.emptyList();
        @Nullable
        Optional<SlackDataSource> dataSource = Optional.empty();
        @Nullable
        Optional<Integer> minQueryLength = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setName(Optional<String> name) {
            this.name = name;
        }

        @JsonProperty
        public void setType(ActionType type) {
            this.type = type;
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setValue(Optional<String> value) {
            this.value = value;
        }

        @JsonProperty
        public void setConfirm(Optional<Confirm> confirm) {
            this.confirm = confirm;
        }

        @JsonProperty
        public void setUrl(Optional<String> url) {
            this.url = url;
        }

        @JsonProperty(value="style")
        public void setRawStyle(Optional<String> rawStyle) {
            this.rawStyle = rawStyle;
        }

        @JsonProperty
        public void setOptions(List<Option> options) {
            this.options = options;
        }

        @JsonProperty
        public void setSelectedOptions(List<Option> selectedOptions) {
            this.selectedOptions = selectedOptions;
        }

        @JsonProperty
        public void setDataSource(Optional<SlackDataSource> dataSource) {
            this.dataSource = dataSource;
        }

        @JsonProperty
        public void setMinQueryLength(Optional<Integer> minQueryLength) {
            this.minQueryLength = minQueryLength;
        }

        @Override
        public Optional<String> getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ActionType getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Confirm> getConfirm() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getRawStyle() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public Optional<ButtonStyle> getButtonStyle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Option> getSelectedOptions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<SlackDataSource> getDataSource() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getMinQueryLength() {
            throw new UnsupportedOperationException();
        }
    }
}

