/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelType;
import com.hubspot.slack.client.models.SlackChannelIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="SlackChannelIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class SlackChannel
implements SlackChannelIF {
    private final String id;
    private final String name;
    @Nullable
    private final Boolean isArchived;
    @Nullable
    private final Boolean isGeneral;
    @Nullable
    private final Boolean isPrivate;
    @Nullable
    private final Boolean isMember;
    @Nullable
    private final Boolean isShared;
    private final transient ChannelType channelType;

    private SlackChannel(String id, String name, @Nullable Boolean isArchived, @Nullable Boolean isGeneral, @Nullable Boolean isPrivate, @Nullable Boolean isMember, @Nullable Boolean isShared) {
        this.id = id;
        this.name = name;
        this.isArchived = isArchived;
        this.isGeneral = isGeneral;
        this.isPrivate = isPrivate;
        this.isMember = isMember;
        this.isShared = isShared;
        this.channelType = Objects.requireNonNull(SlackChannelIF.super.getChannelType(), "channelType");
    }

    @Override
    @JsonProperty
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsArchived() {
        return Optional.ofNullable(this.isArchived);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsGeneral() {
        return Optional.ofNullable(this.isGeneral);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsPrivate() {
        return Optional.ofNullable(this.isPrivate);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsMember() {
        return Optional.ofNullable(this.isMember);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getIsShared() {
        return Optional.ofNullable(this.isShared);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public ChannelType getChannelType() {
        return this.channelType;
    }

    public final SlackChannel withId(String value) {
        String newValue = Objects.requireNonNull(value, "id");
        if (this.id.equals(newValue)) {
            return this;
        }
        return new SlackChannel(newValue, this.name, this.isArchived, this.isGeneral, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new SlackChannel(this.id, newValue, this.isArchived, this.isGeneral, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withIsArchived(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isArchived, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, newValue, this.isGeneral, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withIsArchived(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isArchived, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, value, this.isGeneral, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withIsGeneral(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isGeneral, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, newValue, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withIsGeneral(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isGeneral, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, value, this.isPrivate, this.isMember, this.isShared);
    }

    public final SlackChannel withIsPrivate(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isPrivate, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, newValue, this.isMember, this.isShared);
    }

    public final SlackChannel withIsPrivate(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isPrivate, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, value, this.isMember, this.isShared);
    }

    public final SlackChannel withIsMember(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isMember, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, this.isPrivate, newValue, this.isShared);
    }

    public final SlackChannel withIsMember(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isMember, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, this.isPrivate, value, this.isShared);
    }

    public final SlackChannel withIsShared(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.isShared, newValue)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, this.isPrivate, this.isMember, newValue);
    }

    public final SlackChannel withIsShared(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.isShared, value)) {
            return this;
        }
        return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, this.isPrivate, this.isMember, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof SlackChannel && this.equalTo(0, (SlackChannel)another);
    }

    private boolean equalTo(int synthetic, SlackChannel another) {
        return this.id.equals(another.id) && this.name.equals(another.name) && Objects.equals(this.isArchived, another.isArchived) && Objects.equals(this.isGeneral, another.isGeneral) && Objects.equals(this.isPrivate, another.isPrivate) && Objects.equals(this.isMember, another.isMember) && Objects.equals(this.isShared, another.isShared) && this.channelType.equals((Object)another.channelType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + Objects.hashCode(this.isArchived);
        h += (h << 5) + Objects.hashCode(this.isGeneral);
        h += (h << 5) + Objects.hashCode(this.isPrivate);
        h += (h << 5) + Objects.hashCode(this.isMember);
        h += (h << 5) + Objects.hashCode(this.isShared);
        h += (h << 5) + this.channelType.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("SlackChannel{");
        builder.append("id=").append(this.id);
        builder.append(", ");
        builder.append("name=").append(this.name);
        if (this.isArchived != null) {
            builder.append(", ");
            builder.append("isArchived=").append(this.isArchived);
        }
        if (this.isGeneral != null) {
            builder.append(", ");
            builder.append("isGeneral=").append(this.isGeneral);
        }
        if (this.isPrivate != null) {
            builder.append(", ");
            builder.append("isPrivate=").append(this.isPrivate);
        }
        if (this.isMember != null) {
            builder.append(", ");
            builder.append("isMember=").append(this.isMember);
        }
        if (this.isShared != null) {
            builder.append(", ");
            builder.append("isShared=").append(this.isShared);
        }
        builder.append(", ");
        builder.append("channelType=").append((Object)this.channelType);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static SlackChannel fromJson(Json json) {
        Builder builder = SlackChannel.builder();
        if (json.id != null) {
            builder.setId(json.id);
        }
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.isArchived != null) {
            builder.setIsArchived(json.isArchived);
        }
        if (json.isGeneral != null) {
            builder.setIsGeneral(json.isGeneral);
        }
        if (json.isPrivate != null) {
            builder.setIsPrivate(json.isPrivate);
        }
        if (json.isMember != null) {
            builder.setIsMember(json.isMember);
        }
        if (json.isShared != null) {
            builder.setIsShared(json.isShared);
        }
        return builder.build();
    }

    public static SlackChannel copyOf(SlackChannelIF instance) {
        if (instance instanceof SlackChannel) {
            return (SlackChannel)instance;
        }
        return SlackChannel.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="SlackChannelIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private long initBits = 3L;
        @Nullable
        private String id;
        @Nullable
        private String name;
        @Nullable
        private Boolean isArchived;
        @Nullable
        private Boolean isGeneral;
        @Nullable
        private Boolean isPrivate;
        @Nullable
        private Boolean isMember;
        @Nullable
        private Boolean isShared;

        private Builder() {
        }

        public final Builder from(SlackChannelIF instance) {
            Optional<Boolean> isSharedOptional;
            Optional<Boolean> isMemberOptional;
            Optional<Boolean> isPrivateOptional;
            Optional<Boolean> isGeneralOptional;
            Objects.requireNonNull(instance, "instance");
            this.setId(instance.getId());
            this.setName(instance.getName());
            Optional<Boolean> isArchivedOptional = instance.getIsArchived();
            if (isArchivedOptional.isPresent()) {
                this.setIsArchived(isArchivedOptional);
            }
            if ((isGeneralOptional = instance.getIsGeneral()).isPresent()) {
                this.setIsGeneral(isGeneralOptional);
            }
            if ((isPrivateOptional = instance.getIsPrivate()).isPresent()) {
                this.setIsPrivate(isPrivateOptional);
            }
            if ((isMemberOptional = instance.getIsMember()).isPresent()) {
                this.setIsMember(isMemberOptional);
            }
            if ((isSharedOptional = instance.getIsShared()).isPresent()) {
                this.setIsShared(isSharedOptional);
            }
            return this;
        }

        public final Builder setId(String id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setIsArchived(@Nullable Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Builder setIsArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived.orElse(null);
            return this;
        }

        public final Builder setIsGeneral(@Nullable Boolean isGeneral) {
            this.isGeneral = isGeneral;
            return this;
        }

        public final Builder setIsGeneral(Optional<Boolean> isGeneral) {
            this.isGeneral = isGeneral.orElse(null);
            return this;
        }

        public final Builder setIsPrivate(@Nullable Boolean isPrivate) {
            this.isPrivate = isPrivate;
            return this;
        }

        public final Builder setIsPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate.orElse(null);
            return this;
        }

        public final Builder setIsMember(@Nullable Boolean isMember) {
            this.isMember = isMember;
            return this;
        }

        public final Builder setIsMember(Optional<Boolean> isMember) {
            this.isMember = isMember.orElse(null);
            return this;
        }

        public final Builder setIsShared(@Nullable Boolean isShared) {
            this.isShared = isShared;
            return this;
        }

        public final Builder setIsShared(Optional<Boolean> isShared) {
            this.isShared = isShared.orElse(null);
            return this;
        }

        public SlackChannel build() {
            this.checkRequiredAttributes();
            return new SlackChannel(this.id, this.name, this.isArchived, this.isGeneral, this.isPrivate, this.isMember, this.isShared);
        }

        private boolean idIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean nameIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.idIsSet()) {
                attributes.add("id");
            }
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            return "Cannot build SlackChannel, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="SlackChannelIF", generator="Immutables")
    static final class Json
    implements SlackChannelIF {
        @Nullable
        String id;
        @Nullable
        String name;
        @Nullable
        Optional<Boolean> isArchived = Optional.empty();
        @Nullable
        Optional<Boolean> isGeneral = Optional.empty();
        @Nullable
        Optional<Boolean> isPrivate = Optional.empty();
        @Nullable
        Optional<Boolean> isMember = Optional.empty();
        @Nullable
        Optional<Boolean> isShared = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setId(String id) {
            this.id = id;
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setIsArchived(Optional<Boolean> isArchived) {
            this.isArchived = isArchived;
        }

        @JsonProperty
        public void setIsGeneral(Optional<Boolean> isGeneral) {
            this.isGeneral = isGeneral;
        }

        @JsonProperty
        public void setIsPrivate(Optional<Boolean> isPrivate) {
            this.isPrivate = isPrivate;
        }

        @JsonProperty
        public void setIsMember(Optional<Boolean> isMember) {
            this.isMember = isMember;
        }

        @JsonProperty
        public void setIsShared(Optional<Boolean> isShared) {
            this.isShared = isShared;
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsArchived() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsGeneral() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsPrivate() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsMember() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getIsShared() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public ChannelType getChannelType() {
            throw new UnsupportedOperationException();
        }
    }
}

