/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ReactionIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ReactionIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class Reaction
implements ReactionIF {
    private final String name;
    private final int count;
    private final List<String> users;

    private Reaction(String name, int count, List<String> users) {
        this.name = name;
        this.count = count;
        this.users = users;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @Override
    @JsonProperty
    public int getCount() {
        return this.count;
    }

    @Override
    @JsonProperty
    public List<String> getUsers() {
        return this.users;
    }

    public final Reaction withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Reaction(newValue, this.count, this.users);
    }

    public final Reaction withCount(int value) {
        if (this.count == value) {
            return this;
        }
        return new Reaction(this.name, value, this.users);
    }

    public final Reaction withUsers(String ... elements) {
        List<String> newValue = Reaction.createUnmodifiableList(false, Reaction.createSafeList(Arrays.asList(elements), true, false));
        return new Reaction(this.name, this.count, newValue);
    }

    public final Reaction withUsers(Iterable<String> elements) {
        if (this.users == elements) {
            return this;
        }
        List<String> newValue = Reaction.createUnmodifiableList(false, Reaction.createSafeList(elements, true, false));
        return new Reaction(this.name, this.count, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Reaction && this.equalTo(0, (Reaction)another);
    }

    private boolean equalTo(int synthetic, Reaction another) {
        return this.name.equals(another.name) && this.count == another.count && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.count;
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        return "Reaction{name=" + this.name + ", count=" + this.count + ", users=" + this.users + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static Reaction fromJson(Json json) {
        Builder builder = Reaction.builder();
        if (json.name != null) {
            builder.setName(json.name);
        }
        if (json.countIsSet) {
            builder.setCount(json.count);
        }
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        return builder.build();
    }

    public static Reaction copyOf(ReactionIF instance) {
        if (instance instanceof Reaction) {
            return (Reaction)instance;
        }
        return Reaction.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ReactionIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_COUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private String name;
        private int count;
        private List<String> users = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(ReactionIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setName(instance.getName());
            this.setCount(instance.getCount());
            this.addAllUsers(instance.getUsers());
            return this;
        }

        public final Builder setName(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCount(int count) {
            this.count = count;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addUsers(String element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(String ... elements) {
            for (String element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder setUsers(Iterable<String> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<String> elements) {
            for (String element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public Reaction build() {
            this.checkRequiredAttributes();
            return new Reaction(this.name, this.count, Reaction.createUnmodifiableList(true, this.users));
        }

        private boolean nameIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean countIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.nameIsSet()) {
                attributes.add("name");
            }
            if (!this.countIsSet()) {
                attributes.add("count");
            }
            return "Cannot build Reaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ReactionIF", generator="Immutables")
    static final class Json
    implements ReactionIF {
        @Nullable
        String name;
        int count;
        boolean countIsSet;
        @Nullable
        List<String> users = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setName(String name) {
            this.name = name;
        }

        @JsonProperty
        public void setCount(int count) {
            this.count = count;
            this.countIsSet = true;
        }

        @JsonProperty
        public void setUsers(List<String> users) {
            this.users = users;
        }

        @Override
        public String getName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getUsers() {
            throw new UnsupportedOperationException();
        }
    }
}

