/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.LiteMessageIF;
import com.hubspot.slack.client.models.Reaction;
import com.hubspot.slack.client.models.blocks.Block;
import com.hubspot.slack.client.models.files.SlackFile;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="LiteMessageIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class LiteMessage
implements LiteMessageIF {
    private final String type;
    @Nullable
    private final String subtype;
    @Nullable
    private final String user;
    @Nullable
    private final String botId;
    @Nullable
    private final String username;
    private final String text;
    private final List<Attachment> attachments;
    private final List<SlackFile> files;
    private final List<Block> blocks;
    private final List<Reaction> reactions;
    private final String timestamp;
    @Nullable
    private final String threadTimestamp;
    @Nullable
    private final Integer replyCount;
    @Nullable
    private final List<String> replyUserIds;
    @Nullable
    private final Integer replyUsersCount;
    @Nullable
    private final String latestReplyTimestamp;

    private LiteMessage(String type, @Nullable String subtype, @Nullable String user, @Nullable String botId, @Nullable String username, String text, List<Attachment> attachments, List<SlackFile> files, List<Block> blocks, List<Reaction> reactions, String timestamp, @Nullable String threadTimestamp, @Nullable Integer replyCount, @Nullable List<String> replyUserIds, @Nullable Integer replyUsersCount, @Nullable String latestReplyTimestamp) {
        this.type = type;
        this.subtype = subtype;
        this.user = user;
        this.botId = botId;
        this.username = username;
        this.text = text;
        this.attachments = attachments;
        this.files = files;
        this.blocks = blocks;
        this.reactions = reactions;
        this.timestamp = timestamp;
        this.threadTimestamp = threadTimestamp;
        this.replyCount = replyCount;
        this.replyUserIds = replyUserIds;
        this.replyUsersCount = replyUsersCount;
        this.latestReplyTimestamp = latestReplyTimestamp;
    }

    @Override
    @JsonProperty
    public String getType() {
        return this.type;
    }

    @Override
    @JsonProperty
    public Optional<String> getSubtype() {
        return Optional.ofNullable(this.subtype);
    }

    @Override
    @JsonProperty
    public Optional<String> getUser() {
        return Optional.ofNullable(this.user);
    }

    @Override
    @JsonProperty
    public Optional<String> getBotId() {
        return Optional.ofNullable(this.botId);
    }

    @Override
    @JsonProperty
    public Optional<String> getUsername() {
        return Optional.ofNullable(this.username);
    }

    @Override
    @JsonProperty
    public String getText() {
        return this.text;
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<SlackFile> getFiles() {
        return this.files;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        return this.blocks;
    }

    @Override
    @JsonProperty
    public List<Reaction> getReactions() {
        return this.reactions;
    }

    @Override
    @JsonProperty(value="ts")
    public String getTimestamp() {
        return this.timestamp;
    }

    @Override
    @JsonProperty(value="thread_ts")
    public Optional<String> getThreadTimestamp() {
        return Optional.ofNullable(this.threadTimestamp);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyCount() {
        return Optional.ofNullable(this.replyCount);
    }

    @Override
    @JsonProperty(value="reply_users")
    public Optional<List<String>> getReplyUserIds() {
        return Optional.ofNullable(this.replyUserIds);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getReplyUsersCount() {
        return Optional.ofNullable(this.replyUsersCount);
    }

    @Override
    @JsonProperty(value="latest_reply")
    public Optional<String> getLatestReplyTimestamp() {
        return Optional.ofNullable(this.latestReplyTimestamp);
    }

    public final LiteMessage withType(String value) {
        String newValue = Objects.requireNonNull(value, "type");
        if (this.type.equals(newValue)) {
            return this;
        }
        return new LiteMessage(newValue, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withSubtype(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.subtype, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, newValue, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withSubtype(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.subtype, value)) {
            return this;
        }
        return new LiteMessage(this.type, value, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withUser(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.user, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, newValue, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withUser(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.user, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, value, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withBotId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.botId, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, newValue, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withBotId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.botId, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, value, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withUsername(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.username, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, newValue, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withUsername(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.username, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, value, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withText(String value) {
        String newValue = Objects.requireNonNull(value, "text");
        if (this.text.equals(newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, newValue, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withAttachments(Attachment ... elements) {
        List<Attachment> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, newValue, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, newValue, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withFiles(SlackFile ... elements) {
        List<SlackFile> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, newValue, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withFiles(Iterable<? extends SlackFile> elements) {
        if (this.files == elements) {
            return this;
        }
        List<SlackFile> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, newValue, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withBlocks(Block ... elements) {
        List<Block> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, newValue, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, newValue, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReactions(Reaction ... elements) {
        List<Reaction> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(Arrays.asList(elements), true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, newValue, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReactions(Iterable<? extends Reaction> elements) {
        if (this.reactions == elements) {
            return this;
        }
        List<Reaction> newValue = LiteMessage.createUnmodifiableList(false, LiteMessage.createSafeList(elements, true, false));
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, newValue, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withTimestamp(String value) {
        String newValue = Objects.requireNonNull(value, "timestamp");
        if (this.timestamp.equals(newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, newValue, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withThreadTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTimestamp, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, newValue, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withThreadTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTimestamp, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, value, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyCount, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, newValue, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyCount, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, value, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyUserIds(@Nullable List<String> value) {
        List<String> newValue = value;
        if (this.replyUserIds == newValue) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, newValue, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyUserIds(Optional<? extends List<String>> optional) {
        List value = optional.orElse(null);
        if (this.replyUserIds == value) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, value, this.replyUsersCount, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyUsersCount(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.replyUsersCount, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, newValue, this.latestReplyTimestamp);
    }

    public final LiteMessage withReplyUsersCount(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.replyUsersCount, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, value, this.latestReplyTimestamp);
    }

    public final LiteMessage withLatestReplyTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.latestReplyTimestamp, newValue)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, newValue);
    }

    public final LiteMessage withLatestReplyTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.latestReplyTimestamp, value)) {
            return this;
        }
        return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, this.attachments, this.files, this.blocks, this.reactions, this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof LiteMessage && this.equalTo(0, (LiteMessage)another);
    }

    private boolean equalTo(int synthetic, LiteMessage another) {
        return this.type.equals(another.type) && Objects.equals(this.subtype, another.subtype) && Objects.equals(this.user, another.user) && Objects.equals(this.botId, another.botId) && Objects.equals(this.username, another.username) && this.text.equals(another.text) && this.attachments.equals(another.attachments) && this.files.equals(another.files) && this.blocks.equals(another.blocks) && this.reactions.equals(another.reactions) && this.timestamp.equals(another.timestamp) && Objects.equals(this.threadTimestamp, another.threadTimestamp) && Objects.equals(this.replyCount, another.replyCount) && Objects.equals(this.replyUserIds, another.replyUserIds) && Objects.equals(this.replyUsersCount, another.replyUsersCount) && Objects.equals(this.latestReplyTimestamp, another.latestReplyTimestamp);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.subtype);
        h += (h << 5) + Objects.hashCode(this.user);
        h += (h << 5) + Objects.hashCode(this.botId);
        h += (h << 5) + Objects.hashCode(this.username);
        h += (h << 5) + this.text.hashCode();
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.reactions.hashCode();
        h += (h << 5) + this.timestamp.hashCode();
        h += (h << 5) + Objects.hashCode(this.threadTimestamp);
        h += (h << 5) + Objects.hashCode(this.replyCount);
        h += (h << 5) + Objects.hashCode(this.replyUserIds);
        h += (h << 5) + Objects.hashCode(this.replyUsersCount);
        h += (h << 5) + Objects.hashCode(this.latestReplyTimestamp);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("LiteMessage{");
        builder.append("type=").append(this.type);
        if (this.subtype != null) {
            builder.append(", ");
            builder.append("subtype=").append(this.subtype);
        }
        if (this.user != null) {
            builder.append(", ");
            builder.append("user=").append(this.user);
        }
        if (this.botId != null) {
            builder.append(", ");
            builder.append("botId=").append(this.botId);
        }
        if (this.username != null) {
            builder.append(", ");
            builder.append("username=").append(this.username);
        }
        builder.append(", ");
        builder.append("text=").append(this.text);
        builder.append(", ");
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("files=").append(this.files);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("reactions=").append(this.reactions);
        builder.append(", ");
        builder.append("timestamp=").append(this.timestamp);
        if (this.threadTimestamp != null) {
            builder.append(", ");
            builder.append("threadTimestamp=").append(this.threadTimestamp);
        }
        if (this.replyCount != null) {
            builder.append(", ");
            builder.append("replyCount=").append(this.replyCount);
        }
        if (this.replyUserIds != null) {
            builder.append(", ");
            builder.append("replyUserIds=").append(this.replyUserIds);
        }
        if (this.replyUsersCount != null) {
            builder.append(", ");
            builder.append("replyUsersCount=").append(this.replyUsersCount);
        }
        if (this.latestReplyTimestamp != null) {
            builder.append(", ");
            builder.append("latestReplyTimestamp=").append(this.latestReplyTimestamp);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static LiteMessage fromJson(Json json) {
        Builder builder = LiteMessage.builder();
        if (json.type != null) {
            builder.setType(json.type);
        }
        if (json.subtype != null) {
            builder.setSubtype(json.subtype);
        }
        if (json.user != null) {
            builder.setUser(json.user);
        }
        if (json.botId != null) {
            builder.setBotId(json.botId);
        }
        if (json.username != null) {
            builder.setUsername(json.username);
        }
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        if (json.blocks != null) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.reactions != null) {
            builder.addAllReactions(json.reactions);
        }
        if (json.timestamp != null) {
            builder.setTimestamp(json.timestamp);
        }
        if (json.threadTimestamp != null) {
            builder.setThreadTimestamp(json.threadTimestamp);
        }
        if (json.replyCount != null) {
            builder.setReplyCount(json.replyCount);
        }
        if (json.replyUserIds != null) {
            builder.setReplyUserIds(json.replyUserIds);
        }
        if (json.replyUsersCount != null) {
            builder.setReplyUsersCount(json.replyUsersCount);
        }
        if (json.latestReplyTimestamp != null) {
            builder.setLatestReplyTimestamp(json.latestReplyTimestamp);
        }
        return builder.build();
    }

    public static LiteMessage copyOf(LiteMessageIF instance) {
        if (instance instanceof LiteMessage) {
            return (LiteMessage)instance;
        }
        return LiteMessage.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="LiteMessageIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private static final long INIT_BIT_TEXT = 2L;
        private static final long INIT_BIT_TIMESTAMP = 4L;
        private long initBits = 7L;
        @Nullable
        private String type;
        @Nullable
        private String subtype;
        @Nullable
        private String user;
        @Nullable
        private String botId;
        @Nullable
        private String username;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<SlackFile> files = new ArrayList<SlackFile>();
        private List<Block> blocks = new ArrayList<Block>();
        private List<Reaction> reactions = new ArrayList<Reaction>();
        @Nullable
        private String timestamp;
        @Nullable
        private String threadTimestamp;
        @Nullable
        private Integer replyCount;
        @Nullable
        private List<String> replyUserIds;
        @Nullable
        private Integer replyUsersCount;
        @Nullable
        private String latestReplyTimestamp;

        private Builder() {
        }

        public final Builder from(LiteMessageIF instance) {
            Optional<String> latestReplyTimestampOptional;
            Optional<Integer> replyUsersCountOptional;
            Optional<List<String>> replyUserIdsOptional;
            Optional<Integer> replyCountOptional;
            Optional<String> usernameOptional;
            Optional<String> botIdOptional;
            Optional<String> userOptional;
            Objects.requireNonNull(instance, "instance");
            this.setType(instance.getType());
            Optional<String> subtypeOptional = instance.getSubtype();
            if (subtypeOptional.isPresent()) {
                this.setSubtype(subtypeOptional);
            }
            if ((userOptional = instance.getUser()).isPresent()) {
                this.setUser(userOptional);
            }
            if ((botIdOptional = instance.getBotId()).isPresent()) {
                this.setBotId(botIdOptional);
            }
            if ((usernameOptional = instance.getUsername()).isPresent()) {
                this.setUsername(usernameOptional);
            }
            this.setText(instance.getText());
            this.addAllAttachments(instance.getAttachments());
            this.addAllFiles(instance.getFiles());
            this.addAllBlocks(instance.getBlocks());
            this.addAllReactions(instance.getReactions());
            this.setTimestamp(instance.getTimestamp());
            Optional<String> threadTimestampOptional = instance.getThreadTimestamp();
            if (threadTimestampOptional.isPresent()) {
                this.setThreadTimestamp(threadTimestampOptional);
            }
            if ((replyCountOptional = instance.getReplyCount()).isPresent()) {
                this.setReplyCount(replyCountOptional);
            }
            if ((replyUserIdsOptional = instance.getReplyUserIds()).isPresent()) {
                this.setReplyUserIds(replyUserIdsOptional);
            }
            if ((replyUsersCountOptional = instance.getReplyUsersCount()).isPresent()) {
                this.setReplyUsersCount(replyUsersCountOptional);
            }
            if ((latestReplyTimestampOptional = instance.getLatestReplyTimestamp()).isPresent()) {
                this.setLatestReplyTimestamp(latestReplyTimestampOptional);
            }
            return this;
        }

        public final Builder setType(String type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setSubtype(@Nullable String subtype) {
            this.subtype = subtype;
            return this;
        }

        public final Builder setSubtype(Optional<String> subtype) {
            this.subtype = subtype.orElse(null);
            return this;
        }

        public final Builder setUser(@Nullable String user) {
            this.user = user;
            return this;
        }

        public final Builder setUser(Optional<String> user) {
            this.user = user.orElse(null);
            return this;
        }

        public final Builder setBotId(@Nullable String botId) {
            this.botId = botId;
            return this;
        }

        public final Builder setBotId(Optional<String> botId) {
            this.botId = botId.orElse(null);
            return this;
        }

        public final Builder setUsername(@Nullable String username) {
            this.username = username;
            return this;
        }

        public final Builder setUsername(Optional<String> username) {
            this.username = username.orElse(null);
            return this;
        }

        public final Builder setText(String text) {
            this.text = Objects.requireNonNull(text, "text");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addFiles(SlackFile element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(SlackFile ... elements) {
            for (SlackFile element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder setFiles(Iterable<? extends SlackFile> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends SlackFile> elements) {
            for (SlackFile slackFile : elements) {
                this.files.add(Objects.requireNonNull(slackFile, "files element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            return this;
        }

        public final Builder addReactions(Reaction element) {
            this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            return this;
        }

        public final Builder addReactions(Reaction ... elements) {
            for (Reaction element : elements) {
                this.reactions.add(Objects.requireNonNull(element, "reactions element"));
            }
            return this;
        }

        public final Builder setReactions(Iterable<? extends Reaction> elements) {
            this.reactions.clear();
            return this.addAllReactions(elements);
        }

        public final Builder addAllReactions(Iterable<? extends Reaction> elements) {
            for (Reaction reaction : elements) {
                this.reactions.add(Objects.requireNonNull(reaction, "reactions element"));
            }
            return this;
        }

        public final Builder setTimestamp(String timestamp) {
            this.timestamp = Objects.requireNonNull(timestamp, "timestamp");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder setThreadTimestamp(@Nullable String threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
            return this;
        }

        public final Builder setThreadTimestamp(Optional<String> threadTimestamp) {
            this.threadTimestamp = threadTimestamp.orElse(null);
            return this;
        }

        public final Builder setReplyCount(@Nullable Integer replyCount) {
            this.replyCount = replyCount;
            return this;
        }

        public final Builder setReplyCount(Optional<Integer> replyCount) {
            this.replyCount = replyCount.orElse(null);
            return this;
        }

        public final Builder setReplyUserIds(@Nullable List<String> replyUserIds) {
            this.replyUserIds = replyUserIds;
            return this;
        }

        public final Builder setReplyUserIds(Optional<? extends List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds.orElse(null);
            return this;
        }

        public final Builder setReplyUsersCount(@Nullable Integer replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
            return this;
        }

        public final Builder setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount.orElse(null);
            return this;
        }

        public final Builder setLatestReplyTimestamp(@Nullable String latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
            return this;
        }

        public final Builder setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp.orElse(null);
            return this;
        }

        public LiteMessage build() {
            this.checkRequiredAttributes();
            return new LiteMessage(this.type, this.subtype, this.user, this.botId, this.username, this.text, LiteMessage.createUnmodifiableList(true, this.attachments), LiteMessage.createUnmodifiableList(true, this.files), LiteMessage.createUnmodifiableList(true, this.blocks), LiteMessage.createUnmodifiableList(true, this.reactions), this.timestamp, this.threadTimestamp, this.replyCount, this.replyUserIds, this.replyUsersCount, this.latestReplyTimestamp);
        }

        private boolean typeIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean textIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean timestampIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.typeIsSet()) {
                attributes.add("type");
            }
            if (!this.textIsSet()) {
                attributes.add("text");
            }
            if (!this.timestampIsSet()) {
                attributes.add("timestamp");
            }
            return "Cannot build LiteMessage, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="LiteMessageIF", generator="Immutables")
    static final class Json
    implements LiteMessageIF {
        @Nullable
        String type;
        @Nullable
        Optional<String> subtype = Optional.empty();
        @Nullable
        Optional<String> user = Optional.empty();
        @Nullable
        Optional<String> botId = Optional.empty();
        @Nullable
        Optional<String> username = Optional.empty();
        @Nullable
        String text;
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        List<SlackFile> files = Collections.emptyList();
        @Nullable
        List<Block> blocks = Collections.emptyList();
        @Nullable
        List<Reaction> reactions = Collections.emptyList();
        @Nullable
        String timestamp;
        @Nullable
        Optional<String> threadTimestamp = Optional.empty();
        @Nullable
        Optional<Integer> replyCount = Optional.empty();
        @Nullable
        Optional<List<String>> replyUserIds = Optional.empty();
        @Nullable
        Optional<Integer> replyUsersCount = Optional.empty();
        @Nullable
        Optional<String> latestReplyTimestamp = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setType(String type) {
            this.type = type;
        }

        @JsonProperty
        public void setSubtype(Optional<String> subtype) {
            this.subtype = subtype;
        }

        @JsonProperty
        public void setUser(Optional<String> user) {
            this.user = user;
        }

        @JsonProperty
        public void setBotId(Optional<String> botId) {
            this.botId = botId;
        }

        @JsonProperty
        public void setUsername(Optional<String> username) {
            this.username = username;
        }

        @JsonProperty
        public void setText(String text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setFiles(List<SlackFile> files) {
            this.files = files;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
        }

        @JsonProperty
        public void setReactions(List<Reaction> reactions) {
            this.reactions = reactions;
        }

        @JsonProperty(value="ts")
        public void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @JsonProperty(value="thread_ts")
        public void setThreadTimestamp(Optional<String> threadTimestamp) {
            this.threadTimestamp = threadTimestamp;
        }

        @JsonProperty
        public void setReplyCount(Optional<Integer> replyCount) {
            this.replyCount = replyCount;
        }

        @JsonProperty(value="reply_users")
        public void setReplyUserIds(Optional<List<String>> replyUserIds) {
            this.replyUserIds = replyUserIds;
        }

        @JsonProperty
        public void setReplyUsersCount(Optional<Integer> replyUsersCount) {
            this.replyUsersCount = replyUsersCount;
        }

        @JsonProperty(value="latest_reply")
        public void setLatestReplyTimestamp(Optional<String> latestReplyTimestamp) {
            this.latestReplyTimestamp = latestReplyTimestamp;
        }

        @Override
        public String getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getSubtype() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUser() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getBotId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getUsername() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackFile> getFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Reaction> getReactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<List<String>> getReplyUserIds() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getReplyUsersCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getLatestReplyTimestamp() {
            throw new UnsupportedOperationException();
        }
    }
}

