/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.models;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.models.ChannelMetadataIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChannelMetadataIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChannelMetadata
implements ChannelMetadataIF {
    private final String value;
    private final String creatorId;
    private final long lastSetEpochSeconds;

    private ChannelMetadata(String value, String creatorId, long lastSetEpochSeconds) {
        this.value = value;
        this.creatorId = creatorId;
        this.lastSetEpochSeconds = lastSetEpochSeconds;
    }

    @Override
    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @Override
    @JsonProperty(value="creator")
    public String getCreatorId() {
        return this.creatorId;
    }

    @Override
    @JsonProperty(value="last_set")
    public long getLastSetEpochSeconds() {
        return this.lastSetEpochSeconds;
    }

    public final ChannelMetadata withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new ChannelMetadata(newValue, this.creatorId, this.lastSetEpochSeconds);
    }

    public final ChannelMetadata withCreatorId(String value) {
        String newValue = Objects.requireNonNull(value, "creatorId");
        if (this.creatorId.equals(newValue)) {
            return this;
        }
        return new ChannelMetadata(this.value, newValue, this.lastSetEpochSeconds);
    }

    public final ChannelMetadata withLastSetEpochSeconds(long value) {
        if (this.lastSetEpochSeconds == value) {
            return this;
        }
        return new ChannelMetadata(this.value, this.creatorId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChannelMetadata && this.equalTo(0, (ChannelMetadata)another);
    }

    private boolean equalTo(int synthetic, ChannelMetadata another) {
        return this.value.equals(another.value) && this.creatorId.equals(another.creatorId) && this.lastSetEpochSeconds == another.lastSetEpochSeconds;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.value.hashCode();
        h += (h << 5) + this.creatorId.hashCode();
        h += (h << 5) + Long.hashCode(this.lastSetEpochSeconds);
        return h;
    }

    public String toString() {
        return "ChannelMetadata{value=" + this.value + ", creatorId=" + this.creatorId + ", lastSetEpochSeconds=" + this.lastSetEpochSeconds + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChannelMetadata fromJson(Json json) {
        Builder builder = ChannelMetadata.builder();
        if (json.value != null) {
            builder.setValue(json.value);
        }
        if (json.creatorId != null) {
            builder.setCreatorId(json.creatorId);
        }
        if (json.lastSetEpochSecondsIsSet) {
            builder.setLastSetEpochSeconds(json.lastSetEpochSeconds);
        }
        return builder.build();
    }

    public static ChannelMetadata copyOf(ChannelMetadataIF instance) {
        if (instance instanceof ChannelMetadata) {
            return (ChannelMetadata)instance;
        }
        return ChannelMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChannelMetadataIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private static final long INIT_BIT_CREATOR_ID = 2L;
        private static final long INIT_BIT_LAST_SET_EPOCH_SECONDS = 4L;
        private long initBits = 7L;
        @Nullable
        private String value;
        @Nullable
        private String creatorId;
        private long lastSetEpochSeconds;

        private Builder() {
        }

        public final Builder from(ChannelMetadataIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.setValue(instance.getValue());
            this.setCreatorId(instance.getCreatorId());
            this.setLastSetEpochSeconds(instance.getLastSetEpochSeconds());
            return this;
        }

        public final Builder setValue(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setCreatorId(String creatorId) {
            this.creatorId = Objects.requireNonNull(creatorId, "creatorId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setLastSetEpochSeconds(long lastSetEpochSeconds) {
            this.lastSetEpochSeconds = lastSetEpochSeconds;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ChannelMetadata build() {
            this.checkRequiredAttributes();
            return new ChannelMetadata(this.value, this.creatorId, this.lastSetEpochSeconds);
        }

        private boolean valueIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean creatorIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private boolean lastSetEpochSecondsIsSet() {
            return (this.initBits & 4L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.valueIsSet()) {
                attributes.add("value");
            }
            if (!this.creatorIdIsSet()) {
                attributes.add("creatorId");
            }
            if (!this.lastSetEpochSecondsIsSet()) {
                attributes.add("lastSetEpochSeconds");
            }
            return "Cannot build ChannelMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChannelMetadataIF", generator="Immutables")
    static final class Json
    implements ChannelMetadataIF {
        @Nullable
        String value;
        @Nullable
        String creatorId;
        long lastSetEpochSeconds;
        boolean lastSetEpochSecondsIsSet;

        Json() {
        }

        @JsonProperty
        public void setValue(String value) {
            this.value = value;
        }

        @JsonProperty(value="creator")
        public void setCreatorId(String creatorId) {
            this.creatorId = creatorId;
        }

        @JsonProperty(value="last_set")
        public void setLastSetEpochSeconds(long lastSetEpochSeconds) {
            this.lastSetEpochSeconds = lastSetEpochSeconds;
            this.lastSetEpochSecondsIsSet = true;
        }

        @Override
        public String getValue() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getCreatorId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getLastSetEpochSeconds() {
            throw new UnsupportedOperationException();
        }
    }
}

