/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.migration;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.migration.MigrationExchangeParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="MigrationExchangeParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class MigrationExchangeParams
implements MigrationExchangeParamsIF {
    @Nullable
    private final String teamId;
    @Nullable
    private final Boolean toOld;
    private final Set<String> userIds;

    private MigrationExchangeParams(@Nullable String teamId, @Nullable Boolean toOld, Set<String> userIds) {
        this.teamId = teamId;
        this.toOld = toOld;
        this.userIds = userIds;
    }

    @Override
    @JsonProperty
    public Optional<String> getTeamId() {
        return Optional.ofNullable(this.teamId);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getToOld() {
        return Optional.ofNullable(this.toOld);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public Set<String> getUserIds() {
        return this.userIds;
    }

    public final MigrationExchangeParams withTeamId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.teamId, newValue)) {
            return this;
        }
        return new MigrationExchangeParams(newValue, this.toOld, this.userIds);
    }

    public final MigrationExchangeParams withTeamId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.teamId, value)) {
            return this;
        }
        return new MigrationExchangeParams(value, this.toOld, this.userIds);
    }

    public final MigrationExchangeParams withToOld(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.toOld, newValue)) {
            return this;
        }
        return new MigrationExchangeParams(this.teamId, newValue, this.userIds);
    }

    public final MigrationExchangeParams withToOld(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.toOld, value)) {
            return this;
        }
        return new MigrationExchangeParams(this.teamId, value, this.userIds);
    }

    public final MigrationExchangeParams withUserIds(String ... elements) {
        Set<String> newValue = MigrationExchangeParams.createUnmodifiableSet(MigrationExchangeParams.createSafeList(Arrays.asList(elements), true, false));
        return new MigrationExchangeParams(this.teamId, this.toOld, newValue);
    }

    public final MigrationExchangeParams withUserIds(Iterable<String> elements) {
        if (this.userIds == elements) {
            return this;
        }
        Set<String> newValue = MigrationExchangeParams.createUnmodifiableSet(MigrationExchangeParams.createSafeList(elements, true, false));
        return new MigrationExchangeParams(this.teamId, this.toOld, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MigrationExchangeParams && this.equalTo(0, (MigrationExchangeParams)another);
    }

    private boolean equalTo(int synthetic, MigrationExchangeParams another) {
        return Objects.equals(this.teamId, another.teamId) && Objects.equals(this.toOld, another.toOld) && this.userIds.equals(another.userIds);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.teamId);
        h += (h << 5) + Objects.hashCode(this.toOld);
        h += (h << 5) + this.userIds.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MigrationExchangeParams{");
        if (this.teamId != null) {
            builder.append("teamId=").append(this.teamId);
        }
        if (this.toOld != null) {
            if (builder.length() > 24) {
                builder.append(", ");
            }
            builder.append("toOld=").append(this.toOld);
        }
        if (builder.length() > 24) {
            builder.append(", ");
        }
        builder.append("userIds=").append(this.userIds);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static MigrationExchangeParams fromJson(Json json) {
        Builder builder = MigrationExchangeParams.builder();
        if (json.teamId != null) {
            builder.setTeamId(json.teamId);
        }
        if (json.toOld != null) {
            builder.setToOld(json.toOld);
        }
        if (json.userIds != null) {
            builder.addAllUserIds(json.userIds);
        }
        return builder.build();
    }

    public static MigrationExchangeParams copyOf(MigrationExchangeParamsIF instance) {
        if (instance instanceof MigrationExchangeParams) {
            return (MigrationExchangeParams)instance;
        }
        return MigrationExchangeParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size() * 4 / 3 + 1);
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @Generated(from="MigrationExchangeParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        @Nullable
        private String teamId;
        @Nullable
        private Boolean toOld;
        private List<String> userIds = new ArrayList<String>();

        private Builder() {
        }

        public final Builder from(MigrationExchangeParamsIF instance) {
            Optional<Boolean> toOldOptional;
            Objects.requireNonNull(instance, "instance");
            Optional<String> teamIdOptional = instance.getTeamId();
            if (teamIdOptional.isPresent()) {
                this.setTeamId(teamIdOptional);
            }
            if ((toOldOptional = instance.getToOld()).isPresent()) {
                this.setToOld(toOldOptional);
            }
            this.addAllUserIds(instance.getUserIds());
            return this;
        }

        public final Builder setTeamId(@Nullable String teamId) {
            this.teamId = teamId;
            return this;
        }

        public final Builder setTeamId(Optional<String> teamId) {
            this.teamId = teamId.orElse(null);
            return this;
        }

        public final Builder setToOld(@Nullable Boolean toOld) {
            this.toOld = toOld;
            return this;
        }

        public final Builder setToOld(Optional<Boolean> toOld) {
            this.toOld = toOld.orElse(null);
            return this;
        }

        public final Builder addUserIds(String element) {
            this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            return this;
        }

        public final Builder addUserIds(String ... elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public final Builder setUserIds(Iterable<String> elements) {
            this.userIds.clear();
            return this.addAllUserIds(elements);
        }

        public final Builder addAllUserIds(Iterable<String> elements) {
            for (String element : elements) {
                this.userIds.add(Objects.requireNonNull(element, "userIds element"));
            }
            return this;
        }

        public MigrationExchangeParams build() {
            return new MigrationExchangeParams(this.teamId, this.toOld, MigrationExchangeParams.createUnmodifiableSet(this.userIds));
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="MigrationExchangeParamsIF", generator="Immutables")
    static final class Json
    implements MigrationExchangeParamsIF {
        @Nullable
        Optional<String> teamId = Optional.empty();
        @Nullable
        Optional<Boolean> toOld = Optional.empty();
        @Nullable
        Set<String> userIds = Collections.emptySet();

        Json() {
        }

        @JsonProperty
        public void setTeamId(Optional<String> teamId) {
            this.teamId = teamId;
        }

        @JsonProperty
        public void setToOld(Optional<Boolean> toOld) {
            this.toOld = toOld;
        }

        @JsonProperty
        @JsonIgnore
        public void setUserIds(Set<String> userIds) {
            this.userIds = userIds;
        }

        @Override
        public Optional<String> getTeamId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getToOld() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<String> getUserIds() {
            throw new UnsupportedOperationException();
        }
    }
}

