/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.files;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.slack.client.methods.params.files.CompleteUploadExternalParamsIF;
import com.hubspot.slack.client.methods.params.files.FileInfo;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CompleteUploadExternalParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class CompleteUploadExternalParams
implements CompleteUploadExternalParamsIF {
    private final List<FileInfo> files;
    @Nullable
    private final String channelId;
    @Nullable
    private final String threadTs;
    @Nullable
    private final String initialComment;

    private CompleteUploadExternalParams(List<FileInfo> files, @Nullable String channelId, @Nullable String threadTs, @Nullable String initialComment) {
        this.files = files;
        this.channelId = channelId;
        this.threadTs = threadTs;
        this.initialComment = initialComment;
    }

    @Override
    @JsonProperty
    public List<FileInfo> getFiles() {
        return this.files;
    }

    @Override
    @JsonProperty
    public Optional<String> getChannelId() {
        return Optional.ofNullable(this.channelId);
    }

    @Override
    @JsonProperty
    public Optional<String> getThreadTs() {
        return Optional.ofNullable(this.threadTs);
    }

    @Override
    @JsonProperty
    public Optional<String> getInitialComment() {
        return Optional.ofNullable(this.initialComment);
    }

    public final CompleteUploadExternalParams withFiles(FileInfo ... elements) {
        List<FileInfo> newValue = CompleteUploadExternalParams.createUnmodifiableList(false, CompleteUploadExternalParams.createSafeList(Arrays.asList(elements), true, false));
        return new CompleteUploadExternalParams(newValue, this.channelId, this.threadTs, this.initialComment);
    }

    public final CompleteUploadExternalParams withFiles(Iterable<? extends FileInfo> elements) {
        if (this.files == elements) {
            return this;
        }
        List<FileInfo> newValue = CompleteUploadExternalParams.createUnmodifiableList(false, CompleteUploadExternalParams.createSafeList(elements, true, false));
        return new CompleteUploadExternalParams(newValue, this.channelId, this.threadTs, this.initialComment);
    }

    public final CompleteUploadExternalParams withChannelId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.channelId, newValue)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, newValue, this.threadTs, this.initialComment);
    }

    public final CompleteUploadExternalParams withChannelId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.channelId, value)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, value, this.threadTs, this.initialComment);
    }

    public final CompleteUploadExternalParams withThreadTs(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.threadTs, newValue)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, this.channelId, newValue, this.initialComment);
    }

    public final CompleteUploadExternalParams withThreadTs(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.threadTs, value)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, this.channelId, value, this.initialComment);
    }

    public final CompleteUploadExternalParams withInitialComment(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.initialComment, newValue)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, this.channelId, this.threadTs, newValue);
    }

    public final CompleteUploadExternalParams withInitialComment(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.initialComment, value)) {
            return this;
        }
        return new CompleteUploadExternalParams(this.files, this.channelId, this.threadTs, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CompleteUploadExternalParams && this.equalTo(0, (CompleteUploadExternalParams)another);
    }

    private boolean equalTo(int synthetic, CompleteUploadExternalParams another) {
        return this.files.equals(another.files) && Objects.equals(this.channelId, another.channelId) && Objects.equals(this.threadTs, another.threadTs) && Objects.equals(this.initialComment, another.initialComment);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + Objects.hashCode(this.channelId);
        h += (h << 5) + Objects.hashCode(this.threadTs);
        h += (h << 5) + Objects.hashCode(this.initialComment);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CompleteUploadExternalParams{");
        builder.append("files=").append(this.files);
        if (this.channelId != null) {
            builder.append(", ");
            builder.append("channelId=").append(this.channelId);
        }
        if (this.threadTs != null) {
            builder.append(", ");
            builder.append("threadTs=").append(this.threadTs);
        }
        if (this.initialComment != null) {
            builder.append(", ");
            builder.append("initialComment=").append(this.initialComment);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CompleteUploadExternalParams fromJson(Json json) {
        Builder builder = CompleteUploadExternalParams.builder();
        if (json.files != null) {
            builder.addAllFiles(json.files);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.initialComment != null) {
            builder.setInitialComment(json.initialComment);
        }
        return builder.build();
    }

    public static CompleteUploadExternalParams copyOf(CompleteUploadExternalParamsIF instance) {
        if (instance instanceof CompleteUploadExternalParams) {
            return (CompleteUploadExternalParams)instance;
        }
        return CompleteUploadExternalParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CompleteUploadExternalParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private List<FileInfo> files = new ArrayList<FileInfo>();
        @Nullable
        private String channelId;
        @Nullable
        private String threadTs;
        @Nullable
        private String initialComment;

        private Builder() {
        }

        public final Builder from(CompleteUploadExternalParamsIF instance) {
            Optional<String> initialCommentOptional;
            Optional<String> threadTsOptional;
            Objects.requireNonNull(instance, "instance");
            this.addAllFiles(instance.getFiles());
            Optional<String> channelIdOptional = instance.getChannelId();
            if (channelIdOptional.isPresent()) {
                this.setChannelId(channelIdOptional);
            }
            if ((threadTsOptional = instance.getThreadTs()).isPresent()) {
                this.setThreadTs(threadTsOptional);
            }
            if ((initialCommentOptional = instance.getInitialComment()).isPresent()) {
                this.setInitialComment(initialCommentOptional);
            }
            return this;
        }

        public final Builder addFiles(FileInfo element) {
            this.files.add(Objects.requireNonNull(element, "files element"));
            return this;
        }

        public final Builder addFiles(FileInfo ... elements) {
            for (FileInfo element : elements) {
                this.files.add(Objects.requireNonNull(element, "files element"));
            }
            return this;
        }

        public final Builder setFiles(Iterable<? extends FileInfo> elements) {
            this.files.clear();
            return this.addAllFiles(elements);
        }

        public final Builder addAllFiles(Iterable<? extends FileInfo> elements) {
            for (FileInfo fileInfo : elements) {
                this.files.add(Objects.requireNonNull(fileInfo, "files element"));
            }
            return this;
        }

        public final Builder setChannelId(@Nullable String channelId) {
            this.channelId = channelId;
            return this;
        }

        public final Builder setChannelId(Optional<String> channelId) {
            this.channelId = channelId.orElse(null);
            return this;
        }

        public final Builder setThreadTs(@Nullable String threadTs) {
            this.threadTs = threadTs;
            return this;
        }

        public final Builder setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs.orElse(null);
            return this;
        }

        public final Builder setInitialComment(@Nullable String initialComment) {
            this.initialComment = initialComment;
            return this;
        }

        public final Builder setInitialComment(Optional<String> initialComment) {
            this.initialComment = initialComment.orElse(null);
            return this;
        }

        public CompleteUploadExternalParams build() {
            return new CompleteUploadExternalParams(CompleteUploadExternalParams.createUnmodifiableList(true, this.files), this.channelId, this.threadTs, this.initialComment);
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CompleteUploadExternalParamsIF", generator="Immutables")
    static final class Json
    implements CompleteUploadExternalParamsIF {
        @Nullable
        List<FileInfo> files = Collections.emptyList();
        @Nullable
        Optional<String> channelId = Optional.empty();
        @Nullable
        Optional<String> threadTs = Optional.empty();
        @Nullable
        Optional<String> initialComment = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setFiles(List<FileInfo> files) {
            this.files = files;
        }

        @JsonProperty
        public void setChannelId(Optional<String> channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setThreadTs(Optional<String> threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setInitialComment(Optional<String> initialComment) {
            this.initialComment = initialComment;
        }

        @Override
        public List<FileInfo> getFiles() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getInitialComment() {
            throw new UnsupportedOperationException();
        }
    }
}

