/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.conversations;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.TimeIntervalFilter;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.channels.PagingDirection;
import com.hubspot.slack.client.methods.params.conversations.AbstractConversationsHistoryParams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="AbstractConversationsHistoryParams", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ConversationsHistoryParams
extends AbstractConversationsHistoryParams {
    @Nullable
    private final Boolean inclusive;
    @Nullable
    private final String newestTimestamp;
    @Nullable
    private final String oldestTimestamp;
    private final transient PagingDirection pagingDirection;
    private final String channelId;
    @Nullable
    private final Integer limit;

    private ConversationsHistoryParams(@Nullable Boolean inclusive, @Nullable String newestTimestamp, @Nullable String oldestTimestamp, String channelId, @Nullable Integer limit) {
        this.inclusive = inclusive;
        this.newestTimestamp = newestTimestamp;
        this.oldestTimestamp = oldestTimestamp;
        this.channelId = channelId;
        this.limit = limit;
        this.pagingDirection = Objects.requireNonNull(super.getPagingDirection(), "pagingDirection");
    }

    @Override
    @JsonProperty(value="inclusive")
    public Optional<Boolean> isInclusive() {
        return Optional.ofNullable(this.inclusive);
    }

    @Override
    @JsonProperty(value="latest")
    public Optional<String> getNewestTimestamp() {
        return Optional.ofNullable(this.newestTimestamp);
    }

    @Override
    @JsonProperty(value="oldest")
    public Optional<String> getOldestTimestamp() {
        return Optional.ofNullable(this.oldestTimestamp);
    }

    @Override
    @JsonProperty
    @JsonIgnore
    public PagingDirection getPagingDirection() {
        return this.pagingDirection;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public Optional<Integer> getLimit() {
        return Optional.ofNullable(this.limit);
    }

    public final ConversationsHistoryParams withInclusive(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.inclusive, newValue)) {
            return this;
        }
        return new ConversationsHistoryParams(newValue, this.newestTimestamp, this.oldestTimestamp, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withInclusive(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.inclusive, value)) {
            return this;
        }
        return new ConversationsHistoryParams(value, this.newestTimestamp, this.oldestTimestamp, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withNewestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.newestTimestamp, newValue)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, newValue, this.oldestTimestamp, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withNewestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.newestTimestamp, value)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, value, this.oldestTimestamp, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withOldestTimestamp(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.oldestTimestamp, newValue)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, newValue, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withOldestTimestamp(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.oldestTimestamp, value)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, value, this.channelId, this.limit);
    }

    public final ConversationsHistoryParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, this.oldestTimestamp, newValue, this.limit);
    }

    public final ConversationsHistoryParams withLimit(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.channelId, newValue);
    }

    public final ConversationsHistoryParams withLimit(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.channelId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ConversationsHistoryParams && this.equalTo(0, (ConversationsHistoryParams)another);
    }

    private boolean equalTo(int synthetic, ConversationsHistoryParams another) {
        return Objects.equals(this.inclusive, another.inclusive) && Objects.equals(this.newestTimestamp, another.newestTimestamp) && Objects.equals(this.oldestTimestamp, another.oldestTimestamp) && this.pagingDirection.equals((Object)another.pagingDirection) && this.channelId.equals(another.channelId) && Objects.equals(this.limit, another.limit);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.inclusive);
        h += (h << 5) + Objects.hashCode(this.newestTimestamp);
        h += (h << 5) + Objects.hashCode(this.oldestTimestamp);
        h += (h << 5) + this.pagingDirection.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Objects.hashCode(this.limit);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ConversationsHistoryParams{");
        if (this.inclusive != null) {
            builder.append("inclusive=").append(this.inclusive);
        }
        if (this.newestTimestamp != null) {
            if (builder.length() > 27) {
                builder.append(", ");
            }
            builder.append("newestTimestamp=").append(this.newestTimestamp);
        }
        if (this.oldestTimestamp != null) {
            if (builder.length() > 27) {
                builder.append(", ");
            }
            builder.append("oldestTimestamp=").append(this.oldestTimestamp);
        }
        if (builder.length() > 27) {
            builder.append(", ");
        }
        builder.append("pagingDirection=").append((Object)this.pagingDirection);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        if (this.limit != null) {
            builder.append(", ");
            builder.append("limit=").append(this.limit);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ConversationsHistoryParams fromJson(Json json) {
        Builder builder = ConversationsHistoryParams.builder();
        if (json.inclusive != null) {
            builder.setInclusive(json.inclusive);
        }
        if (json.newestTimestamp != null) {
            builder.setNewestTimestamp(json.newestTimestamp);
        }
        if (json.oldestTimestamp != null) {
            builder.setOldestTimestamp(json.oldestTimestamp);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.limit != null) {
            builder.setLimit(json.limit);
        }
        return builder.build();
    }

    public static ConversationsHistoryParams copyOf(AbstractConversationsHistoryParams instance) {
        if (instance instanceof ConversationsHistoryParams) {
            return (ConversationsHistoryParams)instance;
        }
        return ConversationsHistoryParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AbstractConversationsHistoryParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private long initBits = 1L;
        @Nullable
        private Boolean inclusive;
        @Nullable
        private String newestTimestamp;
        @Nullable
        private String oldestTimestamp;
        @Nullable
        private String channelId;
        @Nullable
        private Integer limit;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(AbstractConversationsHistoryParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(TimeIntervalFilter instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            Optional<String> oldestTimestampOptional;
            Object instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof AbstractConversationsHistoryParams) {
                Optional<Integer> limitOptional;
                instance = (AbstractConversationsHistoryParams)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((limitOptional = ((AbstractConversationsHistoryParams)instance).getLimit()).isPresent()) {
                    this.setLimit(limitOptional);
                }
                if ((bits & 2L) == 0L) {
                    Optional<Boolean> inclusiveOptional = instance.isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(((AbstractConversationsHistoryParams)instance).getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof TimeIntervalFilter) {
                instance = (TimeIntervalFilter)object;
                if ((bits & 1L) == 0L) {
                    oldestTimestampOptional = instance.getOldestTimestamp();
                    if (oldestTimestampOptional.isPresent()) {
                        this.setOldestTimestamp(oldestTimestampOptional);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    Optional<Boolean> inclusiveOptional = instance.isInclusive();
                    if (inclusiveOptional.isPresent()) {
                        this.setInclusive(inclusiveOptional);
                    }
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> newestTimestampOptional = instance.getNewestTimestamp();
                    if (newestTimestampOptional.isPresent()) {
                        this.setNewestTimestamp(newestTimestampOptional);
                    }
                    bits |= 4L;
                }
            }
        }

        public final Builder setInclusive(@Nullable Boolean inclusive) {
            this.inclusive = inclusive;
            return this;
        }

        public final Builder setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive.orElse(null);
            return this;
        }

        public final Builder setNewestTimestamp(@Nullable String newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
            return this;
        }

        public final Builder setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp.orElse(null);
            return this;
        }

        public final Builder setOldestTimestamp(@Nullable String oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
            return this;
        }

        public final Builder setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp.orElse(null);
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setLimit(@Nullable Integer limit) {
            this.limit = limit;
            return this;
        }

        public final Builder setLimit(Optional<Integer> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        public ConversationsHistoryParams build() {
            this.checkRequiredAttributes();
            return new ConversationsHistoryParams(this.inclusive, this.newestTimestamp, this.oldestTimestamp, this.channelId, this.limit);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            return "Cannot build ConversationsHistoryParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AbstractConversationsHistoryParams", generator="Immutables")
    static final class Json
    extends AbstractConversationsHistoryParams {
        @Nullable
        Optional<Boolean> inclusive = Optional.empty();
        @Nullable
        Optional<String> newestTimestamp = Optional.empty();
        @Nullable
        Optional<String> oldestTimestamp = Optional.empty();
        @Nullable
        String channelId;
        @Nullable
        Optional<Integer> limit = Optional.empty();

        Json() {
        }

        @JsonProperty(value="inclusive")
        public void setInclusive(Optional<Boolean> inclusive) {
            this.inclusive = inclusive;
        }

        @JsonProperty(value="latest")
        public void setNewestTimestamp(Optional<String> newestTimestamp) {
            this.newestTimestamp = newestTimestamp;
        }

        @JsonProperty(value="oldest")
        public void setOldestTimestamp(Optional<String> oldestTimestamp) {
            this.oldestTimestamp = oldestTimestamp;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setLimit(Optional<Integer> limit) {
            this.limit = limit;
        }

        @Override
        public Optional<Boolean> isInclusive() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getNewestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getOldestTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public PagingDirection getPagingDirection() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getLimit() {
            throw new UnsupportedOperationException();
        }
    }
}

