/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.hubspot.immutables.style.HubSpotStyle;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import java.util.Optional;
import org.immutables.value.Value;

@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
@Value.Immutable
@HubSpotStyle
public interface ChatUpdateMessageParamsIF
extends MessageParams {
    @Override
    @JsonProperty(value="channel")
    public String getChannelId();

    @Override
    public Optional<String> getText();

    public String getTs();

    @JsonInclude(value=JsonInclude.Include.NON_ABSENT)
    @JsonProperty(value="as_user")
    public Optional<Boolean> getAsUser();

    @JsonProperty(value="link_names")
    @Value.Default
    default public boolean shouldLinkNames() {
        return true;
    }

    @Value.Default
    default public String getParse() {
        return "none";
    }

    @Value.Check
    default public void check() {
        Preconditions.checkState((this.getText().isPresent() && !Strings.isNullOrEmpty((String)this.getText().get()) || !this.getAttachments().isEmpty() || !this.getBlocks().isEmpty() ? 1 : 0) != 0, (Object)"Must include text if not providing attachments or blocks");
    }
}

