/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatScheduleMessageParamsIF;
import com.hubspot.slack.client.methods.params.chat.MessageParams;
import com.hubspot.slack.client.models.Attachment;
import com.hubspot.slack.client.models.blocks.Block;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatScheduleMessageParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatScheduleMessageParams
implements ChatScheduleMessageParamsIF {
    @Nullable
    private final String text;
    private final List<Attachment> attachments;
    private final List<Block> blocks;
    private final String channelId;
    private final long postAt;
    private final boolean shouldLinkNames;
    private final String parseMode;
    private final String threadTs;
    @Nullable
    private final Boolean unfurlLinks;
    @Nullable
    private final Boolean unfurlMedia;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ChatScheduleMessageParams(Builder builder) {
        this.text = builder.text;
        this.attachments = ChatScheduleMessageParams.createUnmodifiableList(true, builder.attachments);
        this.channelId = builder.channelId;
        this.postAt = builder.postAt;
        this.unfurlLinks = builder.unfurlLinks;
        this.unfurlMedia = builder.unfurlMedia;
        if (builder.blocksIsSet()) {
            this.initShim.setBlocks(ChatScheduleMessageParams.createUnmodifiableList(true, builder.blocks));
        }
        if (builder.shouldLinkNamesIsSet()) {
            this.initShim.setShouldLinkNames(builder.shouldLinkNames);
        }
        if (builder.parseMode != null) {
            this.initShim.setParseMode(builder.parseMode);
        }
        if (builder.threadTs != null) {
            this.initShim.setThreadTs(builder.threadTs);
        }
        this.blocks = this.initShim.getBlocks();
        this.shouldLinkNames = this.initShim.getShouldLinkNames();
        this.parseMode = this.initShim.getParseMode();
        this.threadTs = this.initShim.getThreadTs();
        this.initShim = null;
    }

    private ChatScheduleMessageParams(@Nullable String text, List<Attachment> attachments, List<Block> blocks, String channelId, long postAt, boolean shouldLinkNames, String parseMode, String threadTs, @Nullable Boolean unfurlLinks, @Nullable Boolean unfurlMedia) {
        this.text = text;
        this.attachments = attachments;
        this.blocks = blocks;
        this.channelId = channelId;
        this.postAt = postAt;
        this.shouldLinkNames = shouldLinkNames;
        this.parseMode = parseMode;
        this.threadTs = threadTs;
        this.unfurlLinks = unfurlLinks;
        this.unfurlMedia = unfurlMedia;
        this.initShim = null;
    }

    private List<Block> getBlocksInitialize() {
        return ChatScheduleMessageParamsIF.super.getBlocks();
    }

    private boolean getShouldLinkNamesInitialize() {
        return ChatScheduleMessageParamsIF.super.getShouldLinkNames();
    }

    private String getParseModeInitialize() {
        return ChatScheduleMessageParamsIF.super.getParseMode();
    }

    private String getThreadTsInitialize() {
        return ChatScheduleMessageParamsIF.super.getThreadTs();
    }

    @Override
    @JsonProperty
    public Optional<String> getText() {
        return Optional.ofNullable(this.text);
    }

    @Override
    @JsonProperty
    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    @Override
    @JsonProperty
    public List<Block> getBlocks() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getBlocks() : this.blocks;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public long getPostAt() {
        return this.postAt;
    }

    @Override
    @JsonProperty(value="link_names")
    public boolean getShouldLinkNames() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getShouldLinkNames() : this.shouldLinkNames;
    }

    @Override
    @JsonProperty(value="parse")
    public String getParseMode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getParseMode() : this.parseMode;
    }

    @Override
    @JsonProperty
    public String getThreadTs() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getThreadTs() : this.threadTs;
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlLinks() {
        return Optional.ofNullable(this.unfurlLinks);
    }

    @Override
    @JsonProperty
    public Optional<Boolean> getUnfurlMedia() {
        return Optional.ofNullable(this.unfurlMedia);
    }

    public final ChatScheduleMessageParams withText(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.text, newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(newValue, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withText(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.text, value)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(value, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withAttachments(Attachment ... elements) {
        List<Attachment> newValue = ChatScheduleMessageParams.createUnmodifiableList(false, ChatScheduleMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, newValue, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withAttachments(Iterable<? extends Attachment> elements) {
        if (this.attachments == elements) {
            return this;
        }
        List<Attachment> newValue = ChatScheduleMessageParams.createUnmodifiableList(false, ChatScheduleMessageParams.createSafeList(elements, true, false));
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, newValue, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withBlocks(Block ... elements) {
        List<Block> newValue = ChatScheduleMessageParams.createUnmodifiableList(false, ChatScheduleMessageParams.createSafeList(Arrays.asList(elements), true, false));
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, newValue, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withBlocks(Iterable<? extends Block> elements) {
        if (this.blocks == elements) {
            return this;
        }
        List<Block> newValue = ChatScheduleMessageParams.createUnmodifiableList(false, ChatScheduleMessageParams.createSafeList(elements, true, false));
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, newValue, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, newValue, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withPostAt(long value) {
        if (this.postAt == value) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, value, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withShouldLinkNames(boolean value) {
        if (this.shouldLinkNames == value) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, value, this.parseMode, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withParseMode(String value) {
        String newValue = Objects.requireNonNull(value, "parseMode");
        if (this.parseMode.equals(newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, newValue, this.threadTs, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withThreadTs(String value) {
        String newValue = Objects.requireNonNull(value, "threadTs");
        if (this.threadTs.equals(newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, newValue, this.unfurlLinks, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withUnfurlLinks(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlLinks, newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, newValue, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withUnfurlLinks(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlLinks, value)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, value, this.unfurlMedia));
    }

    public final ChatScheduleMessageParams withUnfurlMedia(@Nullable Boolean value) {
        Boolean newValue = value;
        if (Objects.equals(this.unfurlMedia, newValue)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, newValue));
    }

    public final ChatScheduleMessageParams withUnfurlMedia(Optional<Boolean> optional) {
        Boolean value = optional.orElse(null);
        if (Objects.equals(this.unfurlMedia, value)) {
            return this;
        }
        return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this.text, this.attachments, this.blocks, this.channelId, this.postAt, this.shouldLinkNames, this.parseMode, this.threadTs, this.unfurlLinks, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatScheduleMessageParams && this.equalTo(0, (ChatScheduleMessageParams)another);
    }

    private boolean equalTo(int synthetic, ChatScheduleMessageParams another) {
        return Objects.equals(this.text, another.text) && this.attachments.equals(another.attachments) && this.blocks.equals(another.blocks) && this.channelId.equals(another.channelId) && this.postAt == another.postAt && this.shouldLinkNames == another.shouldLinkNames && this.parseMode.equals(another.parseMode) && this.threadTs.equals(another.threadTs) && Objects.equals(this.unfurlLinks, another.unfurlLinks) && Objects.equals(this.unfurlMedia, another.unfurlMedia);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.text);
        h += (h << 5) + this.attachments.hashCode();
        h += (h << 5) + this.blocks.hashCode();
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + Long.hashCode(this.postAt);
        h += (h << 5) + Boolean.hashCode(this.shouldLinkNames);
        h += (h << 5) + this.parseMode.hashCode();
        h += (h << 5) + this.threadTs.hashCode();
        h += (h << 5) + Objects.hashCode(this.unfurlLinks);
        h += (h << 5) + Objects.hashCode(this.unfurlMedia);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("ChatScheduleMessageParams{");
        if (this.text != null) {
            builder.append("text=").append(this.text);
        }
        if (builder.length() > 26) {
            builder.append(", ");
        }
        builder.append("attachments=").append(this.attachments);
        builder.append(", ");
        builder.append("blocks=").append(this.blocks);
        builder.append(", ");
        builder.append("channelId=").append(this.channelId);
        builder.append(", ");
        builder.append("postAt=").append(this.postAt);
        builder.append(", ");
        builder.append("shouldLinkNames=").append(this.shouldLinkNames);
        builder.append(", ");
        builder.append("parseMode=").append(this.parseMode);
        builder.append(", ");
        builder.append("threadTs=").append(this.threadTs);
        if (this.unfurlLinks != null) {
            builder.append(", ");
            builder.append("unfurlLinks=").append(this.unfurlLinks);
        }
        if (this.unfurlMedia != null) {
            builder.append(", ");
            builder.append("unfurlMedia=").append(this.unfurlMedia);
        }
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatScheduleMessageParams fromJson(Json json) {
        Builder builder = ChatScheduleMessageParams.builder();
        if (json.text != null) {
            builder.setText(json.text);
        }
        if (json.attachments != null) {
            builder.addAllAttachments(json.attachments);
        }
        if (json.blocksIsSet) {
            builder.addAllBlocks(json.blocks);
        }
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.postAtIsSet) {
            builder.setPostAt(json.postAt);
        }
        if (json.shouldLinkNamesIsSet) {
            builder.setShouldLinkNames(json.shouldLinkNames);
        }
        if (json.parseMode != null) {
            builder.setParseMode(json.parseMode);
        }
        if (json.threadTs != null) {
            builder.setThreadTs(json.threadTs);
        }
        if (json.unfurlLinks != null) {
            builder.setUnfurlLinks(json.unfurlLinks);
        }
        if (json.unfurlMedia != null) {
            builder.setUnfurlMedia(json.unfurlMedia);
        }
        return builder.build();
    }

    private static ChatScheduleMessageParams validate(ChatScheduleMessageParams instance) {
        instance.check();
        return instance;
    }

    public static ChatScheduleMessageParams copyOf(ChatScheduleMessageParamsIF instance) {
        if (instance instanceof ChatScheduleMessageParams) {
            return (ChatScheduleMessageParams)instance;
        }
        return ChatScheduleMessageParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ChatScheduleMessageParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_POST_AT = 2L;
        private static final long OPT_BIT_BLOCKS = 1L;
        private static final long OPT_BIT_SHOULD_LINK_NAMES = 2L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private String text;
        private List<Attachment> attachments = new ArrayList<Attachment>();
        private List<Block> blocks = new ArrayList<Block>();
        @Nullable
        private String channelId;
        private long postAt;
        private boolean shouldLinkNames;
        @Nullable
        private String parseMode;
        @Nullable
        private String threadTs;
        @Nullable
        private Boolean unfurlLinks;
        @Nullable
        private Boolean unfurlMedia;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(MessageParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatScheduleMessageParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof MessageParams) {
                instance = (MessageParams)object;
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 2L;
                }
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
            if (object instanceof ChatScheduleMessageParamsIF) {
                instance = (ChatScheduleMessageParamsIF)object;
                Optional<Boolean> unfurlMediaOptional = instance.getUnfurlMedia();
                if (unfurlMediaOptional.isPresent()) {
                    this.setUnfurlMedia(unfurlMediaOptional);
                }
                if ((bits & 1L) == 0L) {
                    this.addAllAttachments(instance.getAttachments());
                    bits |= 1L;
                }
                this.setPostAt(instance.getPostAt());
                Optional<Boolean> unfurlLinksOptional = instance.getUnfurlLinks();
                if (unfurlLinksOptional.isPresent()) {
                    this.setUnfurlLinks(unfurlLinksOptional);
                }
                this.setShouldLinkNames(instance.getShouldLinkNames());
                if ((bits & 2L) == 0L) {
                    this.addAllBlocks(instance.getBlocks());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    Optional<String> textOptional = instance.getText();
                    if (textOptional.isPresent()) {
                        this.setText(textOptional);
                    }
                    bits |= 4L;
                }
                this.setParseMode(instance.getParseMode());
                this.setThreadTs(instance.getThreadTs());
                if ((bits & 8L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 8L;
                }
            }
        }

        public final Builder setText(@Nullable String text) {
            this.text = text;
            return this;
        }

        public final Builder setText(Optional<String> text) {
            this.text = text.orElse(null);
            return this;
        }

        public final Builder addAttachments(Attachment element) {
            this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            return this;
        }

        public final Builder addAttachments(Attachment ... elements) {
            for (Attachment element : elements) {
                this.attachments.add(Objects.requireNonNull(element, "attachments element"));
            }
            return this;
        }

        public final Builder setAttachments(Iterable<? extends Attachment> elements) {
            this.attachments.clear();
            return this.addAllAttachments(elements);
        }

        public final Builder addAllAttachments(Iterable<? extends Attachment> elements) {
            for (Attachment attachment : elements) {
                this.attachments.add(Objects.requireNonNull(attachment, "attachments element"));
            }
            return this;
        }

        public final Builder addBlocks(Block element) {
            this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addBlocks(Block ... elements) {
            for (Block element : elements) {
                this.blocks.add(Objects.requireNonNull(element, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setBlocks(Iterable<? extends Block> elements) {
            this.blocks.clear();
            return this.addAllBlocks(elements);
        }

        public final Builder addAllBlocks(Iterable<? extends Block> elements) {
            for (Block block : elements) {
                this.blocks.add(Objects.requireNonNull(block, "blocks element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setPostAt(long postAt) {
            this.postAt = postAt;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.optBits |= 2L;
            return this;
        }

        public final Builder setParseMode(String parseMode) {
            this.parseMode = Objects.requireNonNull(parseMode, "parseMode");
            return this;
        }

        public final Builder setThreadTs(String threadTs) {
            this.threadTs = Objects.requireNonNull(threadTs, "threadTs");
            return this;
        }

        public final Builder setUnfurlLinks(@Nullable Boolean unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
            return this;
        }

        public final Builder setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks.orElse(null);
            return this;
        }

        public final Builder setUnfurlMedia(@Nullable Boolean unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
            return this;
        }

        public final Builder setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia.orElse(null);
            return this;
        }

        public ChatScheduleMessageParams build() {
            this.checkRequiredAttributes();
            return ChatScheduleMessageParams.validate(new ChatScheduleMessageParams(this));
        }

        private boolean blocksIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean shouldLinkNamesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean postAtIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.postAtIsSet()) {
                attributes.add("postAt");
            }
            return "Cannot build ChatScheduleMessageParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatScheduleMessageParamsIF", generator="Immutables")
    static final class Json
    implements ChatScheduleMessageParamsIF {
        @Nullable
        Optional<String> text = Optional.empty();
        @Nullable
        List<Attachment> attachments = Collections.emptyList();
        @Nullable
        List<Block> blocks = Collections.emptyList();
        boolean blocksIsSet;
        @Nullable
        String channelId;
        long postAt;
        boolean postAtIsSet;
        boolean shouldLinkNames;
        boolean shouldLinkNamesIsSet;
        @Nullable
        String parseMode;
        @Nullable
        String threadTs;
        @Nullable
        Optional<Boolean> unfurlLinks = Optional.empty();
        @Nullable
        Optional<Boolean> unfurlMedia = Optional.empty();

        Json() {
        }

        @JsonProperty
        public void setText(Optional<String> text) {
            this.text = text;
        }

        @JsonProperty
        public void setAttachments(List<Attachment> attachments) {
            this.attachments = attachments;
        }

        @JsonProperty
        public void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksIsSet = null != blocks;
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setPostAt(long postAt) {
            this.postAt = postAt;
            this.postAtIsSet = true;
        }

        @JsonProperty(value="link_names")
        public void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesIsSet = true;
        }

        @JsonProperty(value="parse")
        public void setParseMode(String parseMode) {
            this.parseMode = parseMode;
        }

        @JsonProperty
        public void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
        }

        @JsonProperty
        public void setUnfurlLinks(Optional<Boolean> unfurlLinks) {
            this.unfurlLinks = unfurlLinks;
        }

        @JsonProperty
        public void setUnfurlMedia(Optional<Boolean> unfurlMedia) {
            this.unfurlMedia = unfurlMedia;
        }

        @Override
        public Optional<String> getText() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Attachment> getAttachments() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<Block> getBlocks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long getPostAt() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean getShouldLinkNames() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getParseMode() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getThreadTs() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlLinks() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Boolean> getUnfurlMedia() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="ChatScheduleMessageParamsIF", generator="Immutables")
    private final class InitShim {
        private byte blocksBuildStage = 0;
        private List<Block> blocks;
        private byte shouldLinkNamesBuildStage = 0;
        private boolean shouldLinkNames;
        private byte parseModeBuildStage = 0;
        private String parseMode;
        private byte threadTsBuildStage = 0;
        private String threadTs;

        private InitShim() {
        }

        List<Block> getBlocks() {
            if (this.blocksBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.blocksBuildStage == 0) {
                this.blocksBuildStage = (byte)-1;
                this.blocks = ChatScheduleMessageParams.createUnmodifiableList(false, ChatScheduleMessageParams.createSafeList(ChatScheduleMessageParams.this.getBlocksInitialize(), true, false));
                this.blocksBuildStage = 1;
            }
            return this.blocks;
        }

        void setBlocks(List<Block> blocks) {
            this.blocks = blocks;
            this.blocksBuildStage = 1;
        }

        boolean getShouldLinkNames() {
            if (this.shouldLinkNamesBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.shouldLinkNamesBuildStage == 0) {
                this.shouldLinkNamesBuildStage = (byte)-1;
                this.shouldLinkNames = ChatScheduleMessageParams.this.getShouldLinkNamesInitialize();
                this.shouldLinkNamesBuildStage = 1;
            }
            return this.shouldLinkNames;
        }

        void setShouldLinkNames(boolean shouldLinkNames) {
            this.shouldLinkNames = shouldLinkNames;
            this.shouldLinkNamesBuildStage = 1;
        }

        String getParseMode() {
            if (this.parseModeBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.parseModeBuildStage == 0) {
                this.parseModeBuildStage = (byte)-1;
                this.parseMode = Objects.requireNonNull(ChatScheduleMessageParams.this.getParseModeInitialize(), "parseMode");
                this.parseModeBuildStage = 1;
            }
            return this.parseMode;
        }

        void setParseMode(String parseMode) {
            this.parseMode = parseMode;
            this.parseModeBuildStage = 1;
        }

        String getThreadTs() {
            if (this.threadTsBuildStage == -1) {
                throw new InvalidImmutableStateException(this.formatInitCycleMessage());
            }
            if (this.threadTsBuildStage == 0) {
                this.threadTsBuildStage = (byte)-1;
                this.threadTs = Objects.requireNonNull(ChatScheduleMessageParams.this.getThreadTsInitialize(), "threadTs");
                this.threadTsBuildStage = 1;
            }
            return this.threadTs;
        }

        void setThreadTs(String threadTs) {
            this.threadTs = threadTs;
            this.threadTsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.blocksBuildStage == -1) {
                attributes.add("blocks");
            }
            if (this.shouldLinkNamesBuildStage == -1) {
                attributes.add("shouldLinkNames");
            }
            if (this.parseModeBuildStage == -1) {
                attributes.add("parseMode");
            }
            if (this.threadTsBuildStage == -1) {
                attributes.add("threadTs");
            }
            return "Cannot build ChatScheduleMessageParams, attribute initializers form cycle " + attributes;
        }
    }
}

