/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.chat;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.interceptor.HasChannel;
import com.hubspot.slack.client.methods.params.chat.ChatDeleteScheduledMessageParamsIF;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="ChatDeleteScheduledMessageParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class ChatDeleteScheduledMessageParams
implements ChatDeleteScheduledMessageParamsIF {
    private final String channelId;
    private final String scheduledMessageId;

    private ChatDeleteScheduledMessageParams(String channelId, String scheduledMessageId) {
        this.channelId = channelId;
        this.scheduledMessageId = scheduledMessageId;
    }

    @Override
    @JsonProperty(value="channel")
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    @JsonProperty
    public String getScheduledMessageId() {
        return this.scheduledMessageId;
    }

    public final ChatDeleteScheduledMessageParams withChannelId(String value) {
        String newValue = Objects.requireNonNull(value, "channelId");
        if (this.channelId.equals(newValue)) {
            return this;
        }
        return new ChatDeleteScheduledMessageParams(newValue, this.scheduledMessageId);
    }

    public final ChatDeleteScheduledMessageParams withScheduledMessageId(String value) {
        String newValue = Objects.requireNonNull(value, "scheduledMessageId");
        if (this.scheduledMessageId.equals(newValue)) {
            return this;
        }
        return new ChatDeleteScheduledMessageParams(this.channelId, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatDeleteScheduledMessageParams && this.equalTo(0, (ChatDeleteScheduledMessageParams)another);
    }

    private boolean equalTo(int synthetic, ChatDeleteScheduledMessageParams another) {
        return this.channelId.equals(another.channelId) && this.scheduledMessageId.equals(another.scheduledMessageId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.channelId.hashCode();
        h += (h << 5) + this.scheduledMessageId.hashCode();
        return h;
    }

    public String toString() {
        return "ChatDeleteScheduledMessageParams{channelId=" + this.channelId + ", scheduledMessageId=" + this.scheduledMessageId + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ChatDeleteScheduledMessageParams fromJson(Json json) {
        Builder builder = ChatDeleteScheduledMessageParams.builder();
        if (json.channelId != null) {
            builder.setChannelId(json.channelId);
        }
        if (json.scheduledMessageId != null) {
            builder.setScheduledMessageId(json.scheduledMessageId);
        }
        return builder.build();
    }

    public static ChatDeleteScheduledMessageParams copyOf(ChatDeleteScheduledMessageParamsIF instance) {
        if (instance instanceof ChatDeleteScheduledMessageParams) {
            return (ChatDeleteScheduledMessageParams)instance;
        }
        return ChatDeleteScheduledMessageParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ChatDeleteScheduledMessageParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CHANNEL_ID = 1L;
        private static final long INIT_BIT_SCHEDULED_MESSAGE_ID = 2L;
        private long initBits = 3L;
        @Nullable
        private String channelId;
        @Nullable
        private String scheduledMessageId;

        private Builder() {
        }

        public final Builder from(HasChannel instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        public final Builder from(ChatDeleteScheduledMessageParamsIF instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            HasChannel instance;
            long bits = 0L;
            if (object instanceof HasChannel) {
                instance = (HasChannel)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
            }
            if (object instanceof ChatDeleteScheduledMessageParamsIF) {
                instance = (ChatDeleteScheduledMessageParamsIF)object;
                if ((bits & 1L) == 0L) {
                    this.setChannelId(instance.getChannelId());
                    bits |= 1L;
                }
                this.setScheduledMessageId(instance.getScheduledMessageId());
            }
        }

        public final Builder setChannelId(String channelId) {
            this.channelId = Objects.requireNonNull(channelId, "channelId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setScheduledMessageId(String scheduledMessageId) {
            this.scheduledMessageId = Objects.requireNonNull(scheduledMessageId, "scheduledMessageId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ChatDeleteScheduledMessageParams build() {
            this.checkRequiredAttributes();
            return new ChatDeleteScheduledMessageParams(this.channelId, this.scheduledMessageId);
        }

        private boolean channelIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean scheduledMessageIdIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.channelIdIsSet()) {
                attributes.add("channelId");
            }
            if (!this.scheduledMessageIdIsSet()) {
                attributes.add("scheduledMessageId");
            }
            return "Cannot build ChatDeleteScheduledMessageParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="ChatDeleteScheduledMessageParamsIF", generator="Immutables")
    static final class Json
    implements ChatDeleteScheduledMessageParamsIF {
        @Nullable
        String channelId;
        @Nullable
        String scheduledMessageId;

        Json() {
        }

        @JsonProperty(value="channel")
        public void setChannelId(String channelId) {
            this.channelId = channelId;
        }

        @JsonProperty
        public void setScheduledMessageId(String scheduledMessageId) {
            this.scheduledMessageId = scheduledMessageId;
        }

        @Override
        public String getChannelId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getScheduledMessageId() {
            throw new UnsupportedOperationException();
        }
    }
}

