/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.methods.params.calls;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.hubspot.immutables.validation.InvalidImmutableStateException;
import com.hubspot.slack.client.methods.params.calls.CallsAddParamsIF;
import com.hubspot.slack.client.models.calls.SlackInternalOrExternalUser;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

@ParametersAreNonnullByDefault
@Generated(from="CallsAddParamsIF", generator="Immutables")
@SuppressFBWarnings
@Immutable
public final class CallsAddParams
implements CallsAddParamsIF {
    private final String externalUniqueId;
    private final String joinUrl;
    @Nullable
    private final String createdBy;
    @Nullable
    private final Integer dateStart;
    @Nullable
    private final String desktopAppJoinUrl;
    @Nullable
    private final String externalDisplayId;
    @Nullable
    private final String title;
    private final List<SlackInternalOrExternalUser> users;

    private CallsAddParams(String externalUniqueId, String joinUrl, @Nullable String createdBy, @Nullable Integer dateStart, @Nullable String desktopAppJoinUrl, @Nullable String externalDisplayId, @Nullable String title, List<SlackInternalOrExternalUser> users) {
        this.externalUniqueId = externalUniqueId;
        this.joinUrl = joinUrl;
        this.createdBy = createdBy;
        this.dateStart = dateStart;
        this.desktopAppJoinUrl = desktopAppJoinUrl;
        this.externalDisplayId = externalDisplayId;
        this.title = title;
        this.users = users;
    }

    @Override
    @JsonProperty
    public String getExternalUniqueId() {
        return this.externalUniqueId;
    }

    @Override
    @JsonProperty
    public String getJoinUrl() {
        return this.joinUrl;
    }

    @Override
    @JsonProperty
    public Optional<String> getCreatedBy() {
        return Optional.ofNullable(this.createdBy);
    }

    @Override
    @JsonProperty
    public Optional<Integer> getDateStart() {
        return Optional.ofNullable(this.dateStart);
    }

    @Override
    @JsonProperty
    public Optional<String> getDesktopAppJoinUrl() {
        return Optional.ofNullable(this.desktopAppJoinUrl);
    }

    @Override
    @JsonProperty
    public Optional<String> getExternalDisplayId() {
        return Optional.ofNullable(this.externalDisplayId);
    }

    @Override
    @JsonProperty
    public Optional<String> getTitle() {
        return Optional.ofNullable(this.title);
    }

    @Override
    @JsonProperty
    public List<SlackInternalOrExternalUser> getUsers() {
        return this.users;
    }

    public final CallsAddParams withExternalUniqueId(String value) {
        String newValue = Objects.requireNonNull(value, "externalUniqueId");
        if (this.externalUniqueId.equals(newValue)) {
            return this;
        }
        return new CallsAddParams(newValue, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withJoinUrl(String value) {
        String newValue = Objects.requireNonNull(value, "joinUrl");
        if (this.joinUrl.equals(newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, newValue, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withCreatedBy(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.createdBy, newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, newValue, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withCreatedBy(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.createdBy, value)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, value, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withDateStart(@Nullable Integer value) {
        Integer newValue = value;
        if (Objects.equals(this.dateStart, newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, newValue, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withDateStart(Optional<Integer> optional) {
        Integer value = optional.orElse(null);
        if (Objects.equals(this.dateStart, value)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, value, this.desktopAppJoinUrl, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withDesktopAppJoinUrl(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.desktopAppJoinUrl, newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, newValue, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withDesktopAppJoinUrl(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.desktopAppJoinUrl, value)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, value, this.externalDisplayId, this.title, this.users);
    }

    public final CallsAddParams withExternalDisplayId(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.externalDisplayId, newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, newValue, this.title, this.users);
    }

    public final CallsAddParams withExternalDisplayId(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.externalDisplayId, value)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, value, this.title, this.users);
    }

    public final CallsAddParams withTitle(@Nullable String value) {
        String newValue = value;
        if (Objects.equals(this.title, newValue)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, newValue, this.users);
    }

    public final CallsAddParams withTitle(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.title, value)) {
            return this;
        }
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, value, this.users);
    }

    public final CallsAddParams withUsers(SlackInternalOrExternalUser ... elements) {
        List<SlackInternalOrExternalUser> newValue = CallsAddParams.createUnmodifiableList(false, CallsAddParams.createSafeList(Arrays.asList(elements), true, false));
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, newValue);
    }

    public final CallsAddParams withUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
        if (this.users == elements) {
            return this;
        }
        List<SlackInternalOrExternalUser> newValue = CallsAddParams.createUnmodifiableList(false, CallsAddParams.createSafeList(elements, true, false));
        return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CallsAddParams && this.equalTo(0, (CallsAddParams)another);
    }

    private boolean equalTo(int synthetic, CallsAddParams another) {
        return this.externalUniqueId.equals(another.externalUniqueId) && this.joinUrl.equals(another.joinUrl) && Objects.equals(this.createdBy, another.createdBy) && Objects.equals(this.dateStart, another.dateStart) && Objects.equals(this.desktopAppJoinUrl, another.desktopAppJoinUrl) && Objects.equals(this.externalDisplayId, another.externalDisplayId) && Objects.equals(this.title, another.title) && this.users.equals(another.users);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.externalUniqueId.hashCode();
        h += (h << 5) + this.joinUrl.hashCode();
        h += (h << 5) + Objects.hashCode(this.createdBy);
        h += (h << 5) + Objects.hashCode(this.dateStart);
        h += (h << 5) + Objects.hashCode(this.desktopAppJoinUrl);
        h += (h << 5) + Objects.hashCode(this.externalDisplayId);
        h += (h << 5) + Objects.hashCode(this.title);
        h += (h << 5) + this.users.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("CallsAddParams{");
        builder.append("externalUniqueId=").append(this.externalUniqueId);
        builder.append(", ");
        builder.append("joinUrl=").append(this.joinUrl);
        if (this.createdBy != null) {
            builder.append(", ");
            builder.append("createdBy=").append(this.createdBy);
        }
        if (this.dateStart != null) {
            builder.append(", ");
            builder.append("dateStart=").append(this.dateStart);
        }
        if (this.desktopAppJoinUrl != null) {
            builder.append(", ");
            builder.append("desktopAppJoinUrl=").append(this.desktopAppJoinUrl);
        }
        if (this.externalDisplayId != null) {
            builder.append(", ");
            builder.append("externalDisplayId=").append(this.externalDisplayId);
        }
        if (this.title != null) {
            builder.append(", ");
            builder.append("title=").append(this.title);
        }
        builder.append(", ");
        builder.append("users=").append(this.users);
        return builder.append("}").toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static CallsAddParams fromJson(Json json) {
        Builder builder = CallsAddParams.builder();
        if (json.externalUniqueId != null) {
            builder.setExternalUniqueId(json.externalUniqueId);
        }
        if (json.joinUrl != null) {
            builder.setJoinUrl(json.joinUrl);
        }
        if (json.createdBy != null) {
            builder.setCreatedBy(json.createdBy);
        }
        if (json.dateStart != null) {
            builder.setDateStart(json.dateStart);
        }
        if (json.desktopAppJoinUrl != null) {
            builder.setDesktopAppJoinUrl(json.desktopAppJoinUrl);
        }
        if (json.externalDisplayId != null) {
            builder.setExternalDisplayId(json.externalDisplayId);
        }
        if (json.title != null) {
            builder.setTitle(json.title);
        }
        if (json.users != null) {
            builder.addAllUsers(json.users);
        }
        return builder.build();
    }

    public static CallsAddParams copyOf(CallsAddParamsIF instance) {
        if (instance instanceof CallsAddParams) {
            return (CallsAddParams)instance;
        }
        return CallsAddParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList(size);
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="CallsAddParamsIF", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_EXTERNAL_UNIQUE_ID = 1L;
        private static final long INIT_BIT_JOIN_URL = 2L;
        private long initBits = 3L;
        @Nullable
        private String externalUniqueId;
        @Nullable
        private String joinUrl;
        @Nullable
        private String createdBy;
        @Nullable
        private Integer dateStart;
        @Nullable
        private String desktopAppJoinUrl;
        @Nullable
        private String externalDisplayId;
        @Nullable
        private String title;
        private List<SlackInternalOrExternalUser> users = new ArrayList<SlackInternalOrExternalUser>();

        private Builder() {
        }

        public final Builder from(CallsAddParamsIF instance) {
            Optional<String> titleOptional;
            Optional<String> externalDisplayIdOptional;
            Optional<String> desktopAppJoinUrlOptional;
            Optional<Integer> dateStartOptional;
            Objects.requireNonNull(instance, "instance");
            this.setExternalUniqueId(instance.getExternalUniqueId());
            this.setJoinUrl(instance.getJoinUrl());
            Optional<String> createdByOptional = instance.getCreatedBy();
            if (createdByOptional.isPresent()) {
                this.setCreatedBy(createdByOptional);
            }
            if ((dateStartOptional = instance.getDateStart()).isPresent()) {
                this.setDateStart(dateStartOptional);
            }
            if ((desktopAppJoinUrlOptional = instance.getDesktopAppJoinUrl()).isPresent()) {
                this.setDesktopAppJoinUrl(desktopAppJoinUrlOptional);
            }
            if ((externalDisplayIdOptional = instance.getExternalDisplayId()).isPresent()) {
                this.setExternalDisplayId(externalDisplayIdOptional);
            }
            if ((titleOptional = instance.getTitle()).isPresent()) {
                this.setTitle(titleOptional);
            }
            this.addAllUsers(instance.getUsers());
            return this;
        }

        public final Builder setExternalUniqueId(String externalUniqueId) {
            this.externalUniqueId = Objects.requireNonNull(externalUniqueId, "externalUniqueId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder setJoinUrl(String joinUrl) {
            this.joinUrl = Objects.requireNonNull(joinUrl, "joinUrl");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder setCreatedBy(@Nullable String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Builder setCreatedBy(Optional<String> createdBy) {
            this.createdBy = createdBy.orElse(null);
            return this;
        }

        public final Builder setDateStart(@Nullable Integer dateStart) {
            this.dateStart = dateStart;
            return this;
        }

        public final Builder setDateStart(Optional<Integer> dateStart) {
            this.dateStart = dateStart.orElse(null);
            return this;
        }

        public final Builder setDesktopAppJoinUrl(@Nullable String desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
            return this;
        }

        public final Builder setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl.orElse(null);
            return this;
        }

        public final Builder setExternalDisplayId(@Nullable String externalDisplayId) {
            this.externalDisplayId = externalDisplayId;
            return this;
        }

        public final Builder setExternalDisplayId(Optional<String> externalDisplayId) {
            this.externalDisplayId = externalDisplayId.orElse(null);
            return this;
        }

        public final Builder setTitle(@Nullable String title) {
            this.title = title;
            return this;
        }

        public final Builder setTitle(Optional<String> title) {
            this.title = title.orElse(null);
            return this;
        }

        public final Builder addUsers(SlackInternalOrExternalUser element) {
            this.users.add(Objects.requireNonNull(element, "users element"));
            return this;
        }

        public final Builder addUsers(SlackInternalOrExternalUser ... elements) {
            for (SlackInternalOrExternalUser element : elements) {
                this.users.add(Objects.requireNonNull(element, "users element"));
            }
            return this;
        }

        public final Builder setUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
            this.users.clear();
            return this.addAllUsers(elements);
        }

        public final Builder addAllUsers(Iterable<? extends SlackInternalOrExternalUser> elements) {
            for (SlackInternalOrExternalUser slackInternalOrExternalUser : elements) {
                this.users.add(Objects.requireNonNull(slackInternalOrExternalUser, "users element"));
            }
            return this;
        }

        public CallsAddParams build() {
            this.checkRequiredAttributes();
            return new CallsAddParams(this.externalUniqueId, this.joinUrl, this.createdBy, this.dateStart, this.desktopAppJoinUrl, this.externalDisplayId, this.title, CallsAddParams.createUnmodifiableList(true, this.users));
        }

        private boolean externalUniqueIdIsSet() {
            return (this.initBits & 1L) == 0L;
        }

        private boolean joinUrlIsSet() {
            return (this.initBits & 2L) == 0L;
        }

        private void checkRequiredAttributes() {
            if (this.initBits != 0L) {
                throw new InvalidImmutableStateException(this.formatRequiredAttributesMessage());
            }
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (!this.externalUniqueIdIsSet()) {
                attributes.add("externalUniqueId");
            }
            if (!this.joinUrlIsSet()) {
                attributes.add("joinUrl");
            }
            return "Cannot build CallsAddParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="CallsAddParamsIF", generator="Immutables")
    static final class Json
    implements CallsAddParamsIF {
        @Nullable
        String externalUniqueId;
        @Nullable
        String joinUrl;
        @Nullable
        Optional<String> createdBy = Optional.empty();
        @Nullable
        Optional<Integer> dateStart = Optional.empty();
        @Nullable
        Optional<String> desktopAppJoinUrl = Optional.empty();
        @Nullable
        Optional<String> externalDisplayId = Optional.empty();
        @Nullable
        Optional<String> title = Optional.empty();
        @Nullable
        List<SlackInternalOrExternalUser> users = Collections.emptyList();

        Json() {
        }

        @JsonProperty
        public void setExternalUniqueId(String externalUniqueId) {
            this.externalUniqueId = externalUniqueId;
        }

        @JsonProperty
        public void setJoinUrl(String joinUrl) {
            this.joinUrl = joinUrl;
        }

        @JsonProperty
        public void setCreatedBy(Optional<String> createdBy) {
            this.createdBy = createdBy;
        }

        @JsonProperty
        public void setDateStart(Optional<Integer> dateStart) {
            this.dateStart = dateStart;
        }

        @JsonProperty
        public void setDesktopAppJoinUrl(Optional<String> desktopAppJoinUrl) {
            this.desktopAppJoinUrl = desktopAppJoinUrl;
        }

        @JsonProperty
        public void setExternalDisplayId(Optional<String> externalDisplayId) {
            this.externalDisplayId = externalDisplayId;
        }

        @JsonProperty
        public void setTitle(Optional<String> title) {
            this.title = title;
        }

        @JsonProperty
        public void setUsers(List<SlackInternalOrExternalUser> users) {
            this.users = users;
        }

        @Override
        public String getExternalUniqueId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getJoinUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getCreatedBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Integer> getDateStart() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getDesktopAppJoinUrl() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getExternalDisplayId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> getTitle() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<SlackInternalOrExternalUser> getUsers() {
            throw new UnsupportedOperationException();
        }
    }
}

