/*
 * Decompiled with CFR 0.152.
 */
package com.hubspot.slack.client.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public final class ObjectMapperUtils {
    private static final AtomicReference<Optional<ObjectMapper>> MAPPER_REF = new AtomicReference(Optional.empty());

    private ObjectMapperUtils() {
    }

    private static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new GuavaModule());
        mapper.registerModule((Module)new JodaModule());
        mapper.registerModule((Module)new Jdk8Module());
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.configure(JsonParser.Feature.ALLOW_COMMENTS, false);
        mapper.configure(JsonParser.Feature.AUTO_CLOSE_SOURCE, true);
        mapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, true);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectMapper mapper() {
        if (MAPPER_REF.get().isPresent()) return MAPPER_REF.get().get();
        Class<ObjectMapperUtils> clazz = ObjectMapperUtils.class;
        synchronized (ObjectMapperUtils.class) {
            if (MAPPER_REF.get().isPresent()) return MAPPER_REF.get().get();
            MAPPER_REF.set(Optional.of(ObjectMapperUtils.create()));
            // ** MonitorExit[var0] (shouldn't be in output)
            return MAPPER_REF.get().get();
        }
    }
}

