/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.invoker;

import com.huaweicloud.sdk.core.HcClient;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.exception.ConnectionException;
import com.huaweicloud.sdk.core.exception.SdkException;
import com.huaweicloud.sdk.core.exchange.SdkExchange;
import com.huaweicloud.sdk.core.http.HttpRequestDef;
import com.huaweicloud.sdk.core.retry.RetryRecord;
import com.huaweicloud.sdk.core.retry.backoff.BackoffStrategy;
import com.huaweicloud.sdk.core.retry.backoff.SdkBackoffStrategy;
import com.huaweicloud.sdk.core.utils.ValidationUtils;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class BaseInvoker<ReqT, ResT, DerivedT extends BaseInvoker<ReqT, ResT, DerivedT>> {
    SdkExchange exchange = new SdkExchange().withApiReference(apiReference -> apiReference.withName(meta.getName()).withMethod(meta.getMethod().toString()).withUri(meta.getUri()));
    HcClient hcClient;
    HttpRequestDef<ReqT, ResT> meta;
    ReqT req;
    Map<String, String> extraHeader;
    int retryTimes;
    BiFunction<ResT, SdkException, Boolean> func;
    BackoffStrategy backoffStrategy;
    public static final int MAX_RETRY_TIME = 30;

    public BaseInvoker(ReqT req, HttpRequestDef<ReqT, ResT> meta, HcClient hcClient) {
        this.hcClient = hcClient;
        this.meta = meta;
        this.req = req;
    }

    public <T extends ICredential> DerivedT replaceCredentialWhen(Class<T> clazz, Consumer<T> func) {
        ICredential credential = this.hcClient.getCredential().deepClone();
        if (clazz.isAssignableFrom(credential.getClass())) {
            func.accept(credential);
            this.hcClient = this.hcClient.overrideCredential(credential);
        }
        return (DerivedT)this;
    }

    public DerivedT addHeader(String headerKey, String headerValue) {
        if (Objects.isNull(this.extraHeader)) {
            this.extraHeader = new TreeMap<String, String>();
        }
        this.extraHeader.put(headerKey, headerValue);
        return (DerivedT)this;
    }

    public DerivedT withExchange(Consumer<SdkExchange> func) {
        if (Objects.nonNull(func)) {
            func.accept(this.exchange);
        }
        return (DerivedT)this;
    }

    public DerivedT withRetry(int retryTimes, BiFunction<ResT, SdkException, Boolean> func) {
        return this.withRetry(retryTimes, func, this.backoffStrategy);
    }

    public DerivedT withRetry(int retryTimes, BiFunction<ResT, SdkException, Boolean> func, BackoffStrategy backoffStrategy) {
        this.retryTimes = ValidationUtils.assertIntIsInRange(retryTimes, 0, 30, "retryTimes");
        this.func = func;
        this.initBackoffStrategy(backoffStrategy);
        return (DerivedT)this;
    }

    public DerivedT retryTimes(int retryTimes) {
        this.retryTimes = ValidationUtils.assertIntIsInRange(retryTimes, 0, 30, "retryTimes");
        return (DerivedT)this;
    }

    public DerivedT retryCondition(BiFunction<ResT, SdkException, Boolean> func) {
        this.func = func;
        return (DerivedT)this;
    }

    public DerivedT backoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = backoffStrategy;
        return (DerivedT)this;
    }

    public static <ResT> BiFunction<ResT, SdkException, Boolean> defaultRetryCondition() {
        return (resp, exception) -> {
            if (Objects.nonNull(exception)) {
                return ConnectionException.class.isAssignableFrom(exception.getClass());
            }
            return false;
        };
    }

    public void initBackoffStrategy(BackoffStrategy backoffStrategy) {
        this.backoffStrategy = Objects.isNull(backoffStrategy) ? (Objects.nonNull(this.func) ? SdkBackoffStrategy.getDefaultBackoffStrategy() : BackoffStrategy.NO_BACKOFF) : backoffStrategy;
    }

    CompletableFuture<ResT> retry(Supplier<CompletableFuture<ResT>> work) {
        CompletableFuture future = new CompletableFuture();
        this.initBackoffStrategy(this.backoffStrategy);
        RetryRecord<Object> record = new RetryRecord<Object>(this.retryTimes, this.func, this.backoffStrategy);
        record.setFuture(future);
        record.setWorkSupplier(work);
        record.schedule();
        return future;
    }
}

