/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.impl;

import com.huaweicloud.sdk.core.http.HttpResponse;
import com.huaweicloud.sdk.core.impl.DefaultHttpUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpResponse
implements HttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHttpResponse.class);
    private Response response;
    private String strBody;

    private DefaultHttpResponse(Response response) {
        this.response = response;
        if (Objects.nonNull(response.body()) && Objects.nonNull(response.body().contentType()) && (response.body().contentType().toString().startsWith("application/json") || response.body().contentType().toString().startsWith("text"))) {
            try {
                this.strBody = response.body().string();
            }
            catch (IOException e) {
                logger.error("Read http response body error!", (Throwable)e);
            }
        }
    }

    static DefaultHttpResponse wrap(Response response) {
        return new DefaultHttpResponse(response);
    }

    @Override
    public int getStatusCode() {
        return this.response.code();
    }

    @Override
    public String getContentType() {
        return Objects.isNull(this.response.body()) || Objects.isNull(this.response.body().contentType()) ? null : this.response.body().contentType().toString();
    }

    @Override
    public long getContentLength() {
        return Objects.isNull(this.response.body()) || this.response.body().contentLength() < 0L ? 0L : this.response.body().contentLength();
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return DefaultHttpUtils.headersToMap(this.response.headers());
    }

    @Override
    public String getBodyAsString() {
        return this.strBody;
    }

    @Override
    public InputStream getBody() {
        return this.response.body().byteStream();
    }

    @Override
    public String getHeader(String name) {
        return this.response.header(name);
    }
}

