/*
 * Decompiled with CFR 0.152.
 */
package com.huaweicloud.sdk.core.auth;

import com.huaweicloud.sdk.core.auth.EnvCredentialProvider;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.auth.ICredentialProvider;
import com.huaweicloud.sdk.core.auth.MetadataCredentialProvider;
import com.huaweicloud.sdk.core.auth.ProfileCredentialProvider;
import com.huaweicloud.sdk.core.exception.SdkException;
import java.util.ArrayList;
import java.util.Objects;

public class CredentialProviderChain
implements ICredentialProvider {
    private final ICredentialProvider[] providers;

    public CredentialProviderChain(ICredentialProvider[] providers) {
        this.providers = providers;
    }

    public static CredentialProviderChain getDefaultCredentialProviderChain(String credentialType) {
        ICredentialProvider[] providers = new ICredentialProvider[]{new EnvCredentialProvider(credentialType), new ProfileCredentialProvider(credentialType), new MetadataCredentialProvider(credentialType)};
        return new CredentialProviderChain(providers);
    }

    public static CredentialProviderChain getBasicCredentialProviderChain() {
        return CredentialProviderChain.getDefaultCredentialProviderChain("basic");
    }

    public static CredentialProviderChain getGlobalCredentialProviderChain() {
        return CredentialProviderChain.getDefaultCredentialProviderChain("global");
    }

    @Override
    public ICredential getCredentials() {
        ArrayList<String> exceptions = new ArrayList<String>();
        for (ICredentialProvider provider : this.providers) {
            try {
                ICredential credentials = provider.getCredentials();
                if (!Objects.nonNull(credentials)) continue;
                return credentials;
            }
            catch (SdkException e) {
                exceptions.add(e.getMessage());
            }
        }
        throw new SdkException("failed to get credentials in providers\n" + String.join((CharSequence)"\n", exceptions));
    }
}

