/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.ObsProperties;
import com.obs.services.internal.io.MayRepeatableInputStream;
import com.obs.shade.okhttp3.MediaType;
import com.obs.shade.okhttp3.RequestBody;
import com.obs.shade.okio.BufferedSink;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;

public class RepeatableRequestEntity
extends RequestBody
implements Closeable {
    private static final ILogger INTERFACE_LOG = LoggerBuilder.getLogger("com.obs.services.internal.RestStorageService");
    private String contentType;
    private long contentLength = -1L;
    private volatile long bytesWritten = 0L;
    private InputStream inputStream;
    private static final int WRITE_BUFFER_SIZE = 4096;

    public RepeatableRequestEntity(InputStream is, String contentType, long contentLength, ObsProperties obsProperties) {
        if (is == null) {
            throw new IllegalArgumentException("InputStream cannot be null");
        }
        this.inputStream = is;
        this.contentLength = contentLength;
        this.contentType = contentType;
        if (!(this.inputStream instanceof MayRepeatableInputStream)) {
            this.inputStream = new MayRepeatableInputStream(is, obsProperties.getIntProperty("httpclient.write-buffer-size", 8192));
        }
        this.inputStream.mark(0);
    }

    @Override
    public long contentLength() throws IOException {
        return this.contentLength;
    }

    public boolean isRepeatable() {
        return this.inputStream == null || this.inputStream.markSupported();
    }

    protected void writeToBIO(BufferedSink out) throws IOException {
        byte[] tmp = new byte[4096];
        int count = 0;
        if (this.contentLength < 0L) {
            count = this.inputStream.read(tmp);
            while (count != -1) {
                this.bytesWritten += (long)count;
                out.write(tmp, 0, count);
                count = this.inputStream.read(tmp);
            }
        } else {
            for (long remaining = this.contentLength; remaining > 0L && (count = this.inputStream.read(tmp, 0, (int)Math.min(4096L, remaining))) != -1; remaining -= (long)count) {
                out.write(tmp, 0, count);
                this.bytesWritten += (long)count;
            }
        }
    }

    @Override
    public MediaType contentType() {
        return MediaType.parse(this.contentType == null ? "application/octet-stream" : this.contentType);
    }

    @Override
    public void writeTo(BufferedSink sink) throws IOException {
        long start = System.currentTimeMillis();
        if (this.bytesWritten > 0L) {
            this.inputStream.reset();
            this.bytesWritten = 0L;
        }
        this.writeToBIO(sink);
        if (INTERFACE_LOG.isInfoEnabled()) {
            INTERFACE_LOG.info("write data end, cost " + (System.currentTimeMillis() - start) + " ms");
        }
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }
}

