/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl.pwg;

import com.hp.jipp.pdl.ColorSpace;
import com.hp.jipp.pdl.RenderableDocument;
import com.hp.jipp.pdl.RenderablePage;
import com.hp.jipp.pdl.pwg.PwgHeader;
import com.hp.jipp.pdl.pwg.PwgWriter;
import com.hp.jipp.pdl.util.NullOutputStream;
import com.hp.jipp.pdl.util.TeeInputStream;
import com.hp.jipp.pdl.util.WrappedByteArrayOutputStream;
import com.hp.jipp.util.BytesKt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\t"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgReader;", "Ljava/io/DataInputStream;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "readDocument", "Lcom/hp/jipp/pdl/pwg/PwgReader$PwgDocument;", "PwgDocument", "PwgPage", "jipp-pdl"})
public final class PwgReader
extends DataInputStream {
    public PwgReader(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(inputStream);
    }

    @NotNull
    public final PwgDocument readDocument() {
        return new PwgDocument(this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000eH\u0096\u0002J\u0018\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgReader$PwgDocument;", "Lcom/hp/jipp/pdl/RenderableDocument;", "input", "Ljava/io/DataInputStream;", "(Ljava/io/DataInputStream;)V", "_dpi", "", "dpi", "getDpi", "()I", "pages", "", "Lcom/hp/jipp/pdl/pwg/PwgReader$PwgPage;", "iterator", "", "readPwgPage", "header", "Lcom/hp/jipp/pdl/pwg/PwgHeader;", "Ljava/io/InputStream;", "readValidHeader", "headerBytes", "", "jipp-pdl"})
    public static final class PwgDocument
    extends RenderableDocument {
        private int _dpi;
        @NotNull
        private final List<PwgPage> pages;

        public PwgDocument(@NotNull DataInputStream input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            this._dpi = -1;
            this.pages = new ArrayList();
            byte[] magicNumbers = new byte[PwgWriter.Companion.getMAGIC_NUMBER().length];
            input.read(magicNumbers);
            if (!Arrays.equals(magicNumbers, PwgWriter.Companion.getMAGIC_NUMBER())) {
                throw new IOException("Expected " + BytesKt.toHexString((byte[])PwgWriter.Companion.getMAGIC_NUMBER()) + " but read " + BytesKt.toHexString((byte[])magicNumbers));
            }
            byte[] headerBytes = new byte[1796];
            while (input.read(headerBytes) != -1) {
                PwgHeader header = this.readValidHeader(headerBytes);
                ((Collection)this.pages).add(this.readPwgPage(header, input));
            }
        }

        @Override
        public int getDpi() {
            return this._dpi;
        }

        @Override
        @NotNull
        public Iterator<PwgPage> iterator() {
            return this.pages.iterator();
        }

        private final PwgHeader readValidHeader(byte[] headerBytes) {
            PwgHeader header = PwgHeader.Companion.read(new ByteArrayInputStream(headerBytes));
            if (header.getHwResolutionX() != header.getHwResolutionY()) {
                throw new IOException("Non-square resolutions not supported");
            }
            if (this.getDpi() != -1 && this.getDpi() != header.getHwResolutionX()) {
                throw new IOException("All pages must have the same resolution (found " + this.getDpi() + " and " + header.getHwResolutionX());
            }
            this._dpi = header.getHwResolutionX();
            return header;
        }

        private final PwgPage readPwgPage(PwgHeader header, InputStream input) {
            ByteArrayOutputStream pageBytes = new ByteArrayOutputStream();
            header.getPackBits().decode(new TeeInputStream(input, pageBytes), NullOutputStream.INSTANCE, header.getHeight());
            byte[] byArray = pageBytes.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
            return new PwgPage(header, byArray);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0005H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/hp/jipp/pdl/pwg/PwgReader$PwgPage;", "Lcom/hp/jipp/pdl/RenderablePage;", "header", "Lcom/hp/jipp/pdl/pwg/PwgHeader;", "pageBytes", "", "(Lcom/hp/jipp/pdl/pwg/PwgHeader;[B)V", "getHeader", "()Lcom/hp/jipp/pdl/pwg/PwgHeader;", "render", "", "yOffset", "", "swathHeight", "colorSpace", "Lcom/hp/jipp/pdl/ColorSpace;", "byteArray", "jipp-pdl"})
    public static final class PwgPage
    extends RenderablePage {
        @NotNull
        private final PwgHeader header;
        @NotNull
        private final byte[] pageBytes;

        public PwgPage(@NotNull PwgHeader header, @NotNull byte[] pageBytes) {
            Intrinsics.checkNotNullParameter((Object)header, (String)"header");
            Intrinsics.checkNotNullParameter((Object)pageBytes, (String)"pageBytes");
            super(header.getWidth(), header.getHeight());
            this.header = header;
            this.pageBytes = pageBytes;
        }

        @NotNull
        public final PwgHeader getHeader() {
            return this.header;
        }

        @Override
        public void render(int yOffset, int swathHeight, @NotNull ColorSpace colorSpace, @NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)((Object)colorSpace), (String)"colorSpace");
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            ByteArrayInputStream input = new ByteArrayInputStream(this.pageBytes);
            this.header.getPackBits().decode(input, NullOutputStream.INSTANCE, yOffset);
            if (PwgHeader.ColorSpace.Companion.from(colorSpace) == this.header.getColorSpace()) {
                this.header.getPackBits().decode(input, new WrappedByteArrayOutputStream(byteArray, 0, 2, null), swathHeight);
            } else {
                ByteArrayOutputStream pixelOutput = new ByteArrayOutputStream();
                this.header.getPackBits().decode(input, pixelOutput, swathHeight);
                this.header.getColorSpace().toPdlColorSpace().convert(new ByteArrayInputStream(pixelOutput.toByteArray()), new WrappedByteArrayOutputStream(byteArray, 0, 2, null), colorSpace);
            }
        }
    }
}

