/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.pdl;

import com.hp.jipp.pdl.ColorSpace;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0006\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 !2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001!B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u0000J&\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0014\u001a\u00020\u0000J(\u0010\u0016\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0014\u001a\u00020\u0000H\u0002J(\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0014\u001a\u00020\u0000H\u0002J(\u0010\u0018\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u0010\u0014\u001a\u00020\u0000H\u0002J\u0014\u0010\u0019\u001a\u00020\u0003*\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J\u0014\u0010\u001c\u001a\u00020\u001a*\u00020\t2\u0006\u0010\u001d\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R&\u0010\u0007\u001a\u001a\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\f\u001a\u00020\u0003*\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fj\u0002\b\u001ej\u0002\b\u001fj\u0002\b \u00a8\u0006\""}, d2={"Lcom/hp/jipp/pdl/ColorSpace;", "", "bytesPerPixel", "", "(Ljava/lang/String;II)V", "getBytesPerPixel", "()I", "passThrough", "Lkotlin/Function3;", "", "Ljava/io/OutputStream;", "", "uByteInt", "", "getUByteInt", "(B)I", "convert", "input", "Ljava/io/InputStream;", "output", "outputColor", "converter", "grayscaleConverter", "rgbConverter", "rgbaConverter", "applyAlpha", "", "alpha", "rgbLuminosityAt", "index", "Rgba", "Rgb", "Grayscale", "Companion", "jipp-pdl"})
public final class ColorSpace
extends Enum<ColorSpace> {
    @NotNull
    public static final Companion Companion;
    private final int bytesPerPixel;
    @NotNull
    private final Function3<byte[], Integer, OutputStream, Unit> passThrough;
    private static final int MAX_BYTE = 255;
    private static final double LUM_R = 0.2126;
    private static final double LUM_G = 0.7152;
    private static final double LUM_B = 0.0722;
    public static final /* enum */ ColorSpace Rgba;
    public static final /* enum */ ColorSpace Rgb;
    public static final /* enum */ ColorSpace Grayscale;
    private static final /* synthetic */ ColorSpace[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private ColorSpace(int bytesPerPixel) {
        this.bytesPerPixel = bytesPerPixel;
        this.passThrough = (Function3)new Function3<byte[], Integer, OutputStream, Unit>(this){
            final /* synthetic */ ColorSpace this$0;
            {
                this.this$0 = $receiver;
                super(3);
            }

            public final void invoke(@NotNull byte[] input, int inputOffset, @NotNull OutputStream output) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                output.write(input, inputOffset, this.this$0.getBytesPerPixel());
            }
        };
    }

    public final int getBytesPerPixel() {
        return this.bytesPerPixel;
    }

    @NotNull
    public final Function3<byte[], Integer, OutputStream, Unit> converter(@NotNull ColorSpace outputColor) {
        Function3<byte[], Integer, OutputStream, Unit> function3;
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
            case 1: {
                function3 = this.grayscaleConverter(outputColor);
                break;
            }
            case 2: {
                function3 = this.rgbConverter(outputColor);
                break;
            }
            case 3: {
                function3 = this.rgbaConverter(outputColor);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function3;
    }

    private final Function3<byte[], Integer, OutputStream, Unit> grayscaleConverter(ColorSpace outputColor) {
        Function3 function3;
        switch (WhenMappings.$EnumSwitchMapping$0[outputColor.ordinal()]) {
            case 1: {
                function3 = this.passThrough;
                break;
            }
            case 2: {
                function3 = grayscaleConverter.1.INSTANCE;
                break;
            }
            case 3: {
                function3 = grayscaleConverter.2.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function3;
    }

    private final Function3<byte[], Integer, OutputStream, Unit> rgbConverter(ColorSpace outputColor) {
        Function3 function3;
        switch (WhenMappings.$EnumSwitchMapping$0[outputColor.ordinal()]) {
            case 1: {
                function3 = (Function3)new Function3<byte[], Integer, OutputStream, Unit>(this){
                    final /* synthetic */ ColorSpace this$0;
                    {
                        this.this$0 = $receiver;
                        super(3);
                    }

                    public final void invoke(@NotNull byte[] input, int inputOffset, @NotNull OutputStream output) {
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                        output.write(MathKt.roundToInt((double)ColorSpace.access$rgbLuminosityAt(this.this$0, input, inputOffset)));
                    }
                };
                break;
            }
            case 2: {
                function3 = this.passThrough;
                break;
            }
            case 3: {
                function3 = rgbConverter.2.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function3;
    }

    private final Function3<byte[], Integer, OutputStream, Unit> rgbaConverter(ColorSpace outputColor) {
        Function3 function3;
        switch (WhenMappings.$EnumSwitchMapping$0[outputColor.ordinal()]) {
            case 1: {
                function3 = (Function3)new Function3<byte[], Integer, OutputStream, Unit>(this){
                    final /* synthetic */ ColorSpace this$0;
                    {
                        this.this$0 = $receiver;
                        super(3);
                    }

                    public final void invoke(@NotNull byte[] input, int inputOffset, @NotNull OutputStream output) {
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                        output.write(ColorSpace.access$applyAlpha(this.this$0, ColorSpace.access$rgbLuminosityAt(this.this$0, input, inputOffset), ColorSpace.access$getUByteInt(this.this$0, input[inputOffset + 3])));
                    }
                };
                break;
            }
            case 2: {
                function3 = (Function3)new Function3<byte[], Integer, OutputStream, Unit>(this){
                    final /* synthetic */ ColorSpace this$0;
                    {
                        this.this$0 = $receiver;
                        super(3);
                    }

                    public final void invoke(@NotNull byte[] input, int inputOffset, @NotNull OutputStream output) {
                        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                        int alpha = ColorSpace.access$getUByteInt(this.this$0, input[inputOffset + 3]);
                        switch (alpha) {
                            case 0: {
                                output.write(255);
                                output.write(255);
                                output.write(255);
                                break;
                            }
                            case 255: {
                                output.write(input, inputOffset, 3);
                                break;
                            }
                            default: {
                                output.write(ColorSpace.access$applyAlpha(this.this$0, ColorSpace.access$getUByteInt(this.this$0, input[inputOffset]), alpha));
                                output.write(ColorSpace.access$applyAlpha(this.this$0, ColorSpace.access$getUByteInt(this.this$0, input[inputOffset + 1]), alpha));
                                output.write(ColorSpace.access$applyAlpha(this.this$0, ColorSpace.access$getUByteInt(this.this$0, input[inputOffset + 2]), alpha));
                            }
                        }
                    }
                };
                break;
            }
            case 3: {
                function3 = this.passThrough;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return function3;
    }

    private final int applyAlpha(double $this$applyAlpha, int alpha) {
        return MathKt.roundToInt((double)($this$applyAlpha * (double)alpha / (double)255 - (double)alpha + (double)255));
    }

    private final int getUByteInt(byte $this$uByteInt) {
        return $this$uByteInt & 0xFF;
    }

    private final double rgbLuminosityAt(byte[] $this$rgbLuminosityAt, int index) {
        return 0.2126 * (double)this.getUByteInt($this$rgbLuminosityAt[index]) + 0.7152 * (double)this.getUByteInt($this$rgbLuminosityAt[index + 1]) + 0.0722 * (double)this.getUByteInt($this$rgbLuminosityAt[index + 2]);
    }

    public final void convert(@NotNull InputStream input, @NotNull OutputStream output, @NotNull ColorSpace outputColor) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter((Object)((Object)outputColor), (String)"outputColor");
        byte[] inputPixel = new byte[this.bytesPerPixel];
        Function3<byte[], Integer, OutputStream, Unit> converter = this.converter(outputColor);
        while (input.read(inputPixel) != -1) {
            converter.invoke((Object)inputPixel, (Object)0, (Object)output);
        }
    }

    public static ColorSpace[] values() {
        return (ColorSpace[])$VALUES.clone();
    }

    public static ColorSpace valueOf(String value) {
        return Enum.valueOf(ColorSpace.class, value);
    }

    @NotNull
    public static EnumEntries<ColorSpace> getEntries() {
        return $ENTRIES;
    }

    public static final /* synthetic */ double access$rgbLuminosityAt(ColorSpace $this, byte[] $receiver, int index) {
        return $this.rgbLuminosityAt($receiver, index);
    }

    public static final /* synthetic */ int access$applyAlpha(ColorSpace $this, double $receiver, int alpha) {
        return $this.applyAlpha($receiver, alpha);
    }

    public static final /* synthetic */ int access$getUByteInt(ColorSpace $this, byte $receiver) {
        return $this.getUByteInt($receiver);
    }

    static {
        Rgba = new ColorSpace(4);
        Rgb = new ColorSpace(3);
        Grayscale = new ColorSpace(1);
        $VALUES = colorSpaceArray = new ColorSpace[]{ColorSpace.Rgba, ColorSpace.Rgb, ColorSpace.Grayscale};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/hp/jipp/pdl/ColorSpace$Companion;", "", "()V", "LUM_B", "", "LUM_G", "LUM_R", "MAX_BYTE", "", "jipp-pdl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ColorSpace.values().length];
            try {
                nArray[ColorSpace.Grayscale.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.Rgb.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ColorSpace.Rgba.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

