/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.util;

import com.hp.jipp.util.PrettyPrintable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001f\u0010\r\u001a\u00020\u00002\u0012\u0010\u000e\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f\"\u00020\u0001\u00a2\u0006\u0002\u0010\u0010J\u0014\u0010\u0011\u001a\u00020\u00002\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0006\u0010\u0015\u001a\u00020\u0000J\u0010\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0001H\u0002J\b\u0010\u0018\u001a\u00020\u0014H\u0002J\u001a\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u0007J\u0006\u0010\u001a\u001a\u00020\u0003R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/hp/jipp/util/PrettyPrinter;", "", "prefix", "", "style", "Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;", "indent", "maxWidth", "", "(Ljava/lang/String;Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;Ljava/lang/String;I)V", "mGroups", "Ljava/util/Stack;", "Lcom/hp/jipp/util/PrettyPrinter$Companion$Group;", "add", "items", "", "([Ljava/lang/Object;)Lcom/hp/jipp/util/PrettyPrinter;", "addAll", "", "checkUnprinted", "", "close", "innerAdd", "item", "innerClose", "open", "print", "Companion", "jipp-core"})
public final class PrettyPrinter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String indent;
    private final int maxWidth;
    @NotNull
    private final Stack<Companion.Group> mGroups;
    @NotNull
    private static final String NEWLINE = "\n";
    private static final int GROUP_SIZE_MIN_CLOSED = 2;
    private static final int GROUP_SIZE_MIN_OPEN = 3;
    private static final int SHORT_DIVISOR = 3;
    @JvmField
    @NotNull
    public static final Companion.Style ARRAY = new Companion.Style("[", "]", ",", " ");
    @JvmField
    @NotNull
    public static final Companion.Style OBJECT = new Companion.Style("{", "}", ",", " ");
    @JvmField
    @NotNull
    public static final Companion.Style KEY_VALUE = new Companion.Style(" ", "", "/", "");
    @JvmField
    @NotNull
    public static final Companion.Style SILENT = new Companion.Style("", "", ",", "");

    public PrettyPrinter(@NotNull String prefix, @NotNull Companion.Style style, @NotNull String indent, int maxWidth) {
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
        this.indent = indent;
        this.maxWidth = maxWidth;
        this.mGroups = new Stack();
        this.mGroups.push(new Companion.Group(SILENT, "", this.maxWidth));
        this.mGroups.push(new Companion.Group(style, prefix, this.maxWidth));
    }

    @JvmOverloads
    @NotNull
    public final PrettyPrinter open(@NotNull Companion.Style style, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        this.mGroups.push(new Companion.Group(style, prefix, this.maxWidth));
        return this;
    }

    public static /* synthetic */ PrettyPrinter open$default(PrettyPrinter prettyPrinter, Companion.Style style, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        return prettyPrinter.open(style, string);
    }

    @NotNull
    public final PrettyPrinter close() {
        this.checkUnprinted();
        if (this.mGroups.size() < 3) {
            throw new IllegalArgumentException("nothing open to close");
        }
        this.innerClose();
        return this;
    }

    private final void innerClose() {
        Companion.Group closed = this.mGroups.pop();
        int startPos = this.mGroups.size() * (this.indent.length() - 1);
        if (startPos + closed.width$jipp_core() < this.maxWidth) {
            this.innerAdd(closed.compressed$jipp_core());
        } else {
            char[] cArray = new char[this.mGroups.size()];
            boolean bl = false;
            this.innerAdd(closed.expanded$jipp_core(startPos, StringsKt.replace$default((String)new String(cArray), (String)"\u0000", (String)this.indent, (boolean)false, (int)4, null)));
        }
    }

    private final void checkUnprinted() {
        if (this.mGroups.size() < 2) {
            throw new IllegalArgumentException("print already called");
        }
    }

    @NotNull
    public final PrettyPrinter addAll(@NotNull Iterable<? extends Object> items) {
        Intrinsics.checkNotNullParameter(items, (String)"items");
        this.checkUnprinted();
        for (Object object : items) {
            this.innerAdd(object);
        }
        return this;
    }

    @NotNull
    public final PrettyPrinter add(Object ... items) {
        Intrinsics.checkNotNullParameter((Object)items, (String)"items");
        this.checkUnprinted();
        for (Object item : items) {
            this.innerAdd(item);
        }
        return this;
    }

    private final void innerAdd(Object item) {
        Companion.Group group2 = this.mGroups.peek();
        if (item instanceof PrettyPrintable) {
            ((PrettyPrintable)item).print(this);
        } else {
            group2.getItems().add(item);
        }
    }

    @NotNull
    public final String print() {
        while (this.mGroups.size() > 1) {
            this.innerClose();
        }
        return this.mGroups.peek().getItems().get(0).toString();
    }

    @JvmOverloads
    @NotNull
    public final PrettyPrinter open(@NotNull Companion.Style style) {
        Intrinsics.checkNotNullParameter((Object)style, (String)"style");
        return PrettyPrinter.open$default(this, style, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/hp/jipp/util/PrettyPrinter$Companion;", "", "()V", "ARRAY", "Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;", "GROUP_SIZE_MIN_CLOSED", "", "GROUP_SIZE_MIN_OPEN", "KEY_VALUE", "NEWLINE", "", "OBJECT", "SHORT_DIVISOR", "SILENT", "Group", "Style", "jipp-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u00002\u00020\u0001B'\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;", "", "opener", "", "closer", "separator", "spacer", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getCloser", "()Ljava/lang/String;", "getOpener", "getSeparator", "getSpacer", "jipp-core"})
        public static final class Style {
            @NotNull
            private final String opener;
            @NotNull
            private final String closer;
            @NotNull
            private final String separator;
            @NotNull
            private final String spacer;

            public Style(@NotNull String opener, @NotNull String closer, @NotNull String separator, @NotNull String spacer) {
                Intrinsics.checkNotNullParameter((Object)opener, (String)"opener");
                Intrinsics.checkNotNullParameter((Object)closer, (String)"closer");
                Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
                Intrinsics.checkNotNullParameter((Object)spacer, (String)"spacer");
                this.opener = opener;
                this.closer = closer;
                this.separator = separator;
                this.spacer = spacer;
            }

            @NotNull
            public final String getOpener() {
                return this.opener;
            }

            @NotNull
            public final String getCloser() {
                return this.closer;
            }

            @NotNull
            public final String getSeparator() {
                return this.separator;
            }

            @NotNull
            public final String getSpacer() {
                return this.spacer;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\r\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u000eJ\u001d\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b\u0012J\r\u0010\u0013\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u0014J$\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u00060\u0018j\u0002`\u00192\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0005H\u0002R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/hp/jipp/util/PrettyPrinter$Companion$Group;", "", "style", "Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;", "prefix", "", "maxWidth", "", "(Lcom/hp/jipp/util/PrettyPrinter$Companion$Style;Ljava/lang/String;I)V", "items", "Ljava/util/ArrayList;", "getItems", "()Ljava/util/ArrayList;", "compressed", "compressed$jipp_core", "expanded", "startPos", "indent", "expanded$jipp_core", "width", "width$jipp_core", "wrap", "", "out", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "jipp-core"})
        public static final class Group {
            @NotNull
            private final Style style;
            @NotNull
            private final String prefix;
            private final int maxWidth;
            @NotNull
            private final ArrayList<Object> items;

            public Group(@NotNull Style style, @NotNull String prefix, int maxWidth) {
                Intrinsics.checkNotNullParameter((Object)style, (String)"style");
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                this.style = style;
                this.prefix = prefix;
                this.maxWidth = maxWidth;
                this.items = new ArrayList();
            }

            @NotNull
            public final ArrayList<Object> getItems() {
                return this.items;
            }

            /*
             * WARNING - void declaration
             */
            public final int width$jipp_core() {
                int n;
                int result = 0;
                Object object = this.prefix;
                boolean bl = false;
                if (object.length() > 0) {
                    result += this.prefix.length() + this.style.getSpacer().length();
                }
                object = this.items;
                int n2 = this.style.getOpener().length() + this.style.getSpacer().length();
                int n3 = result;
                bl = false;
                int n4 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object t;
                    Object t2 = t = iterator.next();
                    n = n4;
                    boolean bl2 = false;
                    int n5 = it.toString().length();
                    n4 = n + n5;
                }
                n = n4;
                result = n3 + (n2 + n);
                result += (this.items.size() - 1) * this.style.getSeparator().length() + this.style.getSpacer().length();
                return result += this.style.getSpacer().length() + this.style.getCloser().length();
            }

            @NotNull
            public final String compressed$jipp_core() {
                StringBuilder out = new StringBuilder();
                CharSequence charSequence = this.prefix;
                boolean bl = false;
                if (charSequence.length() > 0) {
                    out.append(this.prefix);
                    out.append(this.style.getSpacer());
                }
                out.append(this.style.getOpener());
                out.append(this.style.getSpacer());
                out.append(CollectionsKt.joinToString$default((Iterable)this.items, (CharSequence)Intrinsics.stringPlus((String)this.style.getSeparator(), (Object)this.style.getSpacer()), null, null, (int)0, null, null, (int)62, null));
                out.append(this.style.getSpacer());
                out.append(this.style.getCloser());
                charSequence = out.toString();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"out.toString()");
                return charSequence;
            }

            @NotNull
            public final String expanded$jipp_core(int startPos, @NotNull String indent) {
                boolean compact;
                StringBuilder out;
                block6: {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)indent, (String)"indent");
                    out = new StringBuilder();
                    CharSequence charSequence = this.prefix;
                    boolean bl2 = false;
                    if (charSequence.length() > 0) {
                        out.append(this.prefix);
                        out.append(this.style.getSpacer());
                    }
                    out.append(this.style.getOpener());
                    Iterable $this$none$iv = this.items;
                    boolean $i$f$none = false;
                    if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                        bl = true;
                    } else {
                        Iterator iterator = $this$none$iv.iterator();
                        while (iterator.hasNext()) {
                            Object element$iv;
                            Object it = element$iv = iterator.next();
                            boolean bl3 = false;
                            if (!(it.toString().length() > this.maxWidth / 3)) continue;
                            bl = false;
                            break block6;
                        }
                        bl = compact = true;
                    }
                }
                if (compact) {
                    out.append(this.style.getSpacer());
                    this.wrap(out, startPos, indent);
                } else {
                    out.append(PrettyPrinter.NEWLINE);
                    out.append(indent);
                    out.append(CollectionsKt.joinToString$default((Iterable)this.items, (CharSequence)(this.style.getSeparator() + '\n' + indent), null, null, (int)0, null, null, (int)62, null));
                }
                out.append(this.style.getSpacer());
                out.append(this.style.getCloser());
                String string = out.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"out.toString()");
                return string;
            }

            private final void wrap(StringBuilder out, int startPos, String indent) {
                int curWidth = 0;
                curWidth = startPos + out.length();
                Collection collection = this.items;
                boolean bl = false;
                if (!collection.isEmpty()) {
                    String itemString = CollectionsKt.first((List)this.items).toString();
                    out.append(itemString);
                    curWidth += itemString.length();
                }
                Iterable $this$forEach$iv = CollectionsKt.drop((Iterable)this.items, (int)1);
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    String itemString = it.toString();
                    int expectedWidth = this.style.getSeparator().length() + this.style.getSpacer().length() + itemString.length();
                    if (curWidth + expectedWidth > this.maxWidth) {
                        out.append(this.style.getSeparator());
                        out.append(PrettyPrinter.NEWLINE);
                        out.append(indent);
                        out.append(itemString);
                        curWidth = indent.length() + itemString.length();
                        continue;
                    }
                    out.append(this.style.getSeparator());
                    out.append(this.style.getSpacer());
                    out.append(itemString);
                    curWidth += this.style.getSeparator().length();
                    curWidth += this.style.getSpacer().length();
                    curWidth += itemString.length();
                }
            }
        }
    }
}

