/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.encoding;

import com.hp.jipp.encoding.IntOrIntRange;
import com.hp.jipp.model.MediaCol;
import com.hp.jipp.model.MediaColDatabase;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u0004\u0018\u00010\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/hp/jipp/encoding/MediaSizes;", "", "()V", "HEIGHT_AT", "", "MM_HUNDREDTHS_PER_INCH", "MM_HUNDREDTHS_PER_MM", "WIDTH_AT", "WIDTH_HEIGHT_DIMENSION_COUNT", "WIDTH_HEIGHT_UNIT_AT", "widthHeightPattern", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "parse", "Lcom/hp/jipp/model/MediaCol$MediaSize;", "mediaName", "", "toMediaColDatabaseMediaSize", "Lcom/hp/jipp/model/MediaColDatabase$MediaSize;", "jipp-core"})
public final class MediaSizes {
    @NotNull
    public static final MediaSizes INSTANCE = new MediaSizes();
    private static final Pattern widthHeightPattern = Pattern.compile("_([0-9]+(\\.[0-9]+)?)?x([0-9]+(\\.[0-9]+)?)([a-z]+)?$");
    private static final int WIDTH_AT = 1;
    private static final int HEIGHT_AT = 3;
    private static final int WIDTH_HEIGHT_DIMENSION_COUNT = 4;
    private static final int WIDTH_HEIGHT_UNIT_AT = 5;
    private static final int MM_HUNDREDTHS_PER_INCH = 2540;
    private static final int MM_HUNDREDTHS_PER_MM = 100;

    private MediaSizes() {
    }

    @JvmStatic
    @Nullable
    public static final MediaCol.MediaSize parse(@NotNull String mediaName) {
        String unitString;
        Matcher matches;
        block4: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)mediaName, (String)"mediaName");
                matches = widthHeightPattern.matcher(mediaName);
                if (!matches.find()) break block3;
                if (matches.groupCount() >= 4) break block4;
            }
            return null;
        }
        String string = matches.groupCount() >= 5 ? matches.group(5) : (unitString = (String)null);
        int units = Intrinsics.areEqual((Object)unitString, (Object)"in") ? 2540 : 100;
        String string2 = matches.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"matches.group(WIDTH_AT)");
        boolean bl = false;
        int x = (int)(Double.parseDouble(string2) * (double)units);
        String string3 = matches.group(3);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matches.group(HEIGHT_AT)");
        boolean bl2 = false;
        int y = (int)(Double.parseDouble(string3) * (double)units);
        return new MediaCol.MediaSize(x, y);
    }

    @JvmStatic
    @Nullable
    public static final MediaColDatabase.MediaSize toMediaColDatabaseMediaSize(@Nullable MediaCol.MediaSize $this$toMediaColDatabaseMediaSize) {
        MediaColDatabase.MediaSize mediaSize;
        MediaCol.MediaSize mediaSize2 = $this$toMediaColDatabaseMediaSize;
        if (mediaSize2 == null) {
            mediaSize = null;
        } else {
            MediaCol.MediaSize mediaSize3 = mediaSize2;
            boolean bl = false;
            boolean bl2 = false;
            MediaCol.MediaSize it = mediaSize3;
            boolean bl3 = false;
            Integer n = $this$toMediaColDatabaseMediaSize.getXDimension();
            Intrinsics.checkNotNull((Object)n);
            IntOrIntRange intOrIntRange = new IntOrIntRange(n);
            Integer n2 = $this$toMediaColDatabaseMediaSize.getYDimension();
            Intrinsics.checkNotNull((Object)n2);
            mediaSize = new MediaColDatabase.MediaSize(intOrIntRange, new IntOrIntRange(n2));
        }
        return mediaSize;
    }
}

