/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.encoding;

import com.hp.jipp.encoding.Attribute;
import com.hp.jipp.encoding.AttributeGroup;
import com.hp.jipp.encoding.Codec;
import com.hp.jipp.encoding.DelimiterTag;
import com.hp.jipp.encoding.EmptyAttribute;
import com.hp.jipp.encoding.Enum;
import com.hp.jipp.encoding.EnumType;
import com.hp.jipp.encoding.IppPacket;
import com.hp.jipp.encoding.IppStreams;
import com.hp.jipp.encoding.KeyValues;
import com.hp.jipp.encoding.KeyValuesType;
import com.hp.jipp.encoding.OutOfBandTag;
import com.hp.jipp.encoding.Tag;
import com.hp.jipp.encoding.UnknownAttribute;
import com.hp.jipp.encoding.ValueTag;
import com.hp.jipp.model.EnumTypes;
import com.hp.jipp.model.KeyValuesTypes;
import com.hp.jipp.util.ParseError;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001c\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\r\u0010\u0010\u001a\u00020\u0011H\u0000\u00a2\u0006\u0002\b\u0012J\u0017\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00060\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\b\u0010\u0016\u001a\u0004\u0018\u00010\fJ\r\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u000e\u0010\u001a\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0006\u0010\u001d\u001a\u00020\u001eJ\r\u0010\u001f\u001a\u00020\nH\u0000\u00a2\u0006\u0002\b J\n\u0010!\u001a\u0004\u0018\u00010\bH\u0002J0\u0010\"\u001a\u00020\u001c\"\b\b\u0000\u0010#*\u00020\u001c2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H#0%2\u0006\u0010\r\u001a\u00020&2\u0006\u0010\t\u001a\u00020\nH\u0002J\r\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J\r\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,J\u0015\u0010-\u001a\u00020+2\u0006\u0010.\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b/\u00a8\u00060"}, d2={"Lcom/hp/jipp/encoding/IppInputStream;", "Ljava/io/DataInputStream;", "inputStream", "Ljava/io/InputStream;", "(Ljava/io/InputStream;)V", "readAnyAttribute", "Lcom/hp/jipp/encoding/Attribute;", "initTag", "Lcom/hp/jipp/encoding/Tag;", "attributeName", "", "readAttributeGroup", "Lcom/hp/jipp/encoding/AttributeGroup;", "tag", "Lcom/hp/jipp/encoding/DelimiterTag;", "readAttributeGroup$jipp_core", "readByteValue", "", "readByteValue$jipp_core", "readCollectionAttributes", "", "readCollectionAttributes$jipp_core", "readGroup", "readIntValue", "", "readIntValue$jipp_core", "readNextAttribute", "readNextValue", "", "readPacket", "Lcom/hp/jipp/encoding/IppPacket;", "readString", "readString$jipp_core", "readTag", "readValue", "T", "codec", "Lcom/hp/jipp/encoding/Codec;", "Lcom/hp/jipp/encoding/ValueTag;", "readValueBytes", "", "readValueBytes$jipp_core", "skipValueBytes", "", "skipValueBytes$jipp_core", "takeLength", "length", "takeLength$jipp_core", "jipp-core"})
public final class IppInputStream
extends DataInputStream {
    public IppInputStream(@NotNull InputStream inputStream) {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        super(new BufferedInputStream(inputStream));
    }

    @NotNull
    public final IppPacket readPacket() throws IOException {
        return new IppPacket((int)this.readShort(), (int)this.readShort(), this.readInt(), SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<AttributeGroup>(this){
            final /* synthetic */ IppInputStream this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final AttributeGroup invoke() {
                return this.this$0.readGroup();
            }
        }))));
    }

    @Nullable
    public final AttributeGroup readGroup() {
        AttributeGroup attributeGroup;
        Tag tag = this.readTag();
        if (tag == null) {
            attributeGroup = null;
        } else {
            Tag tag2;
            Tag tag3 = tag;
            boolean bl = false;
            boolean bl2 = false;
            Tag it = tag3;
            boolean bl3 = false;
            Tag tag4 = tag2 = !Intrinsics.areEqual((Object)it, (Object)Tag.endOfAttributes) ? tag3 : null;
            if (tag2 == null) {
                attributeGroup = null;
            } else {
                tag3 = tag2;
                bl = false;
                bl2 = false;
                Tag tag5 = tag3;
                boolean bl4 = false;
                if (!(tag5 instanceof DelimiterTag)) {
                    throw new ParseError(Intrinsics.stringPlus((String)"Illegal delimiter ", (Object)tag5));
                }
                attributeGroup = this.readAttributeGroup$jipp_core((DelimiterTag)tag5);
            }
        }
        return attributeGroup;
    }

    private final Tag readTag() {
        Tag tag;
        Integer n;
        Integer n2 = this.read();
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n2).intValue();
        boolean bl3 = false;
        Integer n3 = n = it >= 0 ? n2 : null;
        if (n == null) {
            tag = null;
        } else {
            n2 = n;
            bl = false;
            bl2 = false;
            it = ((Number)n2).intValue();
            boolean bl4 = false;
            tag = Tag.Companion.fromInt(it);
        }
        return tag;
    }

    @NotNull
    public final AttributeGroup readAttributeGroup$jipp_core(@NotNull DelimiterTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        return AttributeGroup.Companion.groupOf(tag, SequencesKt.toList((Sequence)SequencesKt.generateSequence((Function0)new Function0<Attribute<?>>(this){
            final /* synthetic */ IppInputStream this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @Nullable
            public final Attribute<?> invoke() {
                return IppInputStream.access$readNextAttribute(this.this$0);
            }
        })));
    }

    private final Attribute<?> readNextAttribute() {
        Attribute attribute;
        this.mark(1);
        Tag tag = this.readTag();
        if (tag == null) {
            attribute = null;
        } else {
            Tag tag2 = tag;
            boolean bl = false;
            boolean bl2 = false;
            Tag tag3 = tag2;
            boolean bl3 = false;
            if (tag3.isDelimiter()) {
                this.reset();
                attribute = null;
            } else {
                attribute = this.readAnyAttribute(tag3);
            }
        }
        return attribute;
    }

    private final Attribute<?> readAnyAttribute(Tag initTag) {
        return this.readAnyAttribute(this.readString$jipp_core(), initTag);
    }

    @NotNull
    public final String readString$jipp_core() {
        byte[] byArray = this.readValueBytes$jipp_core();
        boolean bl = false;
        return new String(byArray, Charsets.UTF_8);
    }

    private final Attribute<?> readAnyAttribute(String attributeName, Tag initTag) {
        Attribute attribute;
        Tag tag = initTag;
        if (tag instanceof OutOfBandTag) {
            this.readValueBytes$jipp_core();
            attribute = new EmptyAttribute(attributeName, (OutOfBandTag)initTag);
        } else if (tag instanceof ValueTag) {
            UnknownAttribute unknownAttribute;
            Object v1;
            boolean bl;
            Object object;
            block8: {
                object = IppStreams.INSTANCE.getCodecs();
                bl = false;
                Iterable iterable = object;
                boolean bl2 = false;
                for (Object t : iterable) {
                    Codec it = (Codec)t;
                    boolean bl3 = false;
                    if (!it.handlesTag((ValueTag)initTag)) continue;
                    v1 = t;
                    break block8;
                }
                v1 = null;
            }
            Codec codec = v1;
            if (codec == null) {
                unknownAttribute = null;
            } else {
                object = codec;
                bl = false;
                boolean bl4 = false;
                Object it = object;
                boolean bl5 = false;
                unknownAttribute = new UnknownAttribute(attributeName, CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.readValue((Codec)it, (ValueTag)initTag, attributeName)), (Sequence)SequencesKt.generateSequence((Function0)((Function0)new Function0<Object>(this, attributeName){
                    final /* synthetic */ IppInputStream this$0;
                    final /* synthetic */ String $attributeName;
                    {
                        this.this$0 = $receiver;
                        this.$attributeName = $attributeName;
                        super(0);
                    }

                    @Nullable
                    public final Object invoke() {
                        return IppInputStream.access$readNextValue(this.this$0, this.$attributeName);
                    }
                }))));
            }
            UnknownAttribute unknownAttribute2 = unknownAttribute;
            if (unknownAttribute2 == null) {
                throw new ParseError(Intrinsics.stringPlus((String)"No codec found for tag ", (Object)initTag));
            }
            attribute = unknownAttribute2;
        } else {
            throw new ParseError(Intrinsics.stringPlus((String)"invalid attribute tag ", (Object)initTag));
        }
        return attribute;
    }

    private final <T> Object readValue(Codec<T> codec, ValueTag tag, String attributeName) {
        KeyValuesType keyValuesType;
        if (Intrinsics.areEqual((Object)tag, (Object)Tag.enumValue)) {
            EnumType<? extends Enum> enumType = EnumTypes.all.get(attributeName);
            if (enumType != null) {
                EnumType<? extends Enum> enumType2 = enumType;
                boolean bl = false;
                boolean bl2 = false;
                EnumType<? extends Enum> it = enumType2;
                boolean bl3 = false;
                Object object = it.coerce(this.readIntValue$jipp_core());
                Intrinsics.checkNotNull((Object)object);
                return object;
            }
        } else if (Intrinsics.areEqual((Object)tag, (Object)Tag.octetString) && (keyValuesType = KeyValuesTypes.all.get(attributeName)) != null) {
            KeyValuesType keyValuesType2 = keyValuesType;
            boolean bl = false;
            boolean bl4 = false;
            KeyValuesType it = keyValuesType2;
            boolean bl5 = false;
            return KeyValues.Companion.getCodec().readValue(this, tag);
        }
        return codec.readValue(this, tag);
    }

    public final int readIntValue$jipp_core() {
        this.takeLength$jipp_core(4);
        return this.readInt();
    }

    public final void takeLength$jipp_core(int length) {
        short readLength = this.readShort();
        if (readLength != length) {
            throw new ParseError("Bad attribute length: expected " + length + ", got " + readLength);
        }
    }

    @NotNull
    public final byte[] readValueBytes$jipp_core() {
        short valueLength = this.readShort();
        byte[] valueBytes = new byte[valueLength];
        if (valueLength > 0) {
            this.readFully(valueBytes);
        }
        return valueBytes;
    }

    private final Object readNextValue(String attributeName) {
        Object object;
        this.mark(4);
        Tag tag = this.readTag();
        if (tag == null) {
            object = null;
        } else {
            Tag tag2 = tag;
            boolean bl = false;
            boolean bl2 = false;
            Tag tag3 = tag2;
            boolean bl3 = false;
            if (tag3.isEndOfValueStream$jipp_core() || this.readShort() != 0) {
                this.reset();
                object = null;
            } else if (tag3 instanceof ValueTag) {
                Codec codec;
                Codec codec2 = IppStreams.INSTANCE.getTagToCodec().get(tag3);
                if (codec2 == null) {
                    Object v1;
                    block10: {
                        Iterable $this$firstOrNull$iv = IppStreams.INSTANCE.getCodecs();
                        boolean $i$f$firstOrNull = false;
                        for (Object element$iv : $this$firstOrNull$iv) {
                            Codec it = (Codec)element$iv;
                            boolean bl4 = false;
                            if (!it.handlesTag((ValueTag)tag3)) continue;
                            v1 = element$iv;
                            break block10;
                        }
                        v1 = null;
                    }
                    Codec codec3 = v1;
                    if (codec3 == null) {
                        throw new ParseError(Intrinsics.stringPlus((String)"No codec found for tag ", (Object)tag3));
                    }
                    codec = codec3;
                } else {
                    codec = codec2;
                }
                Codec codec4 = codec;
                object = this.readValue(codec4, (ValueTag)tag3, attributeName);
            } else {
                object = null;
            }
        }
        return object;
    }

    @NotNull
    public final List<Attribute<?>> readCollectionAttributes$jipp_core() {
        Tag tag;
        boolean bl = false;
        List attributes = new ArrayList();
        while (true) {
            if (Intrinsics.areEqual((Object)(tag = this.readTag()), (Object)Tag.endCollection)) {
                this.skipValueBytes$jipp_core();
                this.skipValueBytes$jipp_core();
                return attributes;
            }
            if (!Intrinsics.areEqual((Object)tag, (Object)Tag.memberAttributeName)) break;
            this.skipValueBytes$jipp_core();
            String memberName = this.readString$jipp_core();
            Tag tag2 = this.readTag();
            if (tag2 == null) {
                throw new ParseError(Intrinsics.stringPlus((String)"Missing member tag in ", (Object)tag));
            }
            Tag memberTag = tag2;
            this.readValueBytes$jipp_core();
            attributes.add(this.readAnyAttribute(memberName, memberTag));
        }
        throw new ParseError(Intrinsics.stringPlus((String)"Bad tag in collection: ", (Object)tag));
    }

    public final void skipValueBytes$jipp_core() {
        long valueLength = this.readShort();
        if (valueLength != this.skip(valueLength)) {
            throw new ParseError("Value too short");
        }
    }

    public final byte readByteValue$jipp_core() {
        this.takeLength$jipp_core(1);
        return this.readByte();
    }

    public static final /* synthetic */ Attribute access$readNextAttribute(IppInputStream $this) {
        return $this.readNextAttribute();
    }

    public static final /* synthetic */ Object access$readNextValue(IppInputStream $this, String attributeName) {
        return $this.readNextValue(attributeName);
    }
}

