/*
 * Decompiled with CFR 0.152.
 */
package com.hp.jipp.encoding;

import com.hp.jipp.encoding.Attribute;
import com.hp.jipp.encoding.AttributeSetType;
import com.hp.jipp.encoding.AttributeTypeImpl;
import com.hp.jipp.encoding.Codec;
import com.hp.jipp.encoding.IppInputStream;
import com.hp.jipp.encoding.IppOutputStream;
import com.hp.jipp.encoding.Tag;
import com.hp.jipp.encoding.ValueTag;
import com.hp.jipp.util.ParseError;
import java.util.Arrays;
import java.util.Calendar;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0016\u0018\u0000 \u00072\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0007\bB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/hp/jipp/encoding/DateTimeType;", "Lcom/hp/jipp/encoding/AttributeTypeImpl;", "Ljava/util/Calendar;", "name", "", "(Ljava/lang/String;)V", "toString", "Companion", "Set", "jipp-core"})
public class DateTimeType
extends AttributeTypeImpl<Calendar> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int BYTE_MASK = 255;
    private static final int CALENDAR_LENGTH = 11;
    @NotNull
    private static final Codec<Calendar> codec;

    public DateTimeType(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        super(name, Calendar.class);
    }

    @Override
    @NotNull
    public String toString() {
        return "DateTimeType(" + this.getName() + ')';
    }

    static {
        Codec.Companion companion = Codec.Companion;
        ValueTag valueTag$iv = Tag.dateTime;
        boolean $i$f$invoke = false;
        codec = new Codec<Calendar>(valueTag$iv){
            @NotNull
            private final Class<Calendar> cls;
            final /* synthetic */ ValueTag $valueTag;
            {
                this.$valueTag = $valueTag;
                this.cls = Calendar.class;
            }

            @NotNull
            public Class<Calendar> getCls() {
                return this.cls;
            }

            @NotNull
            public ValueTag tagOf(@NotNull Object value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return this.$valueTag;
            }

            public boolean handlesTag(@NotNull ValueTag tag) {
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                return Intrinsics.areEqual((Object)this.$valueTag, (Object)tag);
            }

            public Calendar readValue(@NotNull IppInputStream input, @NotNull ValueTag startTag) {
                Intrinsics.checkNotNullParameter((Object)input, (String)"input");
                Intrinsics.checkNotNullParameter((Object)startTag, (String)"startTag");
                ValueTag valueTag = startTag;
                IppInputStream $this$codec_u24lambda_u2d0 = input;
                boolean bl = false;
                byte[] bytes = $this$codec_u24lambda_u2d0.readValueBytes$jipp_core();
                if (bytes.length != 11) {
                    throw new ParseError("Invalid byte count " + bytes.length + " for dateTime, must be 11");
                }
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                calendar.set(1, (bytes[0] << 8) + com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[1]));
                calendar.set(2, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[2]) - 1);
                calendar.set(5, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[3]));
                calendar.set(11, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[4]));
                calendar.set(12, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[5]));
                calendar.set(13, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[6]));
                calendar.set(14, com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[7]) * 100);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "GMT%s%02d%02d";
                Object[] objectArray = new Object[]{Character.valueOf((char)bytes[8]), com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[9]), com.hp.jipp.encoding.DateTimeType$Companion.access$toUint(DateTimeType.Companion, bytes[10])};
                boolean bl2 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String zoneString = string2;
                calendar.setTimeZone(TimeZone.getTimeZone(zoneString));
                Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"calendar");
                return calendar;
            }

            /*
             * WARNING - void declaration
             */
            public void writeValue(@NotNull IppOutputStream output, @NotNull Object value) {
                int n;
                void it;
                Intrinsics.checkNotNullParameter((Object)output, (String)"output");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Calendar calendar = (Calendar)value;
                IppOutputStream $this$codec_u24lambda_u2d1 = output;
                boolean bl = false;
                $this$codec_u24lambda_u2d1.writeShort(11);
                $this$codec_u24lambda_u2d1.writeShort(it.get(1));
                $this$codec_u24lambda_u2d1.writeByte(it.get(2) + 1);
                $this$codec_u24lambda_u2d1.writeByte(it.get(5));
                $this$codec_u24lambda_u2d1.writeByte(it.get(11));
                $this$codec_u24lambda_u2d1.writeByte(it.get(12));
                $this$codec_u24lambda_u2d1.writeByte(it.get(13));
                $this$codec_u24lambda_u2d1.writeByte(it.get(14) / 100);
                int zone = it.getTimeZone().getRawOffset();
                if (zone < 0) {
                    n = 45;
                    boolean bl2 = false;
                    $this$codec_u24lambda_u2d1.writeByte(n);
                    zone = -zone;
                } else {
                    n = 43;
                    boolean bl3 = false;
                    $this$codec_u24lambda_u2d1.writeByte(n);
                }
                int offsetMinutes = zone / 1000 / 60;
                $this$codec_u24lambda_u2d1.writeByte(offsetMinutes / 60);
                $this$codec_u24lambda_u2d1.writeByte(offsetMinutes % 60);
            }
        };
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\b"}, d2={"Lcom/hp/jipp/encoding/DateTimeType$Set;", "Lcom/hp/jipp/encoding/DateTimeType;", "Lcom/hp/jipp/encoding/AttributeSetType;", "Ljava/util/Calendar;", "name", "", "(Ljava/lang/String;)V", "toString", "jipp-core"})
    public static final class Set
    extends DateTimeType
    implements AttributeSetType<Calendar> {
        public Set(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name);
        }

        @Override
        @NotNull
        public String toString() {
            return "DateTimeType.Set(" + this.getName() + ')';
        }

        @NotNull
        public Attribute<Calendar> of(@NotNull Calendar value, Calendar ... values) {
            return AttributeSetType.DefaultImpls.of(this, value, values);
        }

        @Override
        @NotNull
        public Attribute<Calendar> of(@NotNull Iterable<? extends Calendar> values) {
            return AttributeSetType.DefaultImpls.of(this, values);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u000b\u001a\u00020\u0004*\u00020\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lcom/hp/jipp/encoding/DateTimeType$Companion;", "", "()V", "BYTE_MASK", "", "CALENDAR_LENGTH", "codec", "Lcom/hp/jipp/encoding/Codec;", "Ljava/util/Calendar;", "getCodec", "()Lcom/hp/jipp/encoding/Codec;", "toUint", "", "jipp-core"})
    public static final class Companion {
        private Companion() {
        }

        private final int toUint(byte $this$toUint) {
            return $this$toUint & 0xFF;
        }

        @NotNull
        public final Codec<Calendar> getCodec() {
            return codec;
        }

        public static final /* synthetic */ int access$toUint(Companion $this, byte $receiver) {
            return $this.toUint($receiver);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

