/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.ResIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.impl.PropertyImpl;
import com.hp.hpl.jena.rdf.model.impl.ResourceImpl;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.TriplePattern;
import com.hp.hpl.jena.reasoner.rulesys.Node_RuleVariable;
import com.hp.hpl.jena.shared.JenaException;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReasonerTester {
    public static final String NS = "http://www.hpl.hp.com/semweb/2003/query_tester#";
    public static final String BASE_URI = "http://www.hpl.hp.com/semweb/2003/query_tester/";
    public static final Resource testClass;
    public static final Property descriptionP;
    public static final Property tboxP;
    public static final Property dataP;
    public static final Property queryP;
    public static final Property resultP;
    public static final String baseDir = "testing/reasoners/";
    protected Model testManifest;
    protected Map sourceCache = new HashMap();
    protected static Log logger;

    public ReasonerTester(String manifest) throws IOException {
        this.testManifest = this.loadFile(manifest, false);
    }

    public Model loadFile(String file, boolean cache) throws IOException {
        if (cache && this.sourceCache.keySet().contains(file)) {
            return (Model)this.sourceCache.get(file);
        }
        String langType = "RDF/XML";
        if (file.endsWith(".nt")) {
            langType = "N-TRIPLE";
        } else if (file.endsWith("n3")) {
            langType = "N3";
        }
        Model result = ModelFactory.createDefaultModel();
        BufferedReader reader = new BufferedReader(new FileReader(baseDir + file));
        result.read((Reader)reader, BASE_URI + file, langType);
        if (cache) {
            this.sourceCache.put(file, result);
        }
        return result;
    }

    public Graph loadTestFile(Resource test, Property predicate) throws IOException {
        if (test.hasProperty(predicate)) {
            String fileName = test.getRequiredProperty(predicate).getObject().toString();
            boolean cache = predicate.equals(tboxP) || predicate.equals(dataP);
            return this.loadFile(fileName, cache).getGraph();
        }
        return Factory.createGraphMem();
    }

    public static TriplePattern tripleToPattern(Triple t) {
        return new TriplePattern(ReasonerTester.nodeToPattern(t.getSubject()), ReasonerTester.nodeToPattern(t.getPredicate()), ReasonerTester.nodeToPattern(t.getObject()));
    }

    public static Node nodeToPattern(Node n) {
        if (n.isURI() && n.toString().startsWith("var:")) {
            return Node_RuleVariable.WILD;
        }
        return n;
    }

    public boolean runTests(ReasonerFactory reasonerF, TestCase testcase, Resource configuration) throws IOException {
        Iterator i = this.listTests().iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            if (this.runTest(test, reasonerF, testcase, configuration)) continue;
            return false;
        }
        return true;
    }

    public boolean runTests(Reasoner reasoner, TestCase testcase) throws IOException {
        Iterator i = this.listTests().iterator();
        while (i.hasNext()) {
            String test = (String)i.next();
            if (this.runTest(test, reasoner, testcase)) continue;
            return false;
        }
        return true;
    }

    public List listTests() {
        ArrayList<String> testList = new ArrayList<String>();
        ResIterator tests = this.testManifest.listSubjectsWithProperty(RDF.type, (RDFNode)testClass);
        while (tests.hasNext()) {
            testList.add(tests.next().toString());
        }
        return testList;
    }

    public boolean runTest(String uri, ReasonerFactory reasonerF, TestCase testcase, Resource configuration) throws IOException {
        Reasoner reasoner = reasonerF.create(configuration);
        return this.runTest(uri, reasoner, testcase);
    }

    public boolean runTest(String uri, Reasoner reasoner, TestCase testcase) throws IOException {
        Resource test = this.testManifest.getResource(uri);
        if (!test.hasProperty(RDF.type, (RDFNode)testClass)) {
            throw new JenaException("Can't find test: " + uri);
        }
        String description = test.getRequiredProperty(descriptionP).getObject().toString();
        logger.debug((Object)("Reasoner test " + test.getURI() + " - " + description));
        Graph tbox = this.loadTestFile(test, tboxP);
        Graph data = this.loadTestFile(test, dataP);
        InfGraph graph = reasoner.bindSchema(tbox).bind(data);
        Graph queryG = this.loadTestFile(test, queryP);
        Graph resultG = Factory.createGraphMem();
        ExtendedIterator queries = queryG.find(null, null, null);
        while (queries.hasNext()) {
            TriplePattern query = ReasonerTester.tripleToPattern((Triple)queries.next());
            logger.debug((Object)("Query: " + query));
            ExtendedIterator answers = graph.find(query.asTripleMatch());
            while (answers.hasNext()) {
                Triple ans = (Triple)answers.next();
                logger.debug((Object)("ans: " + TriplePattern.simplePrintString((Triple)ans)));
                resultG.add(ans);
            }
        }
        Graph correctG = this.loadTestFile(test, resultP);
        boolean correct = correctG.isIsomorphicWith(resultG);
        if (testcase != null) {
            TestCase.assertTrue((String)description, (boolean)correct);
        }
        return correct;
    }

    static {
        descriptionP = new PropertyImpl(NS, "description");
        tboxP = new PropertyImpl(NS, "tbox");
        dataP = new PropertyImpl(NS, "data");
        queryP = new PropertyImpl(NS, "query");
        resultP = new PropertyImpl(NS, "result");
        testClass = new ResourceImpl(NS, "Test");
        logger = LogFactory.getLog((Class)ReasonerTester.class);
    }
}

