/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.impl.test;

import com.hp.hpl.jena.ontology.OntModel;
import com.hp.hpl.jena.ontology.Ontology;
import com.hp.hpl.jena.ontology.Profile;
import com.hp.hpl.jena.ontology.impl.test.OntTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import junit.framework.TestSuite;

public class TestOntology
extends OntTestBase {
    public static TestSuite suite() {
        return new TestOntology("TestOntology");
    }

    public TestOntology(String name) {
        super(name);
    }

    public OntTestBase.OntTestCase[] getTests() {
        return new OntTestBase.OntTestCase[]{new OntTestBase.OntTestCase("Ontology.imports", true, true, true, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addImport((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.IMPORTS()));
                1.assertEquals((String)"x should import y", (Object)y, (Object)x.getImport());
                x.addImport((Resource)z);
                1.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.IMPORTS()));
                this.iteratorTest((Iterator)x.listImports(), new Object[]{y, z});
                x.setImport((Resource)z);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.IMPORTS()));
                1.assertEquals((String)"x should import z", (Object)z, (Object)x.getImport());
                x.removeImport((Resource)y);
                1.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.IMPORTS()));
                x.removeImport((Resource)z);
                1.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.IMPORTS()));
            }
        }, new OntTestBase.OntTestCase("Ontology.backwardCompatibleWith", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addBackwardCompatibleWith((Resource)y);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals((String)"x should be back comp with y", (Object)y, (Object)x.getBackwardCompatibleWith());
                x.addBackwardCompatibleWith((Resource)z);
                2.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                this.iteratorTest((Iterator)x.listBackwardCompatibleWith(), new Object[]{y, z});
                x.setBackwardCompatibleWith((Resource)z);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                2.assertEquals((String)"x should be back comp with z", (Object)z, (Object)x.getBackwardCompatibleWith());
                x.removeBackwardCompatibleWith((Resource)y);
                2.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
                x.removeBackwardCompatibleWith((Resource)z);
                2.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.BACKWARD_COMPATIBLE_WITH()));
            }
        }, new OntTestBase.OntTestCase("Ontology.priorVersion", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addPriorVersion((Resource)y);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.PRIOR_VERSION()));
                3.assertEquals((String)"x should have prior y", (Object)y, (Object)x.getPriorVersion());
                x.addPriorVersion((Resource)z);
                3.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.PRIOR_VERSION()));
                this.iteratorTest((Iterator)x.listPriorVersion(), new Object[]{y, z});
                x.setPriorVersion((Resource)z);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.PRIOR_VERSION()));
                3.assertEquals((String)"x should have prior z", (Object)z, (Object)x.getPriorVersion());
                x.removePriorVersion((Resource)y);
                3.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.PRIOR_VERSION()));
                x.removePriorVersion((Resource)z);
                3.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.PRIOR_VERSION()));
            }
        }, new OntTestBase.OntTestCase("Ontology.incompatibleWith", true, true, false, false){

            public void ontTest(OntModel m) throws Exception {
                Profile prof = m.getProfile();
                Ontology x = m.createOntology("http://jena.hpl.hp.com/testing/ontology#x");
                Ontology y = m.createOntology("http://jena.hpl.hp.com/testing/ontology#y");
                Ontology z = m.createOntology("http://jena.hpl.hp.com/testing/ontology#z");
                x.addIncompatibleWith((Resource)y);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.INCOMPATIBLE_WITH()));
                4.assertEquals((String)"x should be in comp with y", (Object)y, (Object)x.getIncompatibleWith());
                x.addIncompatibleWith((Resource)z);
                4.assertEquals((String)"Cardinality should be 2", (int)2, (int)x.getCardinality(prof.INCOMPATIBLE_WITH()));
                this.iteratorTest((Iterator)x.listIncompatibleWith(), new Object[]{y, z});
                x.setIncompatibleWith((Resource)z);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.INCOMPATIBLE_WITH()));
                4.assertEquals((String)"x should be incomp with z", (Object)z, (Object)x.getIncompatibleWith());
                x.removeIncompatibleWith((Resource)y);
                4.assertEquals((String)"Cardinality should be 1", (int)1, (int)x.getCardinality(prof.INCOMPATIBLE_WITH()));
                x.removeIncompatibleWith((Resource)z);
                4.assertEquals((String)"Cardinality should be 0", (int)0, (int)x.getCardinality(prof.INCOMPATIBLE_WITH()));
            }
        }};
    }
}

