/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.ontology.daml.impl.test;

import com.hp.hpl.jena.datatypes.TypeMapper;
import com.hp.hpl.jena.ontology.OntDocumentManager;
import com.hp.hpl.jena.ontology.daml.DAMLClass;
import com.hp.hpl.jena.ontology.daml.DAMLCommon;
import com.hp.hpl.jena.ontology.daml.DAMLDataInstance;
import com.hp.hpl.jena.ontology.daml.DAMLDatatypeProperty;
import com.hp.hpl.jena.ontology.daml.DAMLInstance;
import com.hp.hpl.jena.ontology.daml.DAMLList;
import com.hp.hpl.jena.ontology.daml.DAMLModel;
import com.hp.hpl.jena.ontology.daml.DAMLObjectProperty;
import com.hp.hpl.jena.ontology.daml.DAMLProperty;
import com.hp.hpl.jena.ontology.daml.DAMLRestriction;
import com.hp.hpl.jena.ontology.daml.PropertyAccessor;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.NodeIterator;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.DAML_OIL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.XSD;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DAMLTest
extends TestCase {
    private static Log log = LogFactory.getLog((Class)DAMLTest.class);
    static /* synthetic */ Class class$com$hp$hpl$jena$rdf$model$RDFList;

    public DAMLTest(String name) {
        super(name);
    }

    public void setUp() {
        OntDocumentManager.getInstance().reset(true);
    }

    public void tearDown() {
    }

    public void testLoadOntology() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)m.getLoadSuccessful());
        DAMLTest.assertEquals((String)"Count of number of classes in daml store (2001/03, import)", (int)31, (int)this.countClasses(m));
        DAMLTest.assertEquals((String)"Property count ", (int)68, (int)this.countProperties(m));
        m = this.getCleanModel();
        m.getLoader().setLoadImportedOntologies(false);
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)m.getLoadSuccessful());
        DAMLTest.assertEquals((String)"Count of number of classes in daml store (2001/03, no import)", (int)16, (int)this.countClasses(m));
        m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-instance-load.daml");
        DAMLTest.assertTrue((String)"Load status should be true", (boolean)m.getLoadSuccessful());
        Resource pugh = m.getResource("http://dickinson-i-4/daml/tests/test-instance-load.daml#pugh");
        DAMLTest.assertNotNull((String)"Resource for officer Pugh should not be null", (Object)pugh);
        DAMLInstance pughInst = (DAMLInstance)pugh.as(DAMLInstance.class);
        DAMLTest.assertNotNull((Object)pughInst);
        m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"Load success status should be true", (boolean)m.getLoadSuccessful());
        DAMLProperty shoesize = (DAMLProperty)m.getProperty("http://www.daml.org/2001/03/daml+oil-ex#shoesize").as(DAMLProperty.class);
        DAMLTest.assertNotNull((String)"Failed to find shoesize property in example ontology", (Object)shoesize);
        DAMLTest.assertEquals((String)"shoesize should be a unique property", (boolean)true, (boolean)shoesize.isUnique());
    }

    public void testRDFType() {
        String ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-cases.daml");
        DAMLInstance fido = m.getDAMLInstance(ns + "fido");
        DAMLTest.assertNotNull((String)"fido instance should not be null", (Object)fido);
        DAMLClass cDog = m.getDAMLClass(ns + "Dog");
        DAMLTest.assertNotNull((String)"Dog class should not be null", (Object)cDog);
        DAMLClass cVertebrate = m.getDAMLClass(ns + "Vertebrate");
        DAMLTest.assertNotNull((String)"Vertebrate class should not be null", (Object)cVertebrate);
        DAMLClass cPet = m.getDAMLClass(ns + "Pet");
        DAMLTest.assertNotNull((String)"Pet class should not be null", (Object)cPet);
        DAMLTest.assertTrue((String)"fido should be member of class Dog", (boolean)fido.hasRDFType((Resource)cDog));
        DAMLTest.assertTrue((String)"fido should be member of class Vertebrate", (boolean)fido.hasRDFType((Resource)cVertebrate));
        DAMLTest.assertTrue((String)"fido should be member of class Vertebrate (by URL)", (boolean)fido.hasRDFType(ns + "Vertebrate"));
        DAMLTest.assertTrue((String)"fido should be member of class Pet", (boolean)fido.hasRDFType((Resource)cPet));
        DAMLTest.assertTrue((String)"fido should not be a class", (!fido.hasRDFType(DAML_OIL.Class) ? 1 : 0) != 0);
        DAMLTest.assertTrue((String)"fido should be a companion", (boolean)fido.hasRDFType(ns + "Companion"));
        DAMLClass cA = m.getDAMLClass(ns + "A");
        DAMLTest.assertNotNull((String)"Class A should not be null", (Object)cA);
        DAMLClass cB = m.getDAMLClass(ns + "B");
        DAMLTest.assertNotNull((String)"Class B should not be null", (Object)cB);
        DAMLInstance ab = m.getDAMLInstance(ns + "ab");
        DAMLTest.assertNotNull((String)"Instance ab should not be null", (Object)ab);
        DAMLTest.assertTrue((String)"ab should be an A", (boolean)ab.hasRDFType((Resource)cA));
        DAMLTest.assertTrue((String)"ab should be a B", (boolean)ab.hasRDFType((Resource)cB));
        DAMLTest.assertEquals((String)"Number of classes fido belongs to (closure) should be 8", (int)8, (int)this.countIteration((Iterator)fido.getRDFTypes(true), true, "fido member of class "));
        DAMLTest.assertEquals((String)"Number of classes fido belongs to (non-closure) should be 3", (int)3, (int)this.countIteration((Iterator)fido.getRDFTypes(false), true, "fido member of non-closed class "));
        DAMLProperty queenOf = m.getDAMLProperty(ns + "queen-of");
        DAMLTest.assertNotNull((String)"queen-of property should be defined", (Object)queenOf);
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)queenOf.hasRDFType(DAML_OIL.UnambiguousProperty));
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an ObjectProperty", (boolean)queenOf.hasRDFType(DAML_OIL.ObjectProperty));
        DAMLTest.assertTrue((String)"an UnabmbiguousProperty should be an rdf:Property", (boolean)queenOf.hasRDFType(RDF.Property));
    }

    public void testClass() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull((String)"Person class should not be null", (Object)person);
        DAMLTest.assertTrue((String)"Person should be a named class", (boolean)person.isNamedClass());
        int sCount0 = this.countIteration((Iterator)person.prop_subClassOf().getAll(), true, "super-class of Person (prop_subClassOf) ");
        int sCount1 = this.countIteration((Iterator)person.getSuperClasses(), true, "super-class of Person (getSuperClasses) ");
        DAMLTest.assertEquals((String)"person should have 10 super-classes (by prop_subClassOf)", (int)10, (int)sCount0);
        DAMLTest.assertEquals((String)"person should have 9 super-classes (by getSuperClasses)", (int)9, (int)sCount1);
        DAMLTest.assertEquals((String)"person should have 3 sub-classes", (int)3, (int)this.countIteration((Iterator)person.getSubClasses(), true, "Person super-class of: "));
        DAMLTest.assertTrue((String)"Person should be a disjoint union", (boolean)person.isDisjointUnion());
        DAMLList mw = person.prop_disjointUnionOf().getList();
        DAMLTest.assertNotNull((String)"Value of disjoint union should not be null", (Object)mw);
        DAMLTest.assertEquals((String)"Person should be a disjoint union of size 2", (int)2, (int)mw.getCount());
        DAMLClass female = m.getDAMLClass(ns + "Female");
        DAMLTest.assertNotNull((String)"Class Female should not be null", (Object)female);
        DAMLClass male = m.getDAMLClass(ns + "Male");
        DAMLTest.assertNotNull((String)"Class Male should not be null", (Object)male);
        DAMLTest.assertTrue((String)"Female should be disjoint with male", (boolean)female.prop_disjointWith().hasValue((RDFNode)male));
        DAMLClass humanBeing = m.getDAMLClass(ns + "HumanBeing");
        DAMLTest.assertNotNull((String)"Class humanBeing should not be null", (Object)humanBeing);
        DAMLTest.assertTrue((String)"Person should be same class as HumanBeing", (boolean)humanBeing.prop_sameClassAs().hasValue((RDFNode)person));
        DAMLClass tallMan = m.getDAMLClass(ns + "TallMan");
        DAMLTest.assertNotNull((String)"Class TallMan should not be null", (Object)tallMan);
        DAMLList tm = tallMan.prop_intersectionOf().getList();
        DAMLTest.assertNotNull((String)"Value of intersection should not be null", (Object)tm);
        DAMLTest.assertEquals((String)"Tall man should be an intersection of size 2", (int)2, (int)tm.getCount());
        DAMLClass car = m.getDAMLClass(ns + "Car");
        DAMLTest.assertNotNull((String)"Class Car should not be null", (Object)car);
        DAMLClass carSuper = (DAMLClass)car.getSuperClasses(false).next();
        DAMLTest.assertNotNull((String)"Car should have a super-class", (Object)carSuper);
        DAMLTest.assertTrue((String)"Car super-class should be a complement", (boolean)carSuper.isComplement());
        DAMLTest.assertTrue((String)"Car super-class should be a complement of Person", (boolean)carSuper.prop_complementOf().hasValue((RDFNode)person));
        DAMLClass height = m.getDAMLClass(ns + "Height");
        DAMLTest.assertNotNull((String)"Class Height should not be null", (Object)height);
        DAMLTest.assertTrue((String)"Height should be an enumeration", (boolean)height.isEnumeration());
        DAMLTest.assertEquals((String)"Height should be an enumeration of 3 elements", (int)3, (int)height.prop_oneOf().getList().getCount());
        DAMLModel m0 = this.getCleanModel();
        m0.getLoader().setLoadImportedOntologies(true);
        m0.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        String tcNs = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass subClassBug0 = m0.getDAMLClass(tcNs + "SubClassBug0");
        DAMLClass subClassBug1 = m0.getDAMLClass(tcNs + "SubClassBug1");
        DAMLTest.assertNotNull((String)"Class SubClassBug0 should not be null", (Object)subClassBug0);
        DAMLTest.assertNotNull((String)"Class SubClassBug1 should not be null", (Object)subClassBug1);
        DAMLTest.assertTrue((String)"SubClassBug1 should have SubClassBug0 as a super-class", (boolean)subClassBug1.hasSuperClass((Resource)subClassBug0));
        DAMLTest.assertTrue((String)"SubClassBug0 should have SubClassBug1 as a sub-class", (boolean)subClassBug0.hasSubClass((Resource)subClassBug1));
        DAMLClass defProp0 = m0.getDAMLClass(tcNs + "DefProp0");
        DAMLClass defProp1 = m0.getDAMLClass(tcNs + "DefProp1");
        DAMLClass defProp2 = m0.getDAMLClass(tcNs + "DefProp2");
        DAMLTest.assertNotNull((String)"Class DefProp0 should not be null", (Object)defProp0);
        DAMLTest.assertNotNull((String)"Class DefProp1 should not be null", (Object)defProp1);
        DAMLTest.assertNotNull((String)"Class DefProp2 should not be null", (Object)defProp2);
        int nP0 = this.countIteration((Iterator)defProp0.getDefinedProperties(), true, "Defined property of DefProp0, closed");
        int nP0nc = this.countIteration((Iterator)defProp0.getDefinedProperties(false), true, "Defined property of DefProp0, not closed");
        int nP1 = this.countIteration((Iterator)defProp1.getDefinedProperties(), true, "Defined property of DefProp1, closed");
        int nP1nc = this.countIteration((Iterator)defProp1.getDefinedProperties(false), true, "Defined property of DefProp1, not closed");
        int nP2 = this.countIteration((Iterator)defProp2.getDefinedProperties(), true, "Defined property of DefProp2, closed");
        int nP2nc = this.countIteration((Iterator)defProp2.getDefinedProperties(false), true, "Defined property of DefProp2, not closed");
        DAMLTest.assertEquals((String)"Defined properties of DefProp0 should number 11", (int)11, (int)nP0);
        DAMLTest.assertEquals((String)"Defined properties of DefProp0 (non-closed) should number 11", (int)11, (int)nP0nc);
        DAMLTest.assertEquals((String)"Defined properties of DefProp1 should number 11", (int)11, (int)nP1);
        DAMLTest.assertEquals((String)"Defined properties of DefProp1 (non-closed) should number 0", (int)0, (int)nP1nc);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 should number 12", (int)12, (int)nP2);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 (non-closed) should number 1", (int)1, (int)nP2nc);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 should number 12", (int)12, (int)nP2);
        DAMLTest.assertEquals((String)"Defined properties of DefProp2 (non-closed) should number 1", (int)1, (int)nP2nc);
        DAMLClass tl_one = m0.getDAMLClass(tcNs + "tl_one");
        DAMLTest.assertNotNull((String)"Class tl_one should not be null", (Object)tl_one);
        int tl_one_supers0 = this.countIteration((Iterator)tl_one.prop_subClassOf().getAll(), true, "prop_subClassOf ");
        int tl_one_supers1 = this.countIteration((Iterator)tl_one.getSuperClasses(false), true, "getSuperClasses ");
        DAMLTest.assertEquals((String)"Should be four super-classes of tl_one by prop_subClassOf", (int)4, (int)tl_one_supers0);
        DAMLTest.assertEquals((String)"Should be two super-classes of tl_one by getSuperClasses", (int)2, (int)tl_one_supers1);
        DAMLClass researcher = m0.getDAMLClass(tcNs + "Researcher");
        DAMLTest.assertNotNull((String)"Class Researcher should not be null", (Object)researcher);
        int researcherSupers = this.countIteration((Iterator)researcher.getSuperClasses(false), true, "Super-class of researcher");
        DAMLTest.assertEquals((String)"Should be 2 super-classes of researcher", (int)2, (int)researcherSupers);
    }

    public void testEquivalence() {
        String ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLInstance root = m.getDAMLInstance(ns + "x0");
        DAMLTest.assertNotNull((String)"Instance x0 should not be null", (Object)root);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration((Iterator)root.getEquivalentValues(), true, "Member of equivalence class to x0: "));
        DAMLClass cRoot = m.getDAMLClass(ns + "C0");
        DAMLTest.assertNotNull((String)"Class C0 should not be null", (Object)cRoot);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration((Iterator)cRoot.getSameClasses(), true, "sameClass as C0: "));
        DAMLProperty pRoot = m.getDAMLProperty(ns + "p0");
        DAMLTest.assertNotNull((String)"Property p0 should not be null", (Object)pRoot);
        DAMLTest.assertEquals((String)"Number of elements in equivalence class should be 1", (int)1, (int)this.countIteration((Iterator)pRoot.getSameProperties(), true, "sameProperty as p0: "));
        Resource dClass = m.getResource(ns + "CDaml");
        DAMLTest.assertNotNull((String)"Resource dClass should not be null", (Object)dClass);
        DAMLTest.assertTrue((String)"Resource dClass should be a daml class", (boolean)dClass.canAs(DAMLClass.class));
        DAMLClass cD0 = m.getDAMLClass(ns + "D0");
        DAMLClass cD1 = m.getDAMLClass(ns + "D1");
        DAMLInstance d1 = m.getDAMLInstance(ns + "d1");
        DAMLTest.assertNotNull((String)"Class D0 should not be null", (Object)cD0);
        DAMLTest.assertNotNull((String)"Class D1 should not be null", (Object)cD1);
        DAMLTest.assertNotNull((String)"Instance d1 should not be null", (Object)d1);
        DAMLTest.assertTrue((String)"Instance d1 should have class D1", (boolean)d1.hasRDFType((Resource)cD1));
        DAMLProperty pd0 = m.getDAMLProperty(ns + "pd0");
        DAMLProperty pd1 = m.getDAMLProperty(ns + "pd1");
        DAMLTest.assertNotNull((String)"Property pd0 should not be null", (Object)pd0);
        DAMLTest.assertNotNull((String)"Property pd1 should not be null", (Object)pd1);
        DAMLInstance d2 = m.getDAMLInstance(ns + "d2");
        DAMLTest.assertNotNull((String)"Instance d2 should not be null", (Object)d2);
        DAMLTest.assertTrue((String)"d2 should have d1 as a value for pd0", (boolean)d2.accessProperty((Property)pd0).hasValue((RDFNode)d1));
        DAMLProperty pd2 = m.getDAMLProperty(ns + "pd2");
        DAMLProperty pd3 = m.getDAMLProperty(ns + "pd3");
        DAMLTest.assertNotNull((String)"Property pd2 should not be null", (Object)pd2);
        DAMLTest.assertNotNull((String)"Property pd3 should not be null", (Object)pd3);
        DAMLTest.assertTrue((String)"d2 should have d1 as a value for pd3", (boolean)d2.accessProperty((Property)pd3).hasValue((RDFNode)d1));
        DAMLTest.assertTrue((String)"d2 should have d1 as a value for pd2", (boolean)d2.accessProperty((Property)pd2).hasValue((RDFNode)d1));
    }

    public void testProperty() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLProperty hasMother = m.getDAMLProperty(ns + "hasMother");
        DAMLTest.assertNotNull((String)"hasMother property should not be null", (Object)hasMother);
        DAMLTest.assertTrue((String)"hasMother property should be a unique property", (boolean)hasMother.isUnique());
        DAMLProperty hasParent = m.getDAMLProperty(ns + "hasParent");
        DAMLTest.assertNotNull((String)"hasParent property should not be null", (Object)hasParent);
        DAMLClass female = m.getDAMLClass(ns + "Female");
        DAMLTest.assertNotNull((String)"Class Female should not be null", (Object)female);
        DAMLClass animal = m.getDAMLClass(ns + "Animal");
        DAMLTest.assertNotNull((String)"Class Animal should not be null", (Object)animal);
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull((String)"Class Person should not be null", (Object)person);
        DAMLTest.assertTrue((String)"Mother should have Female as range", (boolean)hasMother.prop_range().hasValue((RDFNode)female));
        DAMLTest.assertTrue((String)"Mother should not have Animal as local domain (prop_domain)", (!hasMother.prop_domain().hasValue((RDFNode)animal) ? 1 : 0) != 0);
        DAMLObjectProperty hasAncestor = (DAMLObjectProperty)m.getDAMLProperty(ns + "hasAncestor").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull((String)"hasAncestor should not be null", (Object)hasAncestor);
        DAMLTest.assertTrue((String)"hasAncestor should be transitive", (boolean)hasAncestor.isTransitive());
        DAMLInstance peter = m.getDAMLInstance(ns + "Peter");
        DAMLTest.assertNotNull((String)"Instance Peter should not be null", (Object)peter);
        DAMLProperty shoesize = m.getDAMLProperty(ns + "shoesize");
        DAMLTest.assertNotNull((String)"Property shoesize should not be null", (Object)shoesize);
        PropertyAccessor paShoesize = peter.accessProperty((Property)shoesize);
        NodeIterator iShoes = paShoesize.getAll();
        DAMLTest.assertEquals((String)"iShoes iterator should have at least one value", (boolean)true, (boolean)iShoes.hasNext());
        Object size = iShoes.next();
        DAMLTest.assertNotNull((String)"size returned from property accessor iterator should not be null", size);
        DAMLTest.assertTrue((String)"size object should be a literal", (boolean)(size instanceof Literal));
        boolean nse = false;
        try {
            iShoes.next();
        }
        catch (NoSuchElementException ignore) {
            nse = true;
        }
        DAMLTest.assertEquals((String)"Accessing past end of property iterator should throw no such element exception", (boolean)true, (boolean)nse);
        NodeIterator iSubClassOf = person.prop_subClassOf().getAll();
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)iSubClassOf);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)iSubClassOf.hasNext());
        int nSupers = this.countIteration((Iterator)iSubClassOf, true, "direct super-class of Person = ");
        DAMLTest.assertEquals((String)"Should be 10 super-classes of Person", (int)10, (int)nSupers);
        DAMLClass male = m.getDAMLClass(ns + "Male");
        DAMLTest.assertNotNull((String)"Class Male should not be null", (Object)male);
        DAMLCommon femaleDisjoint = (DAMLCommon)female.prop_disjointWith().get();
        DAMLTest.assertNotNull((String)"Value for female.disjointWith should not be null", (Object)femaleDisjoint);
        DAMLTest.assertTrue((String)"female.disjointWith should be male", (boolean)male.equals(femaleDisjoint));
        m.getLoader().setLoadImportedOntologies(false);
        m.read("file:testing/ontology/daml/test-cases.daml", "http://dickinson-i-4/daml/tests/test-cases.daml", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        ns = "http://dickinson-i-4/daml/tests/test-cases.daml#";
        DAMLClass subClassCheck3 = (DAMLClass)m.getDAMLValue(ns + "subClassCheck3").as(DAMLClass.class);
        DAMLTest.assertNotNull((String)"Class subClassCheck3 should not be null", (Object)subClassCheck3);
        ExtendedIterator iSubClassOf3 = subClassCheck3.getSuperClasses(false);
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)iSubClassOf);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)iSubClassOf3.hasNext());
        nSupers = this.countIteration((Iterator)iSubClassOf3, true, "property access on subClassCheck3");
        DAMLTest.assertEquals((String)"Should be 1 non-closed super-classes of subClassCheck3", (int)1, (int)nSupers);
        iSubClassOf3 = subClassCheck3.getSuperClasses(true);
        DAMLTest.assertNotNull((String)"Iterator over subClassOf values should not be null", (Object)iSubClassOf);
        DAMLTest.assertTrue((String)"Iteration of subClassOf should have at least one value", (boolean)iSubClassOf3.hasNext());
        nSupers = this.countIteration((Iterator)iSubClassOf3, true, "property access on subClassCheck3 with closed = true ");
        DAMLTest.assertEquals((String)"Should be 3 closed super-classes of subClassCheck3", (int)3, (int)nSupers);
        DAMLProperty q = m.getDAMLProperty(ns + "q");
        DAMLTest.assertNotNull((String)"Property q should not be null", (Object)q);
        DAMLInstance qX = m.getDAMLInstance(ns + "qX");
        DAMLTest.assertNotNull((String)"Instance qX should not be null", (Object)qX);
        int nQ = qX.accessProperty((Property)q).count();
        DAMLTest.assertEquals((String)"There should be 1 values for q of qX (equivalence off)", (int)1, (int)nQ);
        DAMLObjectProperty tlPropTest = (DAMLObjectProperty)m.getDAMLProperty(ns + "TL_PropertyTest").as(DAMLObjectProperty.class);
        DAMLTest.assertNotNull((String)"Property should not be null", (Object)tlPropTest);
        NodeIterator tl_domains = tlPropTest.prop_domain().getAll();
        DAMLTest.assertEquals((String)"Property TL_PropertyTest should have a domain of two classes", (int)2, (int)this.countIteration((Iterator)tl_domains, false, null));
        NodeIterator tl_ranges = tlPropTest.prop_range().getAll();
        DAMLTest.assertEquals((String)"Property TL_PropertyTest should have a range of two classes", (int)2, (int)this.countIteration((Iterator)tl_ranges, false, null));
        DAMLClass humanBody = (DAMLClass)m.getDAMLValue(ns + "HumanBody").as(DAMLClass.class);
        DAMLTest.assertNotNull((String)"Class humanBody should not be null", (Object)humanBody);
        PropertyAccessor propUnion = humanBody.prop_unionOf();
        DAMLTest.assertNotNull((String)"Property accessor should not be null", (Object)propUnion);
        DAMLTest.assertEquals((String)"Should be two value in union", (int)1, (int)propUnion.count());
        DAMLCommon union = propUnion.getDAMLValue();
        DAMLTest.assertNotNull((String)"Union should not be null", (Object)union);
        DAMLTest.assertTrue((String)"Union value should be a list", (boolean)union.canAs(DAMLList.class));
        DAMLTest.assertEquals((String)"Should be two values in list", (int)2, (int)((DAMLList)union.as(DAMLList.class)).getCount());
    }

    public void testList() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull((String)"Person class should not be null", (Object)person);
        DAMLClass man = m.getDAMLClass(ns + "Man");
        DAMLTest.assertNotNull((String)"Man class should not be null", (Object)man);
        DAMLClass woman = m.getDAMLClass(ns + "Woman");
        DAMLTest.assertNotNull((String)"Woman class should not be null", (Object)woman);
        DAMLList union = (DAMLList)person.prop_disjointUnionOf().get().as(DAMLList.class);
        DAMLTest.assertNotNull((String)"union should not be null", (Object)union);
        DAMLTest.assertEquals((String)"union should have two values", (int)2, (int)union.getCount());
        RDFNode val1 = union.getFirst();
        DAMLTest.assertEquals((String)"Man should be the first element in the list", (Object)man, (Object)val1);
        DAMLList tail = union.getRest();
        DAMLTest.assertNotNull((String)"Tail of list should not be null", (Object)tail);
        RDFNode val2 = tail.getFirst();
        DAMLTest.assertNotNull((String)"head of tail should not be null", (Object)val2);
        DAMLTest.assertEquals((String)"Woman should be the first element in the tail of the list", (Object)woman, (Object)val2);
        DAMLList tail2 = tail.getRest();
        DAMLTest.assertNotNull((String)"Tail of tail should not be null", (Object)tail2);
        DAMLTest.assertTrue((String)"Remainder of list should be empty", (boolean)tail2.isEmpty());
        DAMLClass car = m.getDAMLClass(ns + "Car");
        DAMLTest.assertNotNull((String)"Class Car should not be null", (Object)car);
        union.add((RDFNode)car);
        DAMLTest.assertEquals((String)"Union should contain three elements", (int)3, (int)union.getCount());
    }

    public void testInstance() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLTest.assertEquals((String)"Number of instances should be 7", (int)7, (int)this.countIteration((Iterator)m.listDAMLInstances(), false, " instance = "));
        DAMLClass person = m.getDAMLClass(ns + "Person");
        DAMLTest.assertNotNull((String)"Person DAML class should not be null", (Object)person);
        int nPerson = this.countIteration((Iterator)person.getInstances(), true, "instance of person");
        DAMLTest.assertEquals((String)"There should be 4 instances of Person in the model", (int)4, (int)nPerson);
    }

    public void testDatatype() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLInstance ian = m.getDAMLInstance(ns + "Ian");
        DAMLTest.assertNotNull((String)"Instance Ian should not be null", (Object)ian);
        DAMLProperty shirtsize = m.getDAMLProperty(ns + "shirtsize");
        DAMLTest.assertNotNull((String)"Property shirtsize should not be null", (Object)shirtsize);
        DAMLProperty shoesize = m.getDAMLProperty(ns + "shoesize");
        DAMLTest.assertNotNull((String)"Property shoesize should not be null", (Object)shoesize);
        DAMLDataInstance sSize = (DAMLDataInstance)ian.getRequiredProperty((Property)shirtsize).getObject().as(DAMLDataInstance.class);
        DAMLTest.assertNotNull((String)"Object ian should have a shirtsize", (Object)sSize);
        Object x = sSize.getValue();
        DAMLTest.assertNotNull((String)"Value of shirtsize should not be null", (Object)x);
        DAMLTest.assertEquals((String)"Shirt size should be a string", (Object)String.class, x.getClass());
        DAMLTest.assertEquals((String)"Shirt size should be \"12\"", (Object)"12", (Object)x);
    }

    public void testDataInstance() {
        DAMLModel m = this.getCleanModel();
        DAMLDataInstance di = m.createDAMLDataInstance((Object)new Integer(9));
        DAMLTest.assertNotNull((String)"Failed to create data instance ", (Object)di);
        DAMLTest.assertEquals((String)"data instance URI not correct ", (Object)TypeMapper.getInstance().getTypeByName(XSD.xint.getURI()), (Object)di.getDatatype());
        String NS = "http://example.org/eg#";
        DAMLClass person = m.createDAMLClass(NS + "Person");
        DAMLInstance peter = m.createDAMLInstance(person, NS + "peter");
        DAMLDatatypeProperty p = m.createDAMLDatatypeProperty(NS + "shirtsize");
        peter.addProperty((Property)p, (RDFNode)di);
    }

    public void testRemove() {
        DAMLClass c;
        DAMLModel m = ModelFactory.createDAMLModel();
        m.getDocumentManager().setProcessImports(false);
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        ArrayList cache = new ArrayList();
        this.checkValidLists((Model)m, "baseline");
        ExtendedIterator i = m.listDAMLClasses();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLClass)cache.remove(0);
            log.debug((Object)("Removing class " + c));
            c.remove();
            this.checkValidLists((Model)m, "remove class");
        }
        i = m.listDAMLInstances();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLInstance)cache.remove(0);
            log.debug((Object)("Removing instance " + c));
            c.remove();
            this.checkValidLists((Model)m, "remove instance");
        }
        i = m.listDAMLProperties();
        while (i.hasNext()) {
            cache.add(i.next());
        }
        while (!cache.isEmpty()) {
            c = (DAMLProperty)cache.remove(0);
            log.debug((Object)("Removing property " + c));
            c.remove();
            this.checkValidLists((Model)m, "remove property");
        }
        boolean notBuiltin = false;
        ExtendedIterator i2 = m.listDAMLClasses();
        while (i2.hasNext()) {
            Resource x = (Resource)i2.next();
            if (x.equals(DAML_OIL.Thing) || x.equals(DAML_OIL.Nothing) || x.hasProperty(DAML_OIL.complementOf, (RDFNode)DAML_OIL.Nothing)) continue;
            log.debug((Object)("Unexpected class remains: " + x));
            StmtIterator j = x.listProperties();
            while (j.hasNext()) {
                log.debug((Object)(" ... has prop " + j.next()));
            }
            notBuiltin = true;
        }
        DAMLTest.assertFalse((String)"Should be no more classes", (boolean)notBuiltin);
        DAMLTest.assertFalse((String)"Should be no more properties", (boolean)m.listDAMLProperties().hasNext());
        DAMLTest.assertFalse((String)"Should be no more instances", (boolean)m.listDAMLInstances().hasNext());
    }

    public void testCreate() {
        DAMLModel m = this.getCleanModel();
        String cURI = "http://dickinson-i-4/daml/tests/gen#A";
        DAMLClass c = m.createDAMLClass(cURI);
        DAMLTest.assertNotNull((String)("Failed to create new DAML Class " + cURI), (Object)c);
        boolean found = false;
        ExtendedIterator i = m.listDAMLClasses();
        while (i.hasNext()) {
            if (!((DAMLClass)i.next()).equals(c)) continue;
            found = true;
        }
        DAMLTest.assertTrue((String)"Could not see class after it was created", (boolean)found);
        DAMLInstance x = (DAMLInstance)m.createDAMLValue("http://dickinson-i-4/daml/tests/gen#x", (Resource)c);
        DAMLTest.assertNotNull((String)"Failed to create new DAML instance", (Object)x);
        found = false;
        ExtendedIterator i2 = m.listDAMLInstances();
        while (i2.hasNext()) {
            if (!((DAMLInstance)i2.next()).equals(x)) continue;
            found = true;
        }
        DAMLTest.assertTrue((String)"Could not see instance after it was created", (boolean)found);
    }

    public void testRestriction() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/daml_oil_2001_03/daml+oil-ex.daml", "http://www.daml.org/2001/03/daml+oil-ex", null);
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        String ns = "http://www.daml.org/2001/03/daml+oil-ex#";
        DAMLClass person = m.getDAMLClass(ns + "Person");
        ExtendedIterator i = person.getSuperClasses();
        while (i.hasNext()) {
            DAMLRestriction restriction;
            PropertyAccessor onPropertyAccessor;
            int count;
            Resource r = (Resource)i.next();
            if (!(r instanceof DAMLRestriction) || (count = (onPropertyAccessor = (restriction = (DAMLRestriction)r).prop_onProperty()).count()) < 1) continue;
            RDFNode x = onPropertyAccessor.get();
            Object y = onPropertyAccessor.getAll().next();
            DAMLTest.assertNotNull((String)"Failed to access value of property accessor on restriction", (Object)x);
            DAMLTest.assertNotNull((String)"Failed to access value of property accessor on restriction", (Object)y);
        }
    }

    public void testModelAdd() {
        DAMLModel m = this.getCleanModel();
        m.read("file:testing/ontology/daml/test-add-0.daml");
        DAMLTest.assertTrue((String)"loadStatus should be true for successful load", (boolean)m.getLoadSuccessful());
        Model m0 = ModelFactory.createDefaultModel();
        m0.read("file:testing/ontology/daml/test-add-1.daml");
        DAMLTest.assertEquals((String)"Instance count in DAML model should be 0", (int)0, (int)this.countIteration((Iterator)m.listDAMLInstances(), true, "instance in test add"));
        m.add(m0);
        DAMLTest.assertEquals((String)"Instance count in DAML model should be 1", (int)1, (int)this.countIteration((Iterator)m.listDAMLInstances(), true, "instance in test add"));
    }

    public void testDatatypeProperty() {
        this.eqTest(new EqualityTest("DatatypeProperty"){

            String xml() {
                return "<daml:DatatypeProperty/>";
            }

            void java(DAMLModel m) {
                m.createDAMLDatatypeProperty(null);
            }
        });
    }

    public void testObjectProperty() {
        this.eqTest(new EqualityTest("ObjectProperty"){

            String xml() {
                return "<daml:ObjectProperty/>";
            }

            void java(DAMLModel m) {
                m.createDAMLObjectProperty(null);
            }
        });
    }

    public void testPropertyEq() {
        this.eqTest(new EqualityTest("Property"){

            String xml() {
                return "<daml:Property/>";
            }

            void java(DAMLModel m) {
                m.createDAMLProperty(null);
            }
        });
    }

    public void testDatatypeEq2() {
        this.eqTest(new EqualityTest("Datatype"){

            String xml() {
                return "<daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#string'/>";
            }

            void java(DAMLModel m) {
                m.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#string");
            }
        });
    }

    public void testDatatypeRange() {
        this.eqTest(new EqualityTest("Datatype Range"){

            String xml() {
                return "<daml:DatatypeProperty rdf:ID='shoesize'> <rdf:type rdf:resource='http://www.daml.org/2001/03/daml+oil#UniqueProperty'/> <daml:range rdf:resource='http://www.w3.org/2000/10/XMLSchema#decimal'/></daml:DatatypeProperty><daml:Datatype rdf:about='http://www.w3.org/2000/10/XMLSchema#decimal'/>";
            }

            void java(DAMLModel m) {
                DAMLDatatypeProperty shoeSize = m.createDAMLDatatypeProperty("http://example.org/#shoesize");
                shoeSize.setIsUnique(true);
                shoeSize.prop_range().add((RDFNode)m.createDAMLDatatype("http://www.w3.org/2000/10/XMLSchema#decimal"));
            }
        });
    }

    private void eqTest(EqualityTest test) {
        DAMLModel m1 = this.getCleanModel();
        test.java(m1);
        Model m2 = ModelFactory.createDefaultModel();
        StringReader rdr = new StringReader("<rdf:RDF xmlns:daml='http://www.daml.org/2001/03/daml+oil#' xmlns:rdf='http://www.w3.org/1999/02/22-rdf-syntax-ns#'>" + test.xml() + "</rdf:RDF>");
        m2.read((Reader)rdr, "http://example.org/");
        if (!m1.getBaseModel().isIsomorphicWith(m2)) {
            System.out.println("Java:");
            m1.write((OutputStream)System.out, "RDF/XML-ABBREV");
            System.out.println("XML:");
            m2.write((OutputStream)System.out, "RDF/XML-ABBREV");
        }
        DAMLTest.assertTrue((String)"java code and xml should be equivalent", (boolean)m1.getBaseModel().isIsomorphicWith(m2));
    }

    public void dumpModel(Model m) {
        this.dumpModel(m, "model-out.rdf");
    }

    public void dumpModel(Model m, String fileName) {
        try {
            FileOutputStream f = new FileOutputStream(fileName);
            m.write((OutputStream)f, "RDF/XML-ABBREV");
            ((OutputStream)f).close();
        }
        catch (Exception e) {
            LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("Exception while dumping model: " + e), (Throwable)e);
        }
    }

    private int countIteration(Iterator i, boolean doLog, String message) {
        int count = 0;
        while (i.hasNext()) {
            Object x = i.next();
            if (doLog) {
                LogFactory.getLog(((Object)((Object)this)).getClass()).debug((Object)("counting iteration, " + message + x));
            }
            ++count;
        }
        return count;
    }

    private int countClasses(DAMLModel m) {
        return this.countIteration((Iterator)m.listDAMLClasses(), true, "class = ");
    }

    private int countProperties(DAMLModel m) {
        return this.countIteration((Iterator)m.listDAMLProperties(), true, "property = ");
    }

    private DAMLModel getCleanModel() {
        DAMLModel m = ModelFactory.createDAMLModel();
        m.getDocumentManager().setProcessImports(true);
        m.getDocumentManager().clearCache();
        m.getDocumentManager().setMetadataSearchPath("file:etc/ont-policy-test.rdf", true);
        ArrayList ll = new ArrayList();
        Object i = m.getImportModelMaker().listModels();
        while (i.hasNext()) {
            ll.add(i.next());
        }
        i = ll.iterator();
        while (i.hasNext()) {
            String mName = (String)i.next();
            m.getImportModelMaker().removeModel(mName);
            log.debug((Object)("Removing " + mName));
        }
        return m;
    }

    private void checkValidLists(Model m, String label) {
        log.debug((Object)("Checking lists in DAMLTest - " + label));
        StmtIterator i = m.listStatements();
        while (i.hasNext()) {
            Statement s = i.nextStatement();
            RDFNode n = s.getObject();
            if (!(n instanceof Resource) || !((Resource)n).canAs(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList) || ((RDFList)n.as(class$com$hp$hpl$jena$rdf$model$RDFList == null ? DAMLTest.class$("com.hp.hpl.jena.rdf.model.RDFList") : class$com$hp$hpl$jena$rdf$model$RDFList)).isValid()) continue;
            log.debug((Object)("!!Found invalid list in " + label + " - " + n));
            DAMLTest.assertTrue((String)"DAML list not valid ", (boolean)false);
        }
    }

    private static abstract class EqualityTest {
        String name;

        EqualityTest(String nm) {
            this.name = nm;
        }

        public String toString() {
            return this.name;
        }

        abstract void java(DAMLModel var1);

        abstract String xml();
    }
}

