/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.zookeeper;

import com.hazelcast.cluster.Address;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.AbstractDiscoveryStrategy;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.SimpleDiscoveryNode;
import com.hazelcast.zookeeper.IOUtils;
import com.hazelcast.zookeeper.ZookeeperDiscoveryProperties;
import java.io.Closeable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.UriSpec;

public class ZookeeperDiscoveryStrategy
extends AbstractDiscoveryStrategy {
    private static final String DEFAULT_PATH = "/discovery/hazelcast";
    private static final String DEFAULT_GROUP = "hazelcast";
    private static final Duration CURATOR_BASE_SLEEP_TIME = Duration.ofSeconds(1L);
    private final DiscoveryNode thisNode;
    private final ILogger logger;
    private String group;
    private CuratorFramework client;
    private ServiceDiscovery<Void> serviceDiscovery;
    private ServiceInstance<Void> serviceInstance;

    public ZookeeperDiscoveryStrategy(DiscoveryNode discoveryNode, ILogger logger, Map<String, Comparable> properties) {
        super(logger, properties);
        this.thisNode = discoveryNode;
        this.logger = logger;
    }

    private boolean isMember() {
        return this.thisNode != null;
    }

    public void start() {
        this.startCuratorClient();
        this.group = (String)((Object)this.getOrDefault(ZookeeperDiscoveryProperties.GROUP, (Comparable)((Object)DEFAULT_GROUP)));
        try {
            String path = (String)((Object)this.getOrDefault(ZookeeperDiscoveryProperties.ZOOKEEPER_PATH, (Comparable)((Object)DEFAULT_PATH)));
            ServiceDiscoveryBuilder discoveryBuilder = ServiceDiscoveryBuilder.builder(Void.class).basePath(path).client(this.client);
            if (this.isMember()) {
                this.prepareServiceInstance();
                discoveryBuilder.thisInstance(this.serviceInstance);
            }
            this.serviceDiscovery = discoveryBuilder.build();
            this.serviceDiscovery.start();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper. ", e);
        }
    }

    private void prepareServiceInstance() throws Exception {
        Address privateAddress = this.thisNode.getPrivateAddress();
        this.serviceInstance = ServiceInstance.builder().uriSpec(new UriSpec("{scheme}://{address}:{port}")).address(privateAddress.getHost()).port(privateAddress.getPort()).name(this.group).build();
    }

    private void startCuratorClient() {
        String zookeeperUrl = (String)((Object)this.getOrNull(ZookeeperDiscoveryProperties.ZOOKEEPER_URL));
        if (zookeeperUrl == null) {
            throw new IllegalStateException("Zookeeper URL cannot be null.");
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Using " + zookeeperUrl + " as Zookeeper URL");
        }
        this.client = CuratorFrameworkFactory.newClient((String)zookeeperUrl, (RetryPolicy)new ExponentialBackoffRetry((int)CURATOR_BASE_SLEEP_TIME.toMillis(), 3));
        this.client.start();
    }

    public Iterable<DiscoveryNode> discoverNodes() {
        try {
            Collection members = this.serviceDiscovery.queryForInstances(this.group);
            ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>(members.size());
            for (ServiceInstance serviceInstance : members) {
                Address address = new Address(serviceInstance.getAddress(), serviceInstance.getPort().intValue());
                nodes.add((DiscoveryNode)new SimpleDiscoveryNode(address));
            }
            return nodes;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
    }

    public void destroy() {
        try {
            if (this.isMember() && this.serviceDiscovery != null) {
                this.serviceDiscovery.unregisterService(this.serviceInstance);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        catch (Exception e) {
            throw new IllegalStateException("Error while talking to ZooKeeper", e);
        }
        finally {
            IOUtils.closeSafely(this.serviceDiscovery);
            IOUtils.closeSafely((Closeable)this.client);
        }
    }
}

