/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.scan;

import com.hazelcast.function.ComparatorEx;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.jet.sql.impl.JetSqlSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.exec.scan.index.IndexFilter;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.extract.QueryPath;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.row.JetSqlRow;
import com.hazelcast.sql.impl.type.QueryDataType;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class MapIndexScanMetadata
implements IdentifiedDataSerializable {
    protected String mapName;
    protected String indexName;
    protected QueryTargetDescriptor keyDescriptor;
    protected QueryTargetDescriptor valueDescriptor;
    protected List<QueryPath> fieldPaths;
    protected List<QueryDataType> fieldTypes;
    protected List<Expression<?>> projection;
    protected Expression<Boolean> remainingFilter;
    protected IndexFilter filter;
    protected ComparatorEx<JetSqlRow> comparator;
    protected boolean descending;

    public MapIndexScanMetadata() {
    }

    public MapIndexScanMetadata(String mapName, String indexName, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, List<QueryPath> fieldPaths, List<QueryDataType> fieldTypes, IndexFilter filter, List<Expression<?>> projections, Expression<Boolean> remainingFilter, ComparatorEx<JetSqlRow> comparator, boolean descending) {
        this.mapName = mapName;
        this.indexName = indexName;
        this.keyDescriptor = keyDescriptor;
        this.valueDescriptor = valueDescriptor;
        this.fieldPaths = fieldPaths;
        this.fieldTypes = fieldTypes;
        this.projection = projections;
        this.remainingFilter = remainingFilter;
        this.filter = filter;
        this.comparator = comparator;
        this.descending = descending;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public QueryTargetDescriptor getKeyDescriptor() {
        return this.keyDescriptor;
    }

    public QueryTargetDescriptor getValueDescriptor() {
        return this.valueDescriptor;
    }

    public List<QueryPath> getFieldPaths() {
        return this.fieldPaths;
    }

    public List<QueryDataType> getFieldTypes() {
        return this.fieldTypes;
    }

    public List<Expression<?>> getProjection() {
        return this.projection;
    }

    public IndexFilter getFilter() {
        return this.filter;
    }

    public Expression<Boolean> getRemainingFilter() {
        return this.remainingFilter;
    }

    public ComparatorEx<JetSqlRow> getComparator() {
        return this.comparator;
    }

    public boolean isDescending() {
        return this.descending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MapIndexScanMetadata that = (MapIndexScanMetadata)o;
        return this.mapName.equals(that.mapName) && this.indexName.equals(that.indexName) && this.keyDescriptor.equals(that.keyDescriptor) && this.valueDescriptor.equals(that.valueDescriptor) && this.fieldPaths.equals(that.fieldPaths) && this.fieldTypes.equals(that.fieldTypes) && this.projection.equals(that.projection) && Objects.equals(this.remainingFilter, that.remainingFilter) && Objects.equals(this.filter, that.filter) && Objects.equals(this.comparator, that.comparator) && this.descending == that.descending;
    }

    public int hashCode() {
        return Objects.hash(this.mapName, this.indexName, this.keyDescriptor, this.valueDescriptor, this.fieldPaths, this.fieldTypes, this.projection, this.remainingFilter, this.filter, this.comparator, this.descending);
    }

    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeString(this.mapName);
        out.writeString(this.indexName);
        out.writeObject((Object)this.keyDescriptor);
        out.writeObject((Object)this.valueDescriptor);
        SerializationUtil.writeList(this.fieldPaths, (ObjectDataOutput)out);
        SerializationUtil.writeList(this.fieldTypes, (ObjectDataOutput)out);
        SerializationUtil.writeList(this.projection, (ObjectDataOutput)out);
        out.writeObject((Object)this.filter);
        out.writeObject(this.remainingFilter);
        out.writeObject(this.comparator);
        out.writeBoolean(this.descending);
    }

    public void readData(ObjectDataInput in) throws IOException {
        this.mapName = in.readString();
        this.indexName = in.readString();
        this.keyDescriptor = (QueryTargetDescriptor)in.readObject();
        this.valueDescriptor = (QueryTargetDescriptor)in.readObject();
        this.fieldPaths = SerializationUtil.readList((ObjectDataInput)in);
        this.fieldTypes = SerializationUtil.readList((ObjectDataInput)in);
        this.projection = SerializationUtil.readList((ObjectDataInput)in);
        this.filter = (IndexFilter)in.readObject();
        this.remainingFilter = (Expression)in.readObject();
        this.comparator = (ComparatorEx)in.readObject();
        this.descending = in.readBoolean();
    }

    public int getFactoryId() {
        return JetSqlSerializerHook.F_ID;
    }

    public int getClassId() {
        return 5;
    }
}

