/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json.filter;

import com.hazelcast.org.jsfr.json.PrimitiveHolder;
import com.hazelcast.org.jsfr.json.filter.BasicJsonPathFilter;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.org.jsfr.json.provider.JsonProvider;
import java.util.regex.Pattern;

public class MatchRegexPredicate
extends BasicJsonPathFilter {
    private final Pattern regex;

    public MatchRegexPredicate(JsonPath relativePath, Pattern regex) {
        super(relativePath);
        this.regex = regex;
    }

    @Override
    public boolean apply(JsonPath jsonPosition, PrimitiveHolder primitiveHolder, JsonProvider jsonProvider) {
        if (primitiveHolder != null && this.getRelativePath().matchFilterPath(jsonPosition)) {
            Object candidate = primitiveHolder.getValue();
            String string = jsonProvider.cast(candidate, String.class);
            if (string == null) {
                return false;
            }
            return this.regex.matcher(string).find();
        }
        return false;
    }
}

