/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json.filter;

import com.hazelcast.org.jsfr.json.PrimitiveHolder;
import com.hazelcast.org.jsfr.json.filter.BasicJsonPathFilter;
import com.hazelcast.org.jsfr.json.filter.Type;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.org.jsfr.json.provider.JsonProvider;

public class EqualityTypePredicate
extends BasicJsonPathFilter {
    private final Type type;

    public EqualityTypePredicate(JsonPath relativePath, Type type) {
        super(relativePath);
        this.type = type;
    }

    @Override
    public boolean apply(JsonPath jsonPosition, PrimitiveHolder primitiveHolder, JsonProvider jsonProvider) {
        if (!this.getRelativePath().matchFilterPath(jsonPosition)) {
            return false;
        }
        switch (this.type) {
            case ARRAY: {
                return primitiveHolder == null && jsonPosition.isInsideArray();
            }
            case OBJECT: {
                return primitiveHolder == null && jsonPosition.isInsideObject();
            }
        }
        return primitiveHolder != null && this.getRelativePath().isInsideArray() == jsonPosition.isInsideArray() && this.type.isInstanceOf(primitiveHolder.getValue(), jsonProvider);
    }
}

