/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json;

import com.hazelcast.org.jsfr.json.ErrorHandlingStrategy;
import com.hazelcast.org.jsfr.json.JsonPathListener;
import com.hazelcast.org.jsfr.json.JsonSurfer;
import com.hazelcast.org.jsfr.json.ParsingContext;
import com.hazelcast.org.jsfr.json.TypedJsonPathListener;
import com.hazelcast.org.jsfr.json.compiler.JsonPathCompiler;
import com.hazelcast.org.jsfr.json.filter.JsonPathFilter;
import com.hazelcast.org.jsfr.json.path.FilterableChildNode;
import com.hazelcast.org.jsfr.json.path.JsonPath;
import com.hazelcast.org.jsfr.json.path.PathOperator;
import com.hazelcast.org.jsfr.json.provider.JsonProvider;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class SurfingConfiguration {
    private Charset parserCharset;
    private int minDepth = Integer.MAX_VALUE;
    private int maxDepth = -1;
    private boolean skipOverlappedPath;
    private boolean hasFilter;
    private boolean closeParserOnStop = true;
    private Binding[][] definitePathLookup;
    private IndefinitePathBinding[] indefinitePathLookup = new IndefinitePathBinding[0];
    private JsonProvider jsonProvider;
    private ErrorHandlingStrategy errorHandlingStrategy;

    public static Collection<FilterConfig> getFilterConfigs(JsonPath path) {
        ArrayList<FilterConfig> filterConfigs = new ArrayList<FilterConfig>();
        for (int i = 0; i < path.pathDepth(); ++i) {
            FilterableChildNode nodeWithFilter;
            PathOperator operator = path.get(i);
            if (!(operator instanceof FilterableChildNode) || (nodeWithFilter = (FilterableChildNode)operator).getJsonPathFilter() == null) continue;
            FilterConfig fc = new FilterConfig();
            fc.filter = nodeWithFilter.getJsonPathFilter();
            fc.filterRootPath = path.derivePath(i + 1);
            filterConfigs.add(fc);
        }
        return filterConfigs;
    }

    public static Builder builder() {
        Builder builder = new Builder();
        builder.configuration = new SurfingConfiguration();
        return builder;
    }

    public int getMinDepth() {
        return this.minDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public boolean isSkipOverlappedPath() {
        return this.skipOverlappedPath;
    }

    public boolean hasDefinitePath() {
        return this.definitePathLookup != null;
    }

    public IndefinitePathBinding[] getIndefinitePathLookup() {
        return this.indefinitePathLookup;
    }

    public JsonProvider getJsonProvider() {
        return this.jsonProvider;
    }

    public void setJsonProvider(JsonProvider jsonProvider) {
        this.jsonProvider = jsonProvider;
    }

    public ErrorHandlingStrategy getErrorHandlingStrategy() {
        return this.errorHandlingStrategy;
    }

    void setErrorHandlingStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
        this.errorHandlingStrategy = errorHandlingStrategy;
    }

    private boolean withinRange(int currentDepth) {
        return this.minDepth <= currentDepth && currentDepth <= this.maxDepth;
    }

    public Binding[] getDefinitePathBind(int currentDepth) {
        if (this.definitePathLookup != null && this.withinRange(currentDepth)) {
            return this.definitePathLookup[currentDepth - this.minDepth];
        }
        return null;
    }

    public Binding[][] getDefinitePathBindings() {
        return this.definitePathLookup;
    }

    public Charset getParserCharset() {
        return this.parserCharset;
    }

    public void setParserCharset(Charset parserCharset) {
        this.parserCharset = parserCharset;
    }

    public boolean hasFilter() {
        return this.hasFilter;
    }

    public void setCloseParserOnStop(boolean closeParserOnStop) {
        this.closeParserOnStop = closeParserOnStop;
    }

    public boolean isCloseParserOnStop() {
        return this.closeParserOnStop;
    }

    static /* synthetic */ IndefinitePathBinding[] access$102(SurfingConfiguration x0, IndefinitePathBinding[] x1) {
        x0.indefinitePathLookup = x1;
        return x1;
    }

    static /* synthetic */ Binding[][] access$202(SurfingConfiguration x0, Binding[][] x1) {
        x0.definitePathLookup = x1;
        return x1;
    }

    public static class Builder {
        private static final Comparator<IndefinitePathBinding> INDEFINITE_BINDING_COMPARATOR = Comparator.comparingInt(o -> o.minimumPathDepth);
        private JsonSurfer jsonSurfer;
        private SurfingConfiguration configuration;
        private final Map<Integer, ArrayList<Binding>> definiteBindings = new HashMap<Integer, ArrayList<Binding>>();
        private final ArrayList<IndefinitePathBinding> indefiniteBindings = new ArrayList();
        private boolean hasFilter;

        public SurfingConfiguration build() {
            if (!this.indefiniteBindings.isEmpty()) {
                this.indefiniteBindings.sort(INDEFINITE_BINDING_COMPARATOR);
                SurfingConfiguration.access$102(this.configuration, this.indefiniteBindings.toArray(new IndefinitePathBinding[0]));
            }
            if (!this.definiteBindings.isEmpty()) {
                SurfingConfiguration.access$202(this.configuration, new Binding[this.configuration.maxDepth - this.configuration.minDepth + 1][]);
                for (Map.Entry<Integer, ArrayList<Binding>> entry : this.definiteBindings.entrySet()) {
                    ((SurfingConfiguration)this.configuration).definitePathLookup[entry.getKey().intValue() - ((SurfingConfiguration)this.configuration).minDepth] = entry.getValue().toArray(new Binding[0]);
                }
            }
            this.configuration.hasFilter = this.hasFilter;
            return this.configuration;
        }

        public Builder withCharset(Charset charset) {
            this.configuration.parserCharset = charset;
            return this;
        }

        public Builder withSurfer(JsonSurfer jsonSurfer) {
            this.jsonSurfer = jsonSurfer;
            return this;
        }

        public void buildAndSurf(String json) {
            this.jsonSurfer.surf(json, this.build());
        }

        @Deprecated
        public void buildAndSurf(Reader jsonReader) {
            this.jsonSurfer.surf(jsonReader, this.build());
        }

        public void buildAndSurf(InputStream inputStream) {
            this.jsonSurfer.surf(inputStream, this.build());
        }

        public Builder bind(String path, JsonPathListener ... jsonPathListeners) {
            return this.bind(JsonPathCompiler.compile(path), jsonPathListeners);
        }

        public Builder bind(JsonPath.Builder builder, JsonPathListener ... jsonPathListeners) {
            return this.bind(builder.build(), jsonPathListeners);
        }

        public <T> Builder bind(String jsonPath, Class<T> tClass, TypedJsonPathListener<T> ... typedListeners) {
            this.bind(JsonPathCompiler.compile(jsonPath), tClass, typedListeners);
            return this;
        }

        public <T> Builder bind(JsonPath jsonPath, final Class<T> tClass, TypedJsonPathListener<T> ... typedListeners) {
            JsonPathListener[] listeners = new JsonPathListener[typedListeners.length];
            int i = 0;
            for (final TypedJsonPathListener<T> typedListener : typedListeners) {
                listeners[i++] = new JsonPathListener(){

                    @Override
                    public void onValue(Object value, ParsingContext parsingContext) {
                        typedListener.onTypedValue(configuration.jsonProvider.cast(value, tClass), parsingContext);
                    }
                };
            }
            this.bind(jsonPath, listeners);
            return this;
        }

        private ArrayList<Binding> getDefiniteBindings(int depth) {
            ArrayList<Binding> bindings = this.definiteBindings.get(depth);
            if (bindings == null) {
                bindings = new ArrayList();
                this.definiteBindings.put(depth, bindings);
            }
            return bindings;
        }

        private void updateMinMaxDepth(int depth) {
            if (depth > this.configuration.maxDepth) {
                this.configuration.maxDepth = depth;
            }
            if (depth < this.configuration.minDepth) {
                this.configuration.minDepth = depth;
            }
        }

        public Builder bind(JsonPath jsonPath, JsonPathListener ... jsonPathListeners) {
            Collection<FilterConfig> filterConfigs = SurfingConfiguration.getFilterConfigs(jsonPath);
            if (!filterConfigs.isEmpty()) {
                this.hasFilter = true;
            }
            Binding previous = null;
            for (FilterConfig fc : filterConfigs) {
                Binding filterBiding;
                if (fc.filterRootPath.checkDefinite()) {
                    ArrayList<Binding> bindings = this.getDefiniteBindings(fc.filterRootPath.pathDepth());
                    filterBiding = new Binding(fc.filterRootPath, null);
                    filterBiding.filter = fc.filter;
                    filterBiding.dependency = previous;
                    bindings.add(filterBiding);
                    this.updateMinMaxDepth(fc.filterRootPath.pathDepth());
                    previous = filterBiding;
                    continue;
                }
                int minimumDepth = JsonPath.minimumPathDepth(fc.filterRootPath);
                filterBiding = new IndefinitePathBinding(fc.filterRootPath, null, minimumDepth);
                filterBiding.filter = fc.filter;
                filterBiding.dependency = previous;
                this.indefiniteBindings.add((IndefinitePathBinding)filterBiding);
                previous = filterBiding;
            }
            if (!jsonPath.isDefinite()) {
                int minimumDepth = JsonPath.minimumPathDepth(jsonPath);
                IndefinitePathBinding binding = new IndefinitePathBinding(jsonPath, jsonPathListeners, minimumDepth);
                binding.dependency = previous;
                this.indefiniteBindings.add(binding);
            } else {
                int depth = jsonPath.pathDepth();
                this.updateMinMaxDepth(depth);
                ArrayList<Binding> bindings = this.getDefiniteBindings(depth);
                Binding binding = new Binding(jsonPath, jsonPathListeners);
                binding.dependency = previous;
                bindings.add(binding);
            }
            return this;
        }

        public Builder skipOverlappedPath() {
            this.configuration.skipOverlappedPath = true;
            return this;
        }

        public Builder withJsonProvider(JsonProvider provider) {
            this.configuration.jsonProvider = provider;
            return this;
        }

        public Builder withErrorStrategy(ErrorHandlingStrategy errorHandlingStrategy) {
            this.configuration.errorHandlingStrategy = errorHandlingStrategy;
            return this;
        }
    }

    public static class IndefinitePathBinding
    extends Binding {
        int minimumPathDepth;

        IndefinitePathBinding(JsonPath jsonPath, JsonPathListener[] listeners, int minimumPathDepth) {
            super(jsonPath, listeners);
            this.minimumPathDepth = minimumPathDepth;
        }
    }

    public static class Binding {
        JsonPath jsonPath;
        JsonPathFilter filter;
        Binding dependency;
        JsonPathListener[] listeners;

        Binding(JsonPath jsonPath, JsonPathListener[] listeners) {
            this.jsonPath = jsonPath;
            this.listeners = listeners;
        }

        JsonPathListener[] getListeners() {
            return this.listeners;
        }
    }

    public static class FilterConfig {
        JsonPath filterRootPath;
        JsonPathFilter filter;
    }
}

