/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.jsfr.json;

import com.hazelcast.org.jsfr.json.JsonSaxHandler;
import com.hazelcast.org.jsfr.json.PrimitiveHolder;
import java.util.Iterator;
import java.util.LinkedList;

class ContentDispatcher
implements JsonSaxHandler {
    private final LinkedList<JsonSaxHandler> receiver = new LinkedList();

    ContentDispatcher() {
    }

    public boolean isEmpty() {
        return this.receiver.isEmpty();
    }

    public int size() {
        return this.receiver.size();
    }

    @Override
    public boolean startJSON() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        for (JsonSaxHandler observer : this.receiver) {
            observer.startJSON();
        }
        return true;
    }

    @Override
    public boolean endJSON() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        for (JsonSaxHandler observer : this.receiver) {
            observer.endJSON();
        }
        return true;
    }

    @Override
    public boolean startObject() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.startObject()) continue;
            itr.remove();
        }
        return true;
    }

    @Override
    public boolean endObject() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.endObject()) continue;
            itr.remove();
        }
        return true;
    }

    @Override
    public boolean startObjectEntry(String key) {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.startObjectEntry(key)) continue;
            itr.remove();
        }
        return true;
    }

    @Override
    public boolean startArray() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.startArray()) continue;
            itr.remove();
        }
        return true;
    }

    @Override
    public boolean endArray() {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.endArray()) continue;
            itr.remove();
        }
        return true;
    }

    @Override
    public boolean primitive(PrimitiveHolder primitiveHolder) {
        if (this.receiver.isEmpty()) {
            return true;
        }
        Iterator itr = this.receiver.iterator();
        while (itr.hasNext()) {
            JsonSaxHandler observer = (JsonSaxHandler)itr.next();
            if (observer.primitive(primitiveHolder)) continue;
            itr.remove();
        }
        return true;
    }

    public void addReceiver(JsonSaxHandler contentHandler) {
        this.receiver.addFirst(contentHandler);
    }
}

