/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.codehaus.commons.compiler.util;

import com.hazelcast.org.codehaus.commons.compiler.util.SystemProperties;
import com.hazelcast.org.codehaus.commons.nullanalysis.Nullable;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public final class Disassembler {
    @Nullable
    private static Object disassemblerInstance;

    private Disassembler() {
    }

    public static void disassembleToStdout(byte[] contents) {
        Object d = disassemblerInstance;
        if (d == null) {
            return;
        }
        try {
            for (String attributeName : new String[]{"verbose", "showClassPoolIndexes", "dumpConstantPool", "printAllAttributes", "printStackMap", "showLineNumbers", "showVariableNames", "symbolicLabels", "printAllOffsets"}) {
                String pv = SystemProperties.getClassProperty(Disassembler.class, attributeName);
                if (pv == null) continue;
                boolean argument = Boolean.parseBoolean(pv);
                String setterMethodName = "set" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
                d.getClass().getMethod(setterMethodName, Boolean.TYPE).invoke(d, argument);
            }
            d.getClass().getMethod("disasm", InputStream.class).invoke(d, new ByteArrayInputStream(contents));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        Class<?> disassemblerClass;
        try {
            disassemblerClass = Class.forName("de.unkrig.jdisasm.Disassembler");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Notice: Could not disassemble class file for logging because \"de.unkrig.jdisasm.Disassembler\" is not on the classpath. If you are interested in disassemblies of class files generated by JANINO, get de.unkrig.jdisasm and put it on the classpath.");
            disassemblerClass = null;
        }
        if (disassemblerClass != null) {
            try {
                disassemblerInstance = disassemblerClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

