/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util.graph;

import com.hazelcast.com.google.common.collect.Ordering;
import com.hazelcast.org.apache.calcite.linq4j.Nullness;
import com.hazelcast.org.apache.calcite.util.graph.DefaultEdge;
import com.hazelcast.org.apache.calcite.util.graph.DirectedGraph;
import com.hazelcast.org.checkerframework.checker.initialization.qual.NotOnlyInitialized;
import com.hazelcast.org.checkerframework.checker.initialization.qual.UnknownInitialization;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apiguardian.api.API;

public class DefaultDirectedGraph<V, E extends DefaultEdge>
implements DirectedGraph<V, E> {
    final Set<E> edges = new LinkedHashSet();
    final Map<V, VertexInfo<V, E>> vertexMap = new LinkedHashMap<V, VertexInfo<V, E>>();
    @NotOnlyInitialized
    final DirectedGraph.EdgeFactory<V, E> edgeFactory;

    public DefaultDirectedGraph(@UnknownInitialization DirectedGraph.EdgeFactory<V, E> edgeFactory) {
        this.edgeFactory = edgeFactory;
    }

    public static <V> DefaultDirectedGraph<V, DefaultEdge> create() {
        return DefaultDirectedGraph.create(DefaultEdge.factory());
    }

    public static <V, E extends DefaultEdge> DefaultDirectedGraph<V, E> create(DirectedGraph.EdgeFactory<V, E> edgeFactory) {
        return new DefaultDirectedGraph<V, E>(edgeFactory);
    }

    public String toStringUnordered() {
        return "graph(vertices: " + this.vertexMap.keySet() + ", edges: " + this.edges + ")";
    }

    public String toString() {
        Ordering<Object> vertexOrdering = Ordering.usingToString();
        Ordering<Object> edgeOrdering = Ordering.usingToString();
        return this.toString(vertexOrdering, edgeOrdering);
    }

    private String toString(Ordering<V> vertexOrdering, Ordering<E> edgeOrdering) {
        return "graph(vertices: " + vertexOrdering.sortedCopy(this.vertexMap.keySet()) + ", edges: " + edgeOrdering.sortedCopy(this.edges) + ")";
    }

    @Override
    public boolean addVertex(V vertex) {
        if (this.vertexMap.containsKey(vertex)) {
            return false;
        }
        this.vertexMap.put(vertex, new VertexInfo());
        return true;
    }

    @API(since="1.26", status=API.Status.EXPERIMENTAL)
    protected final VertexInfo<V, E> getVertex(V vertex) {
        VertexInfo<V, E> info = this.vertexMap.get(vertex);
        if (info == null) {
            throw new IllegalArgumentException("no vertex " + vertex);
        }
        return info;
    }

    @Override
    public Set<E> edgeSet() {
        return Collections.unmodifiableSet(this.edges);
    }

    @Override
    public @Nullable E addEdge(V vertex, V targetVertex) {
        VertexInfo<V, E> info = this.getVertex(vertex);
        VertexInfo<V, E> targetInfo = this.getVertex(targetVertex);
        DefaultEdge edge = (DefaultEdge)this.edgeFactory.createEdge(vertex, targetVertex);
        if (this.edges.add(edge)) {
            info.outEdges.add(edge);
            targetInfo.inEdges.add(edge);
            return (E)edge;
        }
        return null;
    }

    @Override
    public @Nullable E getEdge(V source, V target) {
        VertexInfo<V, E> info = this.getVertex(source);
        for (DefaultEdge outEdge : info.outEdges) {
            if (!outEdge.target.equals(target)) continue;
            return (E)outEdge;
        }
        return null;
    }

    @Override
    public boolean removeEdge(V source, V target) {
        List outEdges = this.getVertex(source).outEdges;
        boolean outRemoved = false;
        int size = outEdges.size();
        for (int i = 0; i < size; ++i) {
            DefaultEdge edge = (DefaultEdge)outEdges.get(i);
            if (!edge.target.equals(target)) continue;
            outEdges.remove(i);
            this.edges.remove(edge);
            outRemoved = true;
            break;
        }
        List inEdges = this.getVertex(target).inEdges;
        boolean inRemoved = false;
        int size2 = inEdges.size();
        for (int i = 0; i < size2; ++i) {
            DefaultEdge edge = (DefaultEdge)inEdges.get(i);
            if (!edge.source.equals(source)) continue;
            inEdges.remove(i);
            inRemoved = true;
            break;
        }
        assert (outRemoved == inRemoved);
        return outRemoved;
    }

    @Override
    public Set<V> vertexSet() {
        return this.vertexMap.keySet();
    }

    @Override
    public void removeAllVertices(Collection<V> collection) {
        float threshold = 0.35f;
        int thresholdSize = (int)((float)this.vertexMap.size() * 0.35f);
        if (collection.size() > thresholdSize && !(collection instanceof Set)) {
            collection = new HashSet<V>(collection);
        }
        if (collection.size() > thresholdSize) {
            this.removeMajorityVertices((Set)collection);
        } else {
            this.removeMinorityVertices(collection);
        }
        for (Object v : collection) {
            this.edges.removeIf(e -> e.source.equals(v) || e.target.equals(v));
        }
    }

    private void removeMinorityVertices(Collection<V> collection) {
        for (Object v : collection) {
            VertexInfo<V, E> info = this.vertexMap.get(v);
            if (info == null) continue;
            for (DefaultEdge edge : info.inEdges) {
                Object source = edge.source;
                VertexInfo<Object, E> sourceInfo = this.getVertex(source);
                sourceInfo.outEdges.removeIf(e -> e.target.equals(v));
            }
            for (DefaultEdge edge : info.outEdges) {
                Object target = edge.target;
                VertexInfo<Object, E> targetInfo = this.getVertex(target);
                targetInfo.inEdges.removeIf(e -> e.source.equals(v));
            }
        }
        this.vertexMap.keySet().removeAll(collection);
    }

    private void removeMajorityVertices(Set<V> vertexSet) {
        this.vertexMap.keySet().removeAll(vertexSet);
        for (VertexInfo<V, E> info : this.vertexMap.values()) {
            info.outEdges.removeIf(e -> vertexSet.contains(Nullness.castNonNull(e.target)));
            info.inEdges.removeIf(e -> vertexSet.contains(Nullness.castNonNull(e.source)));
        }
    }

    @Override
    public List<E> getOutwardEdges(V source) {
        return this.getVertex(source).outEdges;
    }

    @Override
    public List<E> getInwardEdges(V target) {
        return this.getVertex(target).inEdges;
    }

    final V source(E edge) {
        return (V)((DefaultEdge)edge).source;
    }

    final V target(E edge) {
        return (V)((DefaultEdge)edge).target;
    }

    static class VertexInfo<V, E> {
        final List<E> outEdges = new ArrayList();
        final List<E> inEdges = new ArrayList();

        VertexInfo() {
        }
    }
}

