/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.com.google.common.collect.ImmutableList;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Template
extends MessageFormat {
    private final List<String> parameterNames;

    public static Template of(String pattern) {
        return Template.of(pattern, Locale.getDefault());
    }

    public static Template of(String pattern, Locale locale) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        String processedPattern = Template.process(pattern, parameterNames);
        return new Template(processedPattern, parameterNames, locale);
    }

    private Template(String pattern, List<String> parameterNames, Locale locale) {
        super(pattern, locale);
        this.parameterNames = ImmutableList.copyOf(parameterNames);
    }

    private static String process(String pattern, List<String> parameterNames) {
        StringBuilder[] segments = new StringBuilder[4];
        for (int i = 0; i < segments.length; ++i) {
            segments[i] = new StringBuilder();
        }
        int part = 0;
        boolean inQuote = false;
        int braceStack = 0;
        block7: for (int i = 0; i < pattern.length(); ++i) {
            char ch = pattern.charAt(i);
            if (part == 0) {
                if (ch == '\'') {
                    segments[part].append(ch);
                    if (i + 1 < pattern.length() && pattern.charAt(i + 1) == '\'') {
                        segments[part].append(ch);
                        ++i;
                        continue;
                    }
                    inQuote = !inQuote;
                    continue;
                }
                if (ch == '{' && !inQuote) {
                    part = 1;
                    continue;
                }
                segments[part].append(ch);
                continue;
            }
            if (inQuote) {
                segments[part].append(ch);
                if (ch != '\'') continue;
                inQuote = false;
                continue;
            }
            switch (ch) {
                case ',': {
                    if (part < 3) {
                        ++part;
                        continue block7;
                    }
                    segments[part].append(ch);
                    continue block7;
                }
                case '{': {
                    ++braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '}': {
                    if (braceStack == 0) {
                        part = 0;
                        Template.makeFormat(segments, parameterNames);
                        continue block7;
                    }
                    --braceStack;
                    segments[part].append(ch);
                    continue block7;
                }
                case '\'': {
                    inQuote = true;
                }
                default: {
                    segments[part].append(ch);
                }
            }
        }
        if (braceStack == 0 && part != 0) {
            throw new IllegalArgumentException("Unmatched braces in the pattern.");
        }
        return segments[0].toString();
    }

    private static void makeFormat(StringBuilder[] segments, List<String> parameterNames) {
        String three;
        String parameterName = segments[1].toString();
        int parameterOrdinal = parameterNames.size();
        parameterNames.add(parameterName);
        segments[0].append("{");
        segments[0].append(parameterOrdinal);
        String two = segments[2].toString();
        if (two.length() > 0) {
            segments[0].append(",").append(two);
        }
        if ((three = segments[3].toString()).length() > 0) {
            segments[0].append(",").append(three);
        }
        segments[0].append("}");
        segments[1].setLength(0);
        segments[2].setLength(0);
        segments[3].setLength(0);
    }

    public String format(Map<Object, Object> argMap) {
        @Nullable Object[] args = new Object[this.parameterNames.size()];
        for (int i = 0; i < this.parameterNames.size(); ++i) {
            args[i] = this.getArg(argMap, i);
        }
        return this.format(args);
    }

    private @Nullable Object getArg(Map<Object, Object> argMap, int ordinal) {
        String parameterName = this.parameterNames.get(ordinal);
        Object arg = argMap.get(parameterName);
        if (arg != null) {
            return arg;
        }
        arg = argMap.get(ordinal);
        if (arg != null) {
            return arg;
        }
        return argMap.get(ordinal + "");
    }

    public static String formatByName(String pattern, Map<Object, Object> argMap) {
        return Template.of(pattern).format(argMap);
    }

    public List<String> getParameterNames() {
        return this.parameterNames;
    }
}

