/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.util;

import com.hazelcast.com.google.common.collect.ImmutableSortedMap;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.ImmutableIntList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public final class BitSets {
    private BitSets() {
        throw new AssertionError((Object)"no instances!");
    }

    public static boolean contains(BitSet set0, BitSet set1) {
        int i = set1.nextSetBit(0);
        while (i >= 0) {
            if (!set0.get(i)) {
                return false;
            }
            i = set1.nextSetBit(i + 1);
        }
        return true;
    }

    public static boolean contains(BitSet set0, ImmutableBitSet set1) {
        int i = set1.nextSetBit(0);
        while (i >= 0) {
            if (!set0.get(i)) {
                return false;
            }
            i = set1.nextSetBit(i + 1);
        }
        return true;
    }

    public static Iterable<Integer> toIter(final BitSet bitSet) {
        return () -> new Iterator<Integer>(){
            int i;
            {
                this.i = bitSet.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.i >= 0;
            }

            @Override
            public Integer next() {
                int prev = this.i;
                this.i = bitSet.nextSetBit(this.i + 1);
                return prev;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static Iterable<Integer> toIter(ImmutableBitSet bitSet) {
        return bitSet;
    }

    public static List<Integer> toList(BitSet bitSet) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            list.add(i);
            i = bitSet.nextSetBit(i + 1);
        }
        return list;
    }

    public static int[] toArray(BitSet bitSet) {
        int[] integers = new int[bitSet.cardinality()];
        int j = 0;
        int i = bitSet.nextSetBit(0);
        while (i >= 0) {
            integers[j++] = i;
            i = bitSet.nextSetBit(i + 1);
        }
        return integers;
    }

    public static BitSet of(int ... bits) {
        BitSet bitSet = new BitSet();
        for (int bit : bits) {
            bitSet.set(bit);
        }
        return bitSet;
    }

    public static BitSet of(Integer[] bits) {
        BitSet bitSet = new BitSet();
        Integer[] integerArray = bits;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int bit = integerArray[i];
            bitSet.set(bit);
        }
        return bitSet;
    }

    public static BitSet of(Iterable<? extends Number> bits) {
        BitSet bitSet = new BitSet();
        for (Number number : bits) {
            bitSet.set(number.intValue());
        }
        return bitSet;
    }

    public static BitSet of(ImmutableIntList bits) {
        BitSet bitSet = new BitSet();
        int n = bits.size();
        for (int i = 0; i < n; ++i) {
            bitSet.set(bits.getInt(i));
        }
        return bitSet;
    }

    public static BitSet range(int fromIndex, int toIndex) {
        BitSet bitSet = new BitSet();
        if (toIndex > fromIndex) {
            bitSet.set(fromIndex, toIndex);
        }
        return bitSet;
    }

    public static BitSet range(int toIndex) {
        return BitSets.range(0, toIndex);
    }

    public static void setAll(BitSet bitSet, Iterable<? extends Number> list) {
        for (Number number : list) {
            bitSet.set(number.intValue());
        }
    }

    public static BitSet union(BitSet set0, BitSet ... sets) {
        BitSet s2 = (BitSet)set0.clone();
        for (BitSet set : sets) {
            s2.or(set);
        }
        return s2;
    }

    public static int previousClearBit(BitSet bitSet, int fromIndex) {
        if (fromIndex < -1) {
            throw new IndexOutOfBoundsException();
        }
        while (fromIndex >= 0) {
            if (!bitSet.get(fromIndex)) {
                return fromIndex;
            }
            --fromIndex;
        }
        return -1;
    }

    public static SortedMap<Integer, BitSet> closure(SortedMap<Integer, BitSet> equivalence) {
        if (equivalence.isEmpty()) {
            return ImmutableSortedMap.of();
        }
        int length = equivalence.lastKey();
        for (BitSet bitSet : equivalence.values()) {
            length = Math.max(length, bitSet.length());
        }
        if (equivalence.size() < length || equivalence.firstKey() != 0) {
            SortedMap<Integer, BitSet> old = equivalence;
            equivalence = new TreeMap<Integer, BitSet>();
            for (int i = 0; i < length; ++i) {
                BitSet bitSet = (BitSet)old.get(i);
                equivalence.put(i, bitSet == null ? new BitSet() : bitSet);
            }
        }
        Closure closure = new Closure(equivalence);
        return closure.closure;
    }

    public static void populate(BitSet bitSet, Iterable<? extends Number> list) {
        for (Number number : list) {
            bitSet.set(number.intValue());
        }
    }

    public static void populate(BitSet bitSet, ImmutableIntList list) {
        for (int i = 0; i < list.size(); ++i) {
            bitSet.set(list.getInt(i));
        }
    }

    private static class Closure {
        private SortedMap<Integer, BitSet> equivalence;
        private final NavigableMap<Integer, BitSet> closure = new TreeMap<Integer, BitSet>();

        Closure(SortedMap<Integer, BitSet> equivalence) {
            this.equivalence = equivalence;
            ImmutableIntList keys = ImmutableIntList.copyOf(equivalence.keySet());
            for (int pos : keys) {
                this.computeClosure(pos);
            }
        }

        private BitSet computeClosure(int pos) {
            BitSet o = (BitSet)this.closure.get(pos);
            if (o != null) {
                return o;
            }
            BitSet b = (BitSet)Objects.requireNonNull(this.equivalence.get(pos), () -> "equivalence.get(pos) for " + pos);
            o = (BitSet)b.clone();
            int i = b.nextSetBit(pos + 1);
            while (i >= 0) {
                o.or(this.computeClosure(i));
                i = b.nextSetBit(i + 1);
            }
            this.closure.put(pos, o);
            i = o.nextSetBit(pos + 1);
            while (i >= 0) {
                this.closure.put(i, o);
                i = b.nextSetBit(i + 1);
            }
            return o;
        }
    }
}

