/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.apache.calcite.sql2rel;

import com.hazelcast.com.google.common.collect.Lists;
import com.hazelcast.com.google.common.collect.SortedSetMultimap;
import com.hazelcast.org.apache.calcite.linq4j.Ord;
import com.hazelcast.org.apache.calcite.plan.RelOptCluster;
import com.hazelcast.org.apache.calcite.plan.RelOptTable;
import com.hazelcast.org.apache.calcite.plan.RelOptUtil;
import com.hazelcast.org.apache.calcite.plan.RelTraitSet;
import com.hazelcast.org.apache.calcite.rel.RelCollation;
import com.hazelcast.org.apache.calcite.rel.RelFieldCollation;
import com.hazelcast.org.apache.calcite.rel.RelNode;
import com.hazelcast.org.apache.calcite.rel.RelVisitor;
import com.hazelcast.org.apache.calcite.rel.core.Collect;
import com.hazelcast.org.apache.calcite.rel.core.CorrelationId;
import com.hazelcast.org.apache.calcite.rel.core.RelFactories;
import com.hazelcast.org.apache.calcite.rel.core.Sample;
import com.hazelcast.org.apache.calcite.rel.core.Snapshot;
import com.hazelcast.org.apache.calcite.rel.core.Sort;
import com.hazelcast.org.apache.calcite.rel.core.TableScan;
import com.hazelcast.org.apache.calcite.rel.core.Uncollect;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalAggregate;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalCalc;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalCorrelate;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalExchange;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalFilter;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalIntersect;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalJoin;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalMatch;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalMinus;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalProject;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSnapshot;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSort;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalSortExchange;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalTableModify;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalUnion;
import com.hazelcast.org.apache.calcite.rel.logical.LogicalValues;
import com.hazelcast.org.apache.calcite.rel.stream.LogicalChi;
import com.hazelcast.org.apache.calcite.rel.stream.LogicalDelta;
import com.hazelcast.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.org.apache.calcite.rel.type.RelDataTypeField;
import com.hazelcast.org.apache.calcite.rex.RexBuilder;
import com.hazelcast.org.apache.calcite.rex.RexCall;
import com.hazelcast.org.apache.calcite.rex.RexCorrelVariable;
import com.hazelcast.org.apache.calcite.rex.RexFieldAccess;
import com.hazelcast.org.apache.calcite.rex.RexInputRef;
import com.hazelcast.org.apache.calcite.rex.RexLiteral;
import com.hazelcast.org.apache.calcite.rex.RexLocalRef;
import com.hazelcast.org.apache.calcite.rex.RexNode;
import com.hazelcast.org.apache.calcite.rex.RexProgram;
import com.hazelcast.org.apache.calcite.rex.RexProgramBuilder;
import com.hazelcast.org.apache.calcite.rex.RexShuttle;
import com.hazelcast.org.apache.calcite.rex.RexSubQuery;
import com.hazelcast.org.apache.calcite.rex.RexUtil;
import com.hazelcast.org.apache.calcite.sql.SqlKind;
import com.hazelcast.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.org.apache.calcite.sql.type.SqlTypeUtil;
import com.hazelcast.org.apache.calcite.tools.RelBuilder;
import com.hazelcast.org.apache.calcite.util.ImmutableBitSet;
import com.hazelcast.org.apache.calcite.util.Pair;
import com.hazelcast.org.apache.calcite.util.ReflectUtil;
import com.hazelcast.org.apache.calcite.util.ReflectiveVisitDispatcher;
import com.hazelcast.org.apache.calcite.util.ReflectiveVisitor;
import com.hazelcast.org.apache.calcite.util.Util;
import com.hazelcast.org.apache.calcite.util.mapping.Mappings;
import com.hazelcast.org.checkerframework.checker.nullness.qual.Nullable;
import com.hazelcast.org.checkerframework.common.value.qual.MinLen;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;

public class RelStructuredTypeFlattener
implements ReflectiveVisitor {
    private final RelBuilder relBuilder;
    private final RexBuilder rexBuilder;
    private final boolean restructure;
    private final Map<RelNode, RelNode> oldToNewRelMap = new HashMap<RelNode, RelNode>();
    private @Nullable RelNode currentRel;
    private int iRestructureInput;
    private @Nullable RelDataType flattenedRootType;
    boolean restructured;
    private final RelOptTable.ToRelContext toRelContext;

    @Deprecated
    public RelStructuredTypeFlattener(RexBuilder rexBuilder, RelOptTable.ToRelContext toRelContext, boolean restructure) {
        this(RelFactories.LOGICAL_BUILDER.create(toRelContext.getCluster(), null), rexBuilder, toRelContext, restructure);
    }

    public RelStructuredTypeFlattener(RelBuilder relBuilder, RexBuilder rexBuilder, RelOptTable.ToRelContext toRelContext, boolean restructure) {
        this.relBuilder = relBuilder;
        this.rexBuilder = rexBuilder;
        this.toRelContext = toRelContext;
        this.restructure = restructure;
    }

    private RelNode getCurrentRelOrThrow() {
        return Objects.requireNonNull(this.currentRel, "currentRel");
    }

    public void updateRelInMap(SortedSetMultimap<RelNode, CorrelationId> mapRefRelToCorVar) {
        for (RelNode rel : Lists.newArrayList(mapRefRelToCorVar.keySet())) {
            if (!this.oldToNewRelMap.containsKey(rel)) continue;
            Set corVarSet = mapRefRelToCorVar.removeAll(rel);
            mapRefRelToCorVar.putAll(this.oldToNewRelMap.get(rel), corVarSet);
        }
    }

    public void updateRelInMap(SortedMap<CorrelationId, LogicalCorrelate> mapCorVarToCorRel) {
        for (CorrelationId corVar : mapCorVarToCorRel.keySet()) {
            LogicalCorrelate oldRel = (LogicalCorrelate)mapCorVarToCorRel.get(corVar);
            if (!this.oldToNewRelMap.containsKey(oldRel)) continue;
            RelNode newRel = this.oldToNewRelMap.get(oldRel);
            assert (newRel instanceof LogicalCorrelate);
            mapCorVarToCorRel.put(corVar, (LogicalCorrelate)newRel);
        }
    }

    public RelNode rewrite(RelNode root) {
        RewriteRelVisitor visitor = new RewriteRelVisitor();
        visitor.visit(root, 0, null);
        RelNode flattened = this.getNewForOldRel(root);
        this.flattenedRootType = flattened.getRowType();
        if (this.restructure) {
            return this.tryRestructure(root, flattened);
        }
        return flattened;
    }

    private RelNode tryRestructure(RelNode root, RelNode flattened) {
        this.iRestructureInput = 0;
        this.restructured = false;
        List<RexNode> structuringExps = this.restructureFields(root.getRowType());
        if (this.restructured) {
            List<String> resultFieldNames = root.getRowType().getFieldNames();
            RelNode restructured = this.relBuilder.push(flattened).projectNamed(structuringExps, resultFieldNames, true).build();
            restructured = RelOptUtil.copyRelHints(flattened, restructured);
            return restructured;
        }
        return flattened;
    }

    private List<RexNode> restructureFields(RelDataType structuredType) {
        ArrayList<RexNode> structuringExps = new ArrayList<RexNode>();
        for (RelDataTypeField field : structuredType.getFieldList()) {
            RexNode expr;
            RelDataType fieldType = field.getType();
            if (fieldType.isStruct()) {
                this.restructured = true;
                expr = this.restructure(fieldType);
            } else {
                expr = new RexInputRef(this.iRestructureInput++, fieldType);
            }
            structuringExps.add(expr);
        }
        return structuringExps;
    }

    private RexNode restructure(RelDataType structuredType) {
        List<RexNode> structFields = this.restructureFields(structuredType);
        RexNode rowConstructor = this.rexBuilder.makeCall(structuredType, SqlStdOperatorTable.ROW, structFields);
        return rowConstructor;
    }

    protected void setNewForOldRel(RelNode oldRel, RelNode newRel) {
        newRel = RelOptUtil.copyRelHints(oldRel, newRel);
        this.oldToNewRelMap.put(oldRel, newRel);
    }

    protected RelNode getNewForOldRel(RelNode oldRel) {
        return Objects.requireNonNull(this.oldToNewRelMap.get(oldRel), () -> "newRel not found for " + oldRel);
    }

    protected int getNewForOldInput(int oldOrdinal) {
        return this.getNewFieldForOldInput((int)oldOrdinal).i;
    }

    private Ord<RelDataType> getNewFieldForOldInput(int oldOrdinal, int innerOrdinal) {
        int postFlatteningOrdinal = this.getCurrentRelOrThrow().getInputs().stream().flatMap(node -> node.getRowType().getFieldList().stream()).limit(oldOrdinal).map(RelDataTypeField::getType).mapToInt(this::postFlattenSize).sum();
        int newOrdinal = postFlatteningOrdinal + innerOrdinal;
        RelDataTypeField newField = this.getNewInputFieldByNewOrdinal(newOrdinal);
        return Ord.of(newOrdinal, newField.getType());
    }

    private RelDataTypeField getNewInputFieldByNewOrdinal(int newOrdinal) {
        return (RelDataTypeField)this.getCurrentRelOrThrow().getInputs().stream().map(this::getNewForOldRel).flatMap(node -> node.getRowType().getFieldList().stream()).skip(newOrdinal).findFirst().orElseThrow(NoSuchElementException::new);
    }

    private boolean noFlatteningForInput(int fieldIdx) {
        List<RelNode> inputs = this.getCurrentRelOrThrow().getInputs();
        int fieldCnt = 0;
        for (RelNode input : inputs) {
            if ((fieldCnt += input.getRowType().getFieldCount()) <= fieldIdx) continue;
            return this.getNewForOldRel(input).getRowType().getFieldList().size() == input.getRowType().getFieldList().size();
        }
        return false;
    }

    protected Ord<RelDataType> getNewFieldForOldInput(int oldOrdinal) {
        return this.getNewFieldForOldInput(oldOrdinal, 0);
    }

    private Mappings.TargetMapping getNewForOldInputMapping(RelNode oldRel) {
        RelNode newRel = this.getNewForOldRel(oldRel);
        return Mappings.target(this::getNewForOldInput, oldRel.getRowType().getFieldCount(), newRel.getRowType().getFieldCount());
    }

    private int getPostFlatteningOrdinal(RelDataType preFlattenRowType, int preFlattenOrdinal) {
        return preFlattenRowType.getFieldList().stream().limit(preFlattenOrdinal).map(RelDataTypeField::getType).mapToInt(this::postFlattenSize).sum();
    }

    private int postFlattenSize(RelDataType type) {
        if (type.isStruct()) {
            return type.getFieldList().stream().map(RelDataTypeField::getType).mapToInt(this::postFlattenSize).sum();
        }
        return 1;
    }

    public void rewriteRel(LogicalTableModify rel) {
        LogicalTableModify newRel = LogicalTableModify.create(rel.getTable(), rel.getCatalogReader(), this.getNewForOldRel(rel.getInput()), rel.getOperation(), rel.getUpdateColumnList(), rel.getSourceExpressionList(), true);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalAggregate rel) {
        RelNode oldInput = rel.getInput();
        RelDataType inputType = oldInput.getRowType();
        List<RelDataTypeField> inputTypeFields = inputType.getFieldList();
        if (SqlTypeUtil.isFlat(inputType) || rel.getAggCallList().stream().allMatch(call -> call.getArgList().isEmpty() || call.getArgList().stream().noneMatch(idx -> ((RelDataTypeField)inputTypeFields.get((int)idx)).getType().isStruct()))) {
            this.rewriteGeneric(rel);
        } else {
            RelNode restructuredInput = this.tryRestructure(oldInput, this.getNewForOldRel(oldInput));
            RelNode newRel = rel.copy(rel.getTraitSet(), restructuredInput, rel.getGroupSet(), rel.getGroupSets(), (List)rel.getAggCallList());
            if (!SqlTypeUtil.isFlat(rel.getRowType())) {
                newRel = this.coverNewRelByFlatteningProjection(rel, newRel);
            }
            this.setNewForOldRel(rel, newRel);
        }
    }

    public void rewriteRel(Sort rel) {
        RelCollation oldCollation = rel.getCollation();
        RelNode oldChild = rel.getInput();
        RelNode newChild = this.getNewForOldRel(oldChild);
        Mappings.TargetMapping mapping = this.getNewForOldInputMapping(oldChild);
        for (RelFieldCollation field : oldCollation.getFieldCollations()) {
            int oldInput = field.getFieldIndex();
            RelDataType sortFieldType = oldChild.getRowType().getFieldList().get(oldInput).getType();
            if (!sortFieldType.isStruct()) continue;
            throw Util.needToImplement("sorting on structured types");
        }
        RelCollation newCollation = RexUtil.apply(mapping, oldCollation);
        LogicalSort newRel = LogicalSort.create(newChild, newCollation, rel.offset, rel.fetch);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalFilter rel) {
        RelTraitSet traits = rel.getTraitSet();
        RewriteRexShuttle rewriteRexShuttle = new RewriteRexShuttle();
        RexNode oldCondition = rel.getCondition();
        RelNode newInput = this.getNewForOldRel(rel.getInput());
        RexNode newCondition = oldCondition.accept(rewriteRexShuttle);
        LogicalFilter newRel = rel.copy(traits, newInput, newCondition);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalJoin rel) {
        LogicalJoin newRel = LogicalJoin.create(this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), rel.getHints(), rel.getCondition().accept(new RewriteRexShuttle()), rel.getVariablesSet(), rel.getJoinType());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalCorrelate rel) {
        ImmutableBitSet.Builder newPos = ImmutableBitSet.builder();
        for (int pos : rel.getRequiredColumns()) {
            RelDataType corrFieldType = rel.getLeft().getRowType().getFieldList().get(pos).getType();
            if (corrFieldType.isStruct()) {
                throw Util.needToImplement("correlation on structured type");
            }
            newPos.set(this.getNewForOldInput(pos));
        }
        LogicalCorrelate newRel = LogicalCorrelate.create(this.getNewForOldRel(rel.getLeft()), this.getNewForOldRel(rel.getRight()), rel.getHints(), rel.getCorrelationId(), newPos.build(), rel.getJoinType());
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(Collect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(Uncollect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalIntersect rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalMinus rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalUnion rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalValues rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalTableFunctionScan rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(Sample rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalProject rel) {
        RewriteRexShuttle shuttle = new RewriteRexShuttle();
        List<RexNode> oldProjects = rel.getProjects();
        List<String> oldNames = rel.getRowType().getFieldNames();
        ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
        this.flattenProjections(shuttle, oldProjects, oldNames, "", flattenedExpList);
        RelNode newInput = this.getNewForOldRel(rel.getInput());
        List<RexNode> newProjects = Pair.left(flattenedExpList);
        List<String> newNames = Pair.right(flattenedExpList);
        RelNode newRel = this.relBuilder.push(newInput).projectNamed(newProjects, newNames, true).hints(rel.getHints()).build();
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalCalc rel) {
        RelNode newInput = this.getNewForOldRel(rel.getInput());
        RelOptCluster cluster = rel.getCluster();
        RexProgramBuilder programBuilder = new RexProgramBuilder(newInput.getRowType(), cluster.getRexBuilder());
        RexProgram program = rel.getProgram();
        RewriteRexShuttle shuttle = new RewriteRexShuttle();
        for (RexNode expr : program.getExprList()) {
            programBuilder.registerInput(expr.accept(shuttle));
        }
        ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
        List<String> fieldNames = rel.getRowType().getFieldNames();
        this.flattenProjections(new RewriteRexShuttle(), program.getProjectList(), fieldNames, "", flattenedExpList);
        for (Pair pair : flattenedExpList) {
            programBuilder.addProject((RexNode)pair.left, (String)pair.right);
        }
        RexLocalRef conditionRef = program.getCondition();
        if (conditionRef != null) {
            Ord<RelDataType> ord = this.getNewFieldForOldInput(conditionRef.getIndex());
            programBuilder.addCondition(new RexLocalRef(ord.i, (RelDataType)ord.e));
        }
        RexProgram rexProgram = programBuilder.getProgram();
        LogicalCalc newRel = LogicalCalc.create(newInput, rexProgram);
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(SelfFlatteningRel rel) {
        rel.flattenRel(this);
    }

    public void rewriteRel(LogicalExchange rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalSortExchange rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteGeneric(RelNode rel) {
        RelNode newRel = rel.copy(rel.getTraitSet(), rel.getInputs());
        List<RelNode> oldInputs = rel.getInputs();
        for (int i = 0; i < oldInputs.size(); ++i) {
            newRel.replaceInput(i, this.getNewForOldRel(oldInputs.get(i)));
        }
        this.setNewForOldRel(rel, newRel);
    }

    private void flattenProjections(RewriteRexShuttle shuttle, List<? extends RexNode> exps, @Nullable List<? extends @Nullable String> fieldNames, String prefix, List<Pair<RexNode, String>> flattenedExps) {
        for (int i = 0; i < exps.size(); ++i) {
            RexNode exp = exps.get(i);
            String fieldName = RelStructuredTypeFlattener.extractName(fieldNames, prefix, i);
            this.flattenProjection(shuttle, exp, fieldName, flattenedExps);
        }
    }

    private static String extractName(@Nullable List<? extends @Nullable String> fieldNames, String prefix, int i) {
        String fieldName;
        String string = fieldName = fieldNames == null || fieldNames.get(i) == null ? "$" + i : fieldNames.get(i);
        if (!prefix.equals("")) {
            fieldName = prefix + "$" + fieldName;
        }
        return fieldName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void flattenProjection(RewriteRexShuttle shuttle, RexNode exp, String fieldName, List<Pair<RexNode, String>> flattenedExps) {
        if (exp.getType().isStruct()) {
            if (exp instanceof RexInputRef) {
                int oldOrdinal = ((RexInputRef)exp).getIndex();
                int flattenFieldsCount = this.postFlattenSize(exp.getType());
                for (int innerOrdinal = 0; innerOrdinal < flattenFieldsCount; ++innerOrdinal) {
                    Ord<RelDataType> newField = this.getNewFieldForOldInput(oldOrdinal, innerOrdinal);
                    RexInputRef newRef = new RexInputRef(newField.i, (RelDataType)newField.e);
                    flattenedExps.add(Pair.of(newRef, fieldName));
                }
                return;
            }
            if (RelStructuredTypeFlattener.isConstructor(exp) || exp.isA(SqlKind.CAST)) {
                RexCall call = (RexCall)exp;
                if (exp.isA(SqlKind.CAST) && RexLiteral.isNullLiteral((RexNode)call.operands.get(0))) {
                    this.flattenNullLiteral(exp.getType(), flattenedExps);
                    return;
                }
                this.flattenProjections(shuttle, call.getOperands(), Collections.nCopies(call.getOperands().size(), null), fieldName, flattenedExps);
                return;
            }
            if (!(exp instanceof RexCall)) throw Util.needToImplement(exp);
            RexNode newExp = exp;
            List<RexNode> operands = ((RexCall)exp).getOperands();
            SqlOperator operator = ((RexCall)exp).getOperator();
            if (operator == SqlStdOperatorTable.ITEM && operands.get(0).getType().isStruct() && operands.get(1).isA(SqlKind.LITERAL) && SqlTypeUtil.inCharFamily(operands.get(1).getType())) {
                String literalString = ((RexLiteral)operands.get(1)).getValueAs(String.class);
                RexNode firstOp = operands.get(0);
                if (firstOp instanceof RexInputRef) {
                    int from = 0;
                    for (RelDataTypeField field : firstOp.getType().getFieldList()) {
                        if (field.getName().equalsIgnoreCase(literalString)) {
                            int oldOrdinal = ((RexInputRef)firstOp).getIndex();
                            int to = from + this.postFlattenSize(field.getType());
                            for (int newInnerOrdinal = from; newInnerOrdinal < to; ++newInnerOrdinal) {
                                Ord<RelDataType> newField = this.getNewFieldForOldInput(oldOrdinal, newInnerOrdinal);
                                RexInputRef newRef = this.rexBuilder.makeInputRef((RelDataType)newField.e, newField.i);
                                flattenedExps.add(Pair.of(newRef, fieldName));
                            }
                            return;
                        }
                        from += this.postFlattenSize(field.getType());
                    }
                    return;
                }
                if (!(firstOp instanceof RexCall)) return;
                ArrayList<Pair<RexNode, String>> firstOpFlattenedExps = new ArrayList<Pair<RexNode, String>>();
                this.flattenProjection(shuttle, firstOp, fieldName + "$0", firstOpFlattenedExps);
                int newInnerOrdinal = this.getNewInnerOrdinal(firstOp, literalString);
                int endOfRange = newInnerOrdinal + this.postFlattenSize(newExp.getType());
                for (int i = newInnerOrdinal; i < endOfRange; ++i) {
                    flattenedExps.add((Pair<RexNode, String>)firstOpFlattenedExps.get(i));
                }
                return;
            }
            newExp = this.rexBuilder.makeCall(exp.getType(), operator, shuttle.visitList(operands));
            this.flattenResultTypeOfRexCall(newExp, fieldName, flattenedExps);
            return;
        }
        flattenedExps.add(Pair.of(exp.accept(shuttle), fieldName));
    }

    private void flattenResultTypeOfRexCall(RexNode newExp, String fieldName, List<Pair<RexNode, String>> flattenedExps) {
        int nameIdx = 0;
        for (RelDataTypeField field : newExp.getType().getFieldList()) {
            RexNode fieldRef = this.rexBuilder.makeFieldAccess(newExp, field.getIndex());
            String fieldRefName = fieldName + "$" + nameIdx++;
            if (fieldRef.getType().isStruct()) {
                this.flattenResultTypeOfRexCall(fieldRef, fieldRefName, flattenedExps);
                continue;
            }
            flattenedExps.add(Pair.of(fieldRef, fieldRefName));
        }
    }

    private void flattenNullLiteral(RelDataType type, List<Pair<RexNode, String>> flattenedExps) {
        RelDataType flattenedType = SqlTypeUtil.flattenRecordType(this.rexBuilder.getTypeFactory(), type, null);
        for (RelDataTypeField field : flattenedType.getFieldList()) {
            flattenedExps.add(Pair.of(this.rexBuilder.makeNullLiteral(field.getType()), field.getName()));
        }
    }

    private static boolean isConstructor(RexNode rexNode) {
        if (!(rexNode instanceof RexCall)) {
            return false;
        }
        RexCall call = (RexCall)rexNode;
        return call.getOperator().getName().equalsIgnoreCase("row") || call.isA(SqlKind.NEW_SPECIFICATION);
    }

    public void rewriteRel(TableScan rel) {
        RelNode newRel = rel.getTable().toRel(this.toRelContext);
        if (!SqlTypeUtil.isFlat(rel.getRowType())) {
            newRel = this.coverNewRelByFlatteningProjection(rel, newRel);
        }
        this.setNewForOldRel(rel, newRel);
    }

    private RelNode coverNewRelByFlatteningProjection(RelNode rel, RelNode newRel) {
        ArrayList<Pair<RexNode, String>> flattenedExpList = new ArrayList<Pair<RexNode, String>>();
        RexNode newRowRef = this.rexBuilder.makeRangeReference(newRel);
        List<RelDataTypeField> inputRowFields = rel.getRowType().getFieldList();
        this.flattenInputs(inputRowFields, newRowRef, flattenedExpList);
        List<RexNode> projects = Pair.left(flattenedExpList);
        List<String> fieldNames = Pair.right(flattenedExpList);
        newRel = this.relBuilder.push(newRel).projectNamed(projects, fieldNames, true).build();
        return newRel;
    }

    public void rewriteRel(LogicalSnapshot rel) {
        Snapshot newRel = rel.copy(rel.getTraitSet(), this.getNewForOldRel(rel.getInput()), rel.getPeriod().accept(new RewriteRexShuttle()));
        this.setNewForOldRel(rel, newRel);
    }

    public void rewriteRel(LogicalDelta rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalChi rel) {
        this.rewriteGeneric(rel);
    }

    public void rewriteRel(LogicalMatch rel) {
        this.rewriteGeneric(rel);
    }

    private void flattenInputs(List<RelDataTypeField> fieldList, RexNode prefix, List<Pair<RexNode, String>> flattenedExpList) {
        for (RelDataTypeField field : fieldList) {
            RexNode ref = this.rexBuilder.makeFieldAccess(prefix, field.getIndex());
            if (field.getType().isStruct()) {
                List<RelDataTypeField> structFields = field.getType().getFieldList();
                this.flattenInputs(structFields, ref, flattenedExpList);
                continue;
            }
            flattenedExpList.add(Pair.of(ref, field.getName()));
        }
    }

    private int getNewInnerOrdinal(RexNode firstOp, @Nullable String literalString) {
        int newInnerOrdinal = 0;
        for (RelDataTypeField field : firstOp.getType().getFieldList()) {
            if (field.getName().equalsIgnoreCase(literalString)) break;
            newInnerOrdinal += this.postFlattenSize(field.getType());
        }
        return newInnerOrdinal;
    }

    private class RewriteRexShuttle
    extends RexShuttle {
        private RewriteRexShuttle() {
        }

        @Override
        public RexNode visitInputRef(RexInputRef input) {
            int oldIndex = input.getIndex();
            Ord<RelDataType> field = RelStructuredTypeFlattener.this.getNewFieldForOldInput(oldIndex);
            RelDataTypeField inputFieldByOldIndex = (RelDataTypeField)RelStructuredTypeFlattener.this.getCurrentRelOrThrow().getInputs().stream().flatMap(relInput -> relInput.getRowType().getFieldList().stream()).skip(oldIndex).findFirst().orElseThrow(() -> new AssertionError((Object)"Found input ref with index not found in old inputs"));
            if (inputFieldByOldIndex.getType().isStruct()) {
                RelStructuredTypeFlattener.this.iRestructureInput = field.i;
                List rexNodes = RelStructuredTypeFlattener.this.restructureFields(inputFieldByOldIndex.getType());
                return RelStructuredTypeFlattener.this.rexBuilder.makeCall(inputFieldByOldIndex.getType(), SqlStdOperatorTable.ROW, rexNodes);
            }
            RelDataType fieldType = this.removeDistinct((RelDataType)field.e);
            return new RexInputRef(field.i, fieldType);
        }

        private RelDataType removeDistinct(RelDataType type) {
            if (type.getSqlTypeName() != SqlTypeName.DISTINCT) {
                return type;
            }
            return type.getFieldList().get(0).getType();
        }

        @Override
        public RexNode visitFieldAccess(RexFieldAccess fieldAccess) {
            RexNode refExp;
            int iInput = 0;
            ArrayDeque<Integer> accessOrdinals = new ArrayDeque<Integer>();
            while (true) {
                refExp = fieldAccess.getReferenceExpr();
                int ordinal = fieldAccess.getField().getIndex();
                accessOrdinals.push(ordinal);
                iInput += RelStructuredTypeFlattener.this.getPostFlatteningOrdinal(refExp.getType(), ordinal);
                if (refExp instanceof RexInputRef) {
                    RexInputRef inputRef = (RexInputRef)refExp;
                    if (RelStructuredTypeFlattener.this.noFlatteningForInput(inputRef.getIndex())) {
                        return fieldAccess;
                    }
                    Ord newField = RelStructuredTypeFlattener.this.getNewFieldForOldInput(inputRef.getIndex(), iInput);
                    return new RexInputRef(newField.getKey(), this.removeDistinct((RelDataType)newField.getValue()));
                }
                if (refExp instanceof RexCorrelVariable) {
                    RelDataType refType = SqlTypeUtil.flattenRecordType(RelStructuredTypeFlattener.this.rexBuilder.getTypeFactory(), refExp.getType(), null);
                    refExp = RelStructuredTypeFlattener.this.rexBuilder.makeCorrel(refType, ((RexCorrelVariable)refExp).id);
                    return RelStructuredTypeFlattener.this.rexBuilder.makeFieldAccess(refExp, iInput);
                }
                if (refExp instanceof RexCall) {
                    RexCall call = (RexCall)refExp;
                    RexNode newRefExp = this.visitCall(call);
                    for (Integer ord : accessOrdinals) {
                        newRefExp = RelStructuredTypeFlattener.this.rexBuilder.makeFieldAccess(newRefExp, ord);
                    }
                    return newRefExp;
                }
                if (!(refExp instanceof RexFieldAccess)) break;
                fieldAccess = (RexFieldAccess)refExp;
            }
            throw Util.needToImplement(refExp);
        }

        @Override
        public RexNode visitCall(RexCall rexCall) {
            if (rexCall.isA(SqlKind.CAST)) {
                RexNode input = rexCall.getOperands().get(0).accept(this);
                RelDataType targetType = this.removeDistinct(rexCall.getType());
                return RelStructuredTypeFlattener.this.rexBuilder.makeCast(targetType, input);
            }
            if (rexCall.op == SqlStdOperatorTable.ITEM && ((RexNode)rexCall.operands.get(0)).getType().isStruct() && ((RexNode)rexCall.operands.get(1)).isA(SqlKind.LITERAL) && SqlTypeUtil.inCharFamily(((RexNode)rexCall.operands.get(1)).getType())) {
                RexNode firstOp = (RexNode)rexCall.operands.get(0);
                String literalString = ((RexLiteral)rexCall.operands.get(1)).getValueAs(String.class);
                if (firstOp instanceof RexInputRef) {
                    int oldOrdinal = ((RexInputRef)firstOp).getIndex();
                    int newInnerOrdinal = RelStructuredTypeFlattener.this.getNewInnerOrdinal(firstOp, literalString);
                    Ord newField = RelStructuredTypeFlattener.this.getNewFieldForOldInput(oldOrdinal, newInnerOrdinal);
                    RexInputRef newRef = RelStructuredTypeFlattener.this.rexBuilder.makeInputRef((RelDataType)newField.e, newField.i);
                    return newRef;
                }
                RexNode newFirstOp = firstOp.accept(this);
                if (newFirstOp instanceof RexInputRef) {
                    int newRefOrdinal = ((RexInputRef)newFirstOp).getIndex() + RelStructuredTypeFlattener.this.getNewInnerOrdinal(firstOp, literalString);
                    RelDataTypeField newField = RelStructuredTypeFlattener.this.getNewInputFieldByNewOrdinal(newRefOrdinal);
                    RexInputRef newRef = RelStructuredTypeFlattener.this.rexBuilder.makeInputRef(newField.getType(), newRefOrdinal);
                    return newRef;
                }
            }
            if (!rexCall.isA(SqlKind.COMPARISON)) {
                return super.visitCall(rexCall);
            }
            RexNode lhs = rexCall.getOperands().get(0);
            if (!lhs.getType().isStruct()) {
                return super.visitCall(rexCall);
            }
            return this.flattenComparison(RelStructuredTypeFlattener.this.rexBuilder, rexCall.getOperator(), rexCall.getOperands());
        }

        @Override
        public RexNode visitSubQuery(RexSubQuery subQuery) {
            subQuery = (RexSubQuery)super.visitSubQuery(subQuery);
            RelStructuredTypeFlattener flattener = new RelStructuredTypeFlattener(RelStructuredTypeFlattener.this.relBuilder, RelStructuredTypeFlattener.this.rexBuilder, RelStructuredTypeFlattener.this.toRelContext, RelStructuredTypeFlattener.this.restructure);
            RelNode rel = flattener.rewrite(subQuery.rel);
            return subQuery.clone(rel);
        }

        private RexNode flattenComparison(RexBuilder rexBuilder, SqlOperator op, @MinLen(value=1) List<RexNode> exprs) {
            ArrayList flattenedExps = new ArrayList();
            RelStructuredTypeFlattener.this.flattenProjections(this, exprs, null, "", flattenedExps);
            int n = flattenedExps.size() / 2;
            if (n == 0) {
                throw new IllegalArgumentException("exprs must be non-empty");
            }
            boolean negate = false;
            if (op.getKind() == SqlKind.NOT_EQUALS) {
                negate = true;
                op = SqlStdOperatorTable.EQUALS;
            }
            if (n > 1 && op.getKind() != SqlKind.EQUALS) {
                throw Util.needToImplement("inequality comparison for row types");
            }
            RexNode conjunction = null;
            for (int i = 0; i < n; ++i) {
                RexNode comparison = rexBuilder.makeCall(op, (RexNode)((Pair)flattenedExps.get((int)i)).left, (RexNode)((Pair)flattenedExps.get((int)(i + n))).left);
                conjunction = conjunction == null ? comparison : rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.AND, conjunction, comparison);
            }
            Objects.requireNonNull(conjunction, "conjunction must be non-null");
            if (negate) {
                return rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.NOT, conjunction);
            }
            return conjunction;
        }
    }

    private class RewriteRelVisitor
    extends RelVisitor {
        private final ReflectiveVisitDispatcher<RelStructuredTypeFlattener, RelNode> dispatcher = ReflectUtil.createDispatcher(RelStructuredTypeFlattener.class, RelNode.class);

        private RewriteRelVisitor() {
        }

        @Override
        public void visit(RelNode p, int ordinal, @Nullable RelNode parent) {
            super.visit(p, ordinal, parent);
            RelStructuredTypeFlattener.this.currentRel = p;
            String visitMethodName = "rewriteRel";
            boolean found = this.dispatcher.invokeVisitor(RelStructuredTypeFlattener.this, RelStructuredTypeFlattener.this.currentRel, "rewriteRel");
            RelStructuredTypeFlattener.this.currentRel = null;
            if (!found) {
                if (p.getInputs().size() == 0) {
                    RelStructuredTypeFlattener.this.rewriteGeneric(p);
                } else {
                    throw new AssertionError((Object)("no 'rewriteRel' method found for class " + p.getClass().getName()));
                }
            }
        }
    }

    public static interface SelfFlatteningRel
    extends RelNode {
        public void flattenRel(RelStructuredTypeFlattener var1);
    }
}

